/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.menu;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuBoundRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuNodeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeCustomRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuBoundSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuTreeSaveVO;
import com.elitescloud.cloudt.system.service.MenuMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u81ea\u5b9a\u4e49\u83dc\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/menu"}, produces={"application/json"})
@Validated
public class CustomMenuMngController {
    private final MenuMngService menuMngService;

    public CustomMenuMngController(MenuMngService menuMngService) {
        this.menuMngService = menuMngService;
    }

    @ApiOperation(value="\u83b7\u53d6\u662f\u5426\u542f\u7528\u81ea\u5b9a\u4e49\u83dc\u5355\u6811")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/tree/custom/enabled"})
    public ApiResult<Boolean> getEnabledCustom() {
        return this.menuMngService.getCustomEnabled();
    }

    @ApiOperation(value="\u5207\u6362\u662f\u5426\u542f\u7528\u81ea\u5b9a\u4e49\u83dc\u5355\u6811")
    @ApiOperationSupport(order=2)
    @PatchMapping(value={"/customEnabled"})
    public ApiResult<Boolean> switchEnabled() {
        return this.menuMngService.updateEnabledCustom();
    }

    @ApiOperation(value="\u6e05\u7a7a\u81ea\u5b9a\u4e49\u83dc\u5355")
    @ApiOperationSupport(order=3)
    @DeleteMapping(value={"/custom/tree"})
    public ApiResult<Boolean> deleteAll() {
        return this.menuMngService.removeAllCustom();
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u83dc\u5355\u6811")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean", defaultValue="true")
    @GetMapping(value={"/custom/tree"})
    public ApiResult<List<CustomMenuTreeRespVO>> getCustomMenuTree(@RequestParam(name="tree", defaultValue="true") Boolean tree) {
        return this.menuMngService.getCustomMenuTree(tree);
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u6811\u7684\u8282\u70b9\u4fe1\u606f")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u83dc\u5355ID", dataType="long", required=true)
    @GetMapping(value={"/custom/tree/node"})
    public ApiResult<CustomMenuNodeDetailRespVO> getNodeDetail(Long id) {
        return this.menuMngService.getCustomNodeDetail(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u83dc\u5355\u5206\u7ec4")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/custom/group"})
    public ApiResult<Long> saveCustomMenuTree(@Valid @RequestBody CustomMenuGroupSaveVO saveVO) {
        return this.menuMngService.saveCustomMenuGroup(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ec4\u5217\u8868")
    @ApiOperationSupport(order=6)
    @GetMapping(value={"/custom/groupList"})
    public ApiResult<List<IdCodeNameParam>> listGroup() {
        return this.menuMngService.listGroup();
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u83dc\u5355\u5206\u7ec4\u7684\u7f16\u8f91\u4fe1\u606f")
    @ApiOperationSupport(order=7)
    @GetMapping(value={"/custom/group"})
    public ApiResult<CustomMenuEditRespVO> getEdit(Long id) {
        return this.menuMngService.getCustomEdit(id);
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u7684\u542f\u7528\u72b6\u6001")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u83dc\u5355ID", dataType="long", required=true), @ApiImplicitParam(name="enabled", value="\u662f\u5426\u542f\u7528", dataType="boolean", required=true)})
    @PatchMapping(value={"/custom/enabled"})
    public ApiResult<Long> updateEnabled(@RequestParam(name="id") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") Long id, @RequestParam(name="enabled") @NotNull(message="\u542f\u7528\u72b6\u6001\u4e3a\u7a7a") @NotNull(message="\u542f\u7528\u72b6\u6001\u4e3a\u7a7a") Boolean enabled) {
        return this.menuMngService.updateCustomEnabled(id, enabled);
    }

    @ApiOperation(value="\u4fee\u6539\u83dc\u5355\u7684\u81ea\u5b9a\u4e49\u540d\u79f0")
    @ApiOperationSupport(order=8)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u83dc\u5355ID", dataType="long", required=true), @ApiImplicitParam(name="customName", value="\u81ea\u5b9a\u4e49\u540d\u79f0")})
    @PatchMapping(value={"/custom/name"})
    public ApiResult<Long> updateName(@RequestParam(name="id") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") Long id, @RequestParam(name="customName", required=false) String customName) {
        return this.menuMngService.updateCustomName(id, customName);
    }

    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355")
    @ApiOperationSupport(order=9)
    @ApiImplicitParam(name="cascade", value="\u662f\u5426\u7ea7\u8054\u5220\u9664", defaultValue="true", dataType="boolean")
    @DeleteMapping(value={"/custom"})
    public ApiResult<List<Long>> remove(@RequestBody @NotEmpty(message="ID\u4e3a\u7a7a") @NotEmpty(message="ID\u4e3a\u7a7a") List<Long> ids, @RequestParam(name="cascade", required=false, defaultValue="true") Boolean cascade) {
        return this.menuMngService.removeCustom(ids, cascade);
    }

    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u83dc\u5355\u7684\u4e0b\u7ea7\u83dc\u5355")
    @ApiOperationSupport(order=9)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u83dc\u5355ID", dataType="long", required=true), @ApiImplicitParam(name="withSelf", value="\u662f\u5426\u5220\u9664\u81ea\u5df1", defaultValue="false", dataType="boolean")})
    @DeleteMapping(value={"/custom/children"})
    public ApiResult<Long> remove(@RequestParam(name="id") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") Long id, @RequestParam(name="withSelf", required=false, defaultValue="false") Boolean withSelf) {
        return this.menuMngService.removeCustomChildren(id, withSelf);
    }

    @ApiOperation(value="\u79fb\u52a8\u83dc\u5355")
    @ApiOperationSupport(order=10)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u83dc\u5355ID", dataType="long", required=true), @ApiImplicitParam(name="newParentId", value="\u65b0\u7684\u4e0a\u7ea7\u83dc\u5355ID", dataType="long"), @ApiImplicitParam(name="sortNo", value="\u6392\u5e8f\u53f7", dataType="int")})
    @DeleteMapping(value={"/custom/move"})
    public ApiResult<Long> moveCustom(@RequestParam(name="id") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") @NotNull(message="\u83dc\u5355ID\u4e3a\u7a7a") Long id, @RequestParam(name="newParentId", required=false) Long newParentId, @RequestParam(name="sortNo", required=false) Integer sortNo) {
        return this.menuMngService.moveCustom(id, newParentId, sortNo);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ec4\u4e0b\u7ed1\u5b9a\u7684\u83dc\u5355")
    @ApiOperationSupport(order=11)
    @ApiImplicitParam(name="code", value="\u5206\u7ec4\u7f16\u7801", required=true)
    @GetMapping(value={"/custom/menu/bound"})
    public ApiResult<List<CustomMenuBoundRespVO>> getBoundMenus(@RequestParam(name="code") @NotBlank(message="\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a") String code) {
        return this.menuMngService.getBoundMenus(code);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5206\u7ec4\u4e0b\u7ed1\u5b9a\u7684\u83dc\u5355")
    @ApiOperationSupport(order=12)
    @PostMapping(value={"/custom/menu/bound"})
    public ApiResult<String> saveBoundMenus(@RequestBody @Valid CustomMenuBoundSaveVO saveVO) {
        return this.menuMngService.saveBoundMenus(saveVO);
    }

    @GetMapping(value={"/custom/export"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", produces="application/octet-stream")
    @ApiOperationSupport(order=13)
    public HttpEntity<StreamingResponseBody> exportData() {
        return this.menuMngService.export();
    }

    @PostMapping(value={"/custom/import"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @ApiOperationSupport(order=14)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6570\u636e\u6587\u4ef6", required=true), @ApiImplicitParam(name="increment", value="\u662f\u5426\u662f\u589e\u91cf", dataType="boolean")})
    public ApiResult<Boolean> importData(@NotNull(message="\u6570\u636e\u6587\u4ef6\u4e3a\u7a7a") @RequestParam(name="file") @NotNull(message="\u6570\u636e\u6587\u4ef6\u4e3a\u7a7a") MultipartFile file, @RequestParam(name="increment", required=false, defaultValue="false") Boolean increment) {
        return this.menuMngService.importByFile(file, increment);
    }

    @PostMapping(value={"/custom/importByMenu"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355\u5bfc\u5165\u6570\u636e")
    @ApiOperationSupport(order=15)
    public ApiResult<Boolean> importData() {
        return this.menuMngService.importByPlatformMenu();
    }

    @Deprecated(since="3.3.0")
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u9ed8\u8ba4\u83dc\u5355\u6811")
    @ApiOperationSupport(order=1)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean", defaultValue="true")
    @GetMapping(value={"/tree/default"})
    public ApiResult<List<MenuTreeRespVO>> getTreeDefault(@RequestParam(name="tree", defaultValue="true") Boolean tree) {
        return this.menuMngService.getTreeDefault(tree);
    }

    @Deprecated(since="3.3.0")
    @ApiIgnore
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u83dc\u5355\u6811")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean", defaultValue="true")
    @GetMapping(value={"/tree/custom"})
    public ApiResult<List<MenuTreeCustomRespVO>> getTreeCustom(@RequestParam(name="tree", defaultValue="true") Boolean tree) {
        return this.menuMngService.getTreeCustom(tree);
    }

    @Deprecated(since="3.3.0")
    @ApiIgnore
    @ApiOperation(value="\u4fdd\u5b58\u83dc\u5355\u6811")
    @ApiOperationSupport(order=4)
    @PostMapping(value={"/tree/save"})
    public ApiResult<Boolean> saveTree(@RequestBody @Valid List<MenuTreeSaveVO> saveVOList) {
        return this.menuMngService.saveTree(saveVOList);
    }
}

