/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.role;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.api.SysMenuApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.DataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.SysDprRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeUserInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.permission.DataPermissionTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.PermissionDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.PermissionMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.UserRoleDataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.UserRoleMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.MenuApiSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.OrgRolePermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RolePermissionCopySaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RolePermissionPropagationSaveVO;
import com.elitescloud.cloudt.system.service.PermissionMngService;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"\u6743\u9650\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/permission"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_RolePermission:\u89d2\u8272\u529f\u80fd\u6743\u9650")
public class PermissionMngController {
    private final PermissionQueryService permissionQueryService;
    private final PermissionMngService permissionMngService;

    public PermissionMngController(PermissionQueryService permissionQueryService, PermissionMngService permissionMngService) {
        this.permissionQueryService = permissionQueryService;
        this.permissionMngService = permissionMngService;
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7ec4\u53ca\u89d2\u8272")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="showDisabled", value="\u662f\u5426\u663e\u793a\u7981\u7528\u7684", defaultValue="false"), @ApiImplicitParam(name="showAll", value="\u662f\u5426\u67e5\u8be2\u6240\u6709\u7684", defaultValue="false")})
    @GetMapping(value={"/listGroupRole"})
    public ApiResult<List<GroupRoleRespVO>> listGroupRole(@RequestParam(name="showDisabled", required=false, defaultValue="false") Boolean showDisabled, @RequestParam(name="showAll", required=false, defaultValue="false") Boolean showAll) {
        return this.permissionQueryService.listGroupRole(showDisabled, showAll);
    }

    @ApiOperation(value="\u6839\u636e\u5173\u8054\u7684\u5bf9\u8c61\u83b7\u53d6\u89d2\u8272\u7ec4\u53ca\u89d2\u8272")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="relatedCode", value="\u5173\u8054\u7ec4\u7ec7\u7f16\u7801")})
    @GetMapping(value={"/listGroupRoleByRelated"})
    public ApiResult<List<GroupRoleRespVO>> listGroupRole(@RequestParam(name="relatedType", required=false, defaultValue="org") @ApiIgnore String relatedType, @RequestParam(name="relatedCode", required=false) String relatedId) {
        return this.permissionQueryService.listGroupRoleByRelated(relatedType, relatedId);
    }

    @ApiOperation(value="\u5411\u89d2\u8272\u4e2d\u6dfb\u52a0\u8d26\u53f7")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true), @ApiImplicitParam(name="incremental", value="\u662f\u5426\u4e3a\u589e\u91cf\u64cd\u4f5c", dataType="boolean", required=true, defaultValue="true")})
    @PostMapping(value={"/role/users"})
    public ApiResult<Long> addRoleUser(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="incremental", required=false, defaultValue="true") Boolean incremental, @RequestBody @NotEmpty(message="\u8bf7\u9009\u62e9\u8d26\u53f7") @NotEmpty(message="\u8bf7\u9009\u62e9\u8d26\u53f7") List<Long> userIds) {
        return this.permissionMngService.saveRoleUser(roleId, userIds, incremental);
    }

    @ApiOperation(value="\u5411\u89d2\u8272\u4e2d\u6dfb\u52a0\u5458\u5de5")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true), @ApiImplicitParam(name="incremental", value="\u662f\u5426\u4e3a\u589e\u91cf\u64cd\u4f5c", dataType="boolean", required=true, defaultValue="true")})
    @PostMapping(value={"/role/employee"})
    public ApiResult<Long> addRoleEmployee(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="incremental", required=false, defaultValue="true") Boolean incremental, @RequestBody @NotEmpty(message="\u8bf7\u9009\u62e9\u8d26\u53f7") @NotEmpty(message="\u8bf7\u9009\u62e9\u8d26\u53f7") List<Long> userIds) {
        return this.permissionMngService.saveRoleEmployee(roleId, userIds, incremental);
    }

    @ApiOperation(value="\u5411\u7ec4\u7ec7\u4e0b\u7684\u5458\u5de5\u6388\u6743\u89d2\u8272")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/role/orgUser"})
    public ApiResult<Boolean> saveUserRoleByOrg(@RequestBody OrgRolePermissionSaveVO saveVO) {
        return this.permissionMngService.saveUserRoleByOrg(saveVO);
    }

    @ApiOperation(value="\u4ece\u89d2\u8272\u4e2d\u5220\u9664\u8d26\u53f7")
    @ApiOperationSupport(order=3)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true), @ApiImplicitParam(name="userId", value="\u8d26\u53f7ID", dataType="long", required=true)})
    @DeleteMapping(value={"/role/user"})
    public ApiResult<Long> removeRoleUser(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="userId") @NotNull(message="\u8d26\u53f7ID\u4e3a\u7a7a") @NotNull(message="\u8d26\u53f7ID\u4e3a\u7a7a") Long userId) {
        return this.permissionMngService.removeRoleUser(roleId, userId);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u7528\u6237")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, dataType="long", paramType="query"), @ApiImplicitParam(name="onlyEmployee", value="\u662f\u5426\u4ec5\u663e\u793a\u5458\u5de5", dataType="boolean", paramType="query", defaultValue="true")})
    @GetMapping(value={"/role/user"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u89d2\u8272\u4e0b\u7684\u6240\u6709\u7528\u6237", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<List<EmployeeUserInfoRespVO>> getUserOfRole(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="onlyEmployee", required=false, defaultValue="true") Boolean onlyEmployee) {
        return this.permissionQueryService.listEmployeeUserByRole(roleId, onlyEmployee);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path")
    @GetMapping(value={"/user/{userId}/role"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u7528\u6237\u7684\u89d2\u8272", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<List<IdCodeNameCheckParam>> getRole(@PathVariable(value="userId") Long userId) {
        return this.permissionQueryService.getRoleByUserId(userId, false);
    }

    @ApiOperation(value="\u4fdd\u5b58\u7528\u6237\u7684\u89d2\u8272")
    @ApiOperationSupport(order=6)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="int", paramType="path"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ID", required=true, dataType="int", allowMultiple=true)})
    @PutMapping(value={"/user/{userId}/role"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u7528\u6237\u7684\u89d2\u8272", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> saveRole(@PathVariable(value="userId") Long userId, @RequestBody List<Long> roleIds) {
        return this.permissionMngService.saveUserRoles(userId, roleIds);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650")
    @ApiOperationSupport(order=11)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true), @ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801", required=true), @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u5f62\u7ed3\u6784\u6570\u636e", dataType="boolean")})
    @GetMapping(value={"/role/menu"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<List<RolePermissionRespVO>> getPermissionMenu(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="appCode") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a") String appCode, @RequestParam(name="tree", defaultValue="true") Boolean tree) {
        return this.permissionQueryService.getPermissionMenuByRole(roleId, appCode, tree);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650")
    @ApiOperationSupport(order=12)
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="int", required=true)
    @PostMapping(value={"/role/{roleId}/menu"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> savePermissionMenu(@PathVariable(value="roleId") Long roleId, @RequestBody @Valid List<RoleAppPermissionSaveVO> saveVOList) {
        return this.permissionMngService.savePermissionMenu(roleId, saveVOList);
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650")
    @ApiOperationSupport(order=13)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true)})
    @PostMapping(value={"/role/menu/dynamic"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> addPermissionMenu(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestBody @Valid RoleAppPermissionSaveVO saveVO) {
        return this.permissionMngService.addPermissionMenu(roleId, saveVO);
    }

    @ApiOperation(value="\u79fb\u9664\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650")
    @ApiOperationSupport(order=14)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", dataType="long", required=true)})
    @DeleteMapping(value={"/role/menu/dynamic"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u79fb\u9664\u89d2\u8272\u7684\u83dc\u5355\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> deletePermissionMenu(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestBody @Valid RoleAppPermissionSaveVO saveVO) {
        return this.permissionMngService.removePermissionMenu(roleId, saveVO);
    }

    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u89d2\u8272\u6743\u9650\u83dc\u5355")
    @ApiOperationSupport(order=15)
    @PostMapping(value={"/role/menu/batch"})
    public ApiResult<Boolean> savePermissionMenuBatch(@RequestBody RoleAppPermissionBatchSaveVO saveVO) {
        return this.permissionMngService.savePermissionMenuBatch(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u914d\u7684\u83dc\u5355")
    @ApiOperationSupport(order=16)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="long"), @ApiImplicitParam(name="includeAction", value="\u662f\u5426\u5305\u542b\u64cd\u4f5c", dataType="boolean")})
    @GetMapping(value={"/permission/userRoleMenu"})
    public ApiResult<List<UserRoleMenuRespVO>> getMenusOfUser(@RequestParam(name="userId") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long userId, @RequestParam(name="includeAction", required=false, defaultValue="false") Boolean includeAction) {
        return this.permissionQueryService.getMenusOfUser(userId, includeAction, true);
    }

    @ApiOperation(value="\u6570\u636e\u6743\u9650-\u6570\u636e\u8303\u56f4")
    @ApiOperationSupport(order=21)
    @ApiImplicitParams(value={@ApiImplicitParam(name="operationCode", value="\u64cd\u4f5c\u7f16\u7801"), @ApiImplicitParam(name="businessObjectCode", value="\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801")})
    @GetMapping(value={"/data/ranges"})
    public ApiResult<List<CodeNameParam>> getDprDataRanges(@RequestParam(name="operationCode", required=false) String operationCode, @RequestParam(name="businessObjectCode", required=false) String businessObjectCode) {
        return this.permissionQueryService.dataPermissionRanges(operationCode, businessObjectCode);
    }

    @ApiOperation(value="\u6570\u636e\u6743\u9650-\u89c4\u5219\u6761\u4ef6")
    @ApiOperationSupport(order=22)
    @GetMapping(value={"/data/conditions"})
    public ApiResult<List<CodeNameParam>> getDprRuleCondition() {
        return this.permissionQueryService.dataPermissionRuleCondition();
    }

    @ApiOperation(value="\u6570\u636e\u6743\u9650-\u89c4\u5219\u7684\u53d6\u503c\u65b9\u5f0f")
    @ApiOperationSupport(order=23)
    @GetMapping(value={"/data/ruleValueMethod"})
    public ApiResult<List<CodeNameParam>> getDprRuleValueMethod() {
        return this.permissionQueryService.dataPermissionRuleValueMethod();
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u914d\u6570\u636e\u6743\u9650\u7684\u83dc\u5355\u63a5\u53e3\u6811")
    @ApiOperationSupport(order=24)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801", required=true, dataType="String"), @ApiImplicitParam(name="type", value="\u6743\u9650\u7c7b\u578b", required=true, dataType="String", allowableValues="MENU_OPERATION_RULE,BUSINESS_OPERATION_RULE,BUSINESS_OBJECT_RULE,BUSINESS_RESOURCE_RULE"), @ApiImplicitParam(name="withRef", value="\u662f\u5426\u663e\u793a\u5173\u8054\u7684", dataType="boolean"), @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u72b6\u6570\u636e", dataType="boolean")})
    @GetMapping(value={"/dataPermission/tree/v1"})
    public ApiResult<List<DataPermissionTreeNodeRespVO>> getDataPermissionTree(@RequestParam(name="roleCode") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") String roleCode, @RequestParam(name="type", defaultValue="MENU_OPERATION_RULE") String type, @RequestParam(name="withRef", required=false, defaultValue="false") Boolean withRef, @RequestParam(name="tree", required=false, defaultValue="false") Boolean tree) {
        return this.permissionQueryService.dataPermissionTree(roleCode, type, withRef, null, tree);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=25)
    @PostMapping(value={"/data/rolePermission"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> saveDataPermission(@RequestBody DataPermissionSaveVO saveVO) {
        return this.permissionMngService.saveDataPermission(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=26)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801", required=true), @ApiImplicitParam(name="permissionType", value="\u6743\u9650\u7c7b\u578b", required=true, allowableValues="MENU_OPERATION_RULE,BUSINESS_OPERATION_RULE,BUSINESS_OBJECT_RULE,BUSINESS_RESOURCE_RULE"), @ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801"), @ApiImplicitParam(name="operationCode", value="\u64cd\u4f5c\u7f16\u7801"), @ApiImplicitParam(name="businessObjectCode", value="\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801")})
    @GetMapping(value={"/data/rolePermission"})
    public ApiResult<DataPermissionRespVO> getDataPermission(@RequestParam(name="roleCode") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a") String roleCode, @RequestParam(name="permissionType") @NotBlank(message="\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a") @NotBlank(message="\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a") String permissionType, @RequestParam(name="menuCode", required=false) String menuCode, @RequestParam(name="operationCode", required=false) String operationCode, @RequestParam(name="businessObjectCode", required=false) String businessObjectCode) {
        return this.permissionQueryService.getDataPermission(roleCode, permissionType, menuCode, operationCode, businessObjectCode);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6279\u91cf\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=42)
    @PostMapping(value={"/dataPermission/roleMenuApiBatch"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6279\u91cf\u6570\u636e\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Boolean> saveApiDataPermission(@RequestBody @Valid SysDprBatchSaveVO saveVO) {
        return this.permissionMngService.saveApiDataPermission(saveVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5206\u914d\u7684\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=43)
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, dataType="long")
    @GetMapping(value={"/data/user"})
    public ApiResult<List<UserRoleDataPermissionRespVO>> getDataPermissionOfUser(@RequestParam(name="userId") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") @NotNull(message="\u7528\u6237ID\u4e3a\u7a7a") Long userId) {
        return this.permissionQueryService.getDataPermissionOfUser(userId);
    }

    @GetMapping(value={"/{code}/detail"})
    @ApiOperation(value="\u6839\u636e\u6743\u9650\u7f16\u7801\u83b7\u53d6\u6743\u9650\u4fe1\u606f")
    @ApiOperationSupport(order=61)
    @ApiImplicitParam(name="code", value="\u6743\u9650\u7f16\u7801")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u6839\u636e\u6743\u9650\u7f16\u7801\u83b7\u53d6\u6743\u9650\u4fe1\u606f", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<PermissionDetailRespVO> permissionDetail(@PathVariable(value="code") String code) {
        return this.permissionQueryService.getPermissionDetailByCode(code);
    }

    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u83b7\u53d6\u83dc\u5355\u4e0b\u6302\u8f7d\u7684API")
    @ApiOperationSupport(order=31)
    @ApiIgnore
    @ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801", required=true)
    @GetMapping(value={"/data/menu/api"})
    @Deprecated(since="3.3.0")
    public ApiResult<List<SysMenuApiRespVO>> getApi(@RequestParam(name="menuCode") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") String menuCode) {
        return this.permissionQueryService.getApi(menuCode);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u4fdd\u5b58\u63a5\u53e3\u7ed1\u5b9a\u7684\u83dc\u5355")
    @ApiOperationSupport(order=32)
    @PostMapping(value={"/api/menus"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u83dc\u5355\u6302\u8f7d\u7684\u63a5\u53e3", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    @Deprecated(since="3.3.0")
    public ApiResult<Boolean> saveMenuApi(@RequestBody @Valid MenuApiSaveVO saveVO) {
        return this.permissionMngService.saveMenuApi(saveVO);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u83b7\u53d6\u63a5\u53e3\u7ed1\u5b9a\u7684\u83dc\u5355")
    @ApiOperationSupport(order=32)
    @ApiImplicitParams(value={@ApiImplicitParam(name="apiId", value="\u63a5\u53e3ID", required=true), @ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801")})
    @GetMapping(value={"/api/menus"})
    @Deprecated(since="3.3.0")
    public ApiResult<List<Long>> getMenuApi(@RequestParam(name="apiId") @NotNull(message="\u63a5\u53e3ID\u4e3a\u7a7a") @NotNull(message="\u63a5\u53e3ID\u4e3a\u7a7a") Long apiId, @RequestParam(name="appCode", required=false) String appCode) {
        return this.permissionQueryService.getMenuIdOfApi(apiId, appCode);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u83b7\u53d6\u63a5\u53e3\u7ed1\u5b9a\u7684\u83dc\u5355\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=33)
    @ApiImplicitParams(value={@ApiImplicitParam(name="apiId", value="\u63a5\u53e3ID", required=true), @ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801")})
    @GetMapping(value={"/api/menusDetail"})
    @Deprecated(since="3.3.0")
    public ApiResult<List<PermissionMenuRespVO>> getMenuApiDetail(@RequestParam(name="apiId") @NotNull(message="\u63a5\u53e3ID\u4e3a\u7a7a") @NotNull(message="\u63a5\u53e3ID\u4e3a\u7a7a") Long apiId, @RequestParam(name="appCode", required=false) String appCode) {
        return this.permissionQueryService.getMenuDetailOfApi(apiId, appCode);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u83b7\u53d6\u5206\u914d\u6570\u636e\u6743\u9650\u7684\u83dc\u5355\u63a5\u53e3\u6811")
    @ApiOperationSupport(order=24)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, dataType="int"), @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u72b6\u6570\u636e", dataType="boolean")})
    @GetMapping(value={"/dataPermission/tree"})
    @Deprecated(since="3.3.0")
    public ApiResult<List<DataPermissionTreeNodeRespVO>> getDataPermissionTree(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="tree", required=false, defaultValue="false") Boolean tree) {
        return this.permissionQueryService.dataPermissionTree(roleId, null, tree);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u83b7\u53d6\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=26)
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true), @ApiImplicitParam(name="menuCode", value="\u83dc\u5355\u7f16\u7801", required=true), @ApiImplicitParam(name="apiCode", value="\u63a5\u53e3\u7f16\u7801", required=true)})
    @GetMapping(value={"/data/roleMenuApi"})
    @Deprecated(since="3.3.0")
    public ApiResult<SysDprRespVO> getApiDataPermission(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="menuCode") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a") String menuCode, @RequestParam(name="apiCode") @NotBlank(message="\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a") @NotBlank(message="\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a") String apiCode) {
        return this.permissionQueryService.getApiDataPermission(roleId, menuCode, apiCode);
    }

    @ApiIgnore
    @ApiOperation(value="\u3010\u5df2\u5e9f\u5f03\u3011\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650")
    @ApiOperationSupport(order=25)
    @PostMapping(value={"/data/roleMenuApi"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u89d2\u8272\u5206\u914d\u7684\u6570\u636e\u6743\u9650", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    @Deprecated(since="3.3.0")
    public ApiResult<Long> saveApiDataPermission(@RequestBody @Valid SysDprSaveVO saveVO) {
        return this.permissionMngService.saveApiDataPermission(saveVO);
    }

    @ApiOperation(value="\u590d\u5236\u89d2\u8272\u7684\u6743\u9650")
    @PostMapping(value={"/permission/copy"})
    public ApiResult<Boolean> copyPermission(@RequestBody @Valid RolePermissionCopySaveVO saveVO) {
        return this.permissionMngService.copyPermission(saveVO);
    }

    @ApiOperation(value="\u6e05\u7a7a\u89d2\u8272\u7684\u6743\u9650")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true), @ApiImplicitParam(name="appCode", value="\u6307\u5b9a\u7684\u5e94\u7528\u7f16\u7801")})
    @DeleteMapping(value={"/permission/clear"})
    public ApiResult<Boolean> clearPermission(@RequestParam(name="roleId") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long roleId, @RequestParam(name="appCode", required=false) String appCode) {
        return this.permissionMngService.clearPermission(roleId, appCode);
    }

    @ApiOperation(value="\u6570\u636e\u6743\u9650\u89c4\u5219\u4e0b\u63a8")
    @PostMapping(value={"/dataPermission/propagate"})
    public ApiResult<Boolean> propagateDataPermission(@RequestBody @Valid RolePermissionPropagationSaveVO saveVO) {
        return this.permissionMngService.propagateDataPermission(saveVO);
    }
}

