/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.role;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RolePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleCloneSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleSaveVO;
import com.elitescloud.cloudt.system.service.RoleMngService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u89d2\u8272\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/role"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="Sys_Role:\u89d2\u8272", businessDoClass=SysRoleDO.class)
public class RoleMngController {
    private final RoleMngService roleMngService;

    public RoleMngController(RoleMngService roleMngService) {
        this.roleMngService = roleMngService;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u89d2\u8272")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2\u89d2\u8272", dataPermissionEnabled=true)
    public ApiResult<PagingVO<RolePageRespVO>> page(@RequestBody RolePageQueryVO queryVO) {
        return this.roleMngService.page(queryVO, BelongType.getBelonger());
    }

    @ApiOperation(value="\u5207\u6362\u542f\u7528\u7981\u7528")
    @ApiOperationSupport(order=2)
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="int")
    @PatchMapping(value={"/switch/enabled/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<Long> switchEnabled(@PathVariable(value="id") Long id) {
        return this.roleMngService.updateEnabled(id);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u540d\u79f0")
    @ApiOperationSupport(order=2)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="long"), @ApiImplicitParam(name="name", value="\u89d2\u8272\u540d\u79f0", required=true, dataType="String")})
    @PatchMapping(value={"/update/name"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u5207\u6362\u542f\u7528\u7981\u7528", logEnabled=true, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<Long> updateName(@RequestParam(name="id") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long id, @RequestParam(name="name") @NotBlank(message="\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a") @NotBlank(message="\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a") String name) {
        return this.roleMngService.updateName(id, name);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="int")
    @DeleteMapping(value={"/del/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u89d2\u8272", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.roleMngService.delete(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="int")
    @GetMapping(value={"/get/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u83b7\u53d6\u89d2\u8272\u8be6\u60c5", logEnabled=false, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<RoleDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.roleMngService.get(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272")
    @ApiOperationSupport(order=5)
    @PostMapping(value={"/save"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u89d2\u8272", logEnabled=true, resultJsonEnabled=true, argsJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid RoleSaveVO saveVO) {
        return this.roleMngService.save(saveVO, BelongType.getBelonger());
    }

    @ApiOperation(value="\u590d\u5236\u89d2\u8272")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/clone"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u590d\u5236\u89d2\u8272", logEnabled=true, resultJsonEnabled=false, argsJsonEnabled=false)
    public ApiResult<Long> clone(@RequestBody @Valid RoleCloneSaveVO saveVO) {
        return this.roleMngService.saveClone(saveVO);
    }
}

