/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.controller.mng.user;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RolePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.SubUserListRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.SubUserSaveVO;
import com.elitescloud.cloudt.system.service.RoleGroupMngService;
import com.elitescloud.cloudt.system.service.RoleMngService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.SubUserMngService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b50\u8d26\u53f7\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/mng/subUser"}, produces={"application/json"})
@Validated
public class SubUserMngController {
    private RoleMngService roleMngService;
    private RoleQueryService roleQueryService;
    private RoleGroupMngService roleGroupMngService;
    private SubUserMngService service;

    @ApiOperation(value="\u89d2\u8272\u53ca\u89d2\u8272\u7ec4\u5217\u8868")
    @ApiOperationSupport(order=1)
    @GetMapping(value={"/roles"})
    public ApiResult<List<GroupRoleRespVO>> listGroupRole() {
        return this.roleMngService.listGroupRole(true, BelongType.getBelongerPersonal());
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u89d2\u8272")
    @ApiOperationSupport(order=1)
    @PostMapping(value={"/page"})
    public ApiResult<PagingVO<RolePageRespVO>> page(RolePageQueryVO queryVO) {
        return this.roleMngService.page(queryVO, BelongType.getBelongerPersonal());
    }

    @PostMapping(value={"/roleGroup/save"})
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u7ec4")
    @ApiOperationSupport(order=2)
    public ApiResult<Long> upsertRoleGroup(@Valid @RequestBody RoleGroupSaveVO saveVO) {
        return this.roleGroupMngService.upsert(saveVO, BelongType.getBelongerPersonal());
    }

    @DeleteMapping(value={"/roleGroup/delete"})
    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u7ec4")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u89d2\u8272\u7ec4ID", required=true, dataType="int")
    public ApiResult<Long> deleteRoleGroup(@RequestParam(value="id") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") Long id) {
        return this.roleGroupMngService.delete(id);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u7ec4\u540d\u79f0")
    @ApiOperationSupport(order=4)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u89d2\u8272\u7ec4ID", required=true, dataType="long"), @ApiImplicitParam(name="name", value="\u89d2\u8272\u7ec4\u540d\u79f0", required=true, dataType="String")})
    @PatchMapping(value={"/roleGroup/update/name"})
    public ApiResult<Long> updateRoleGroupName(@RequestParam(name="id") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") Long id, @RequestParam(name="name") @NotBlank(message="\u89d2\u8272\u7ec4\u540d\u79f0\u4e3a\u7a7a") @NotBlank(message="\u89d2\u8272\u7ec4\u540d\u79f0\u4e3a\u7a7a") String name) {
        return this.roleGroupMngService.updateName(id, name);
    }

    @GetMapping(value={"/roleGroup/get"})
    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7ec4\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=5)
    @ApiImplicitParam(name="id", value="\u89d2\u8272\u7ec4ID", required=true, dataType="int")
    public ApiResult<RoleGroupDetailRespVO> getRoleGroupDetail(@RequestParam(value="id") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272\u7ec4ID\u4e3a\u7a7a") Long id) {
        return this.roleGroupMngService.getDetail(id);
    }

    @GetMapping(value={"/roleGroups"})
    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u5217\u8868")
    @ApiOperationSupport(order=6)
    public ApiResult<List<IdCodeNameParam>> queryRoleGroupList() {
        return this.roleQueryService.listAllRoleGroup(BelongType.getBelongerPersonal());
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272")
    @ApiOperationSupport(order=11)
    @PostMapping(value={"/role/save"})
    public ApiResult<Long> saveRole(@RequestBody @Valid RoleSaveVO saveVO) {
        saveVO.setBusinessKey(null);
        return this.roleMngService.save(saveVO, BelongType.getBelongerPersonal());
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u8be6\u60c5")
    @ApiOperationSupport(order=12)
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="int")
    @GetMapping(value={"/role/get/{id}"})
    public ApiResult<RoleDetailRespVO> getRole(@PathVariable(value="id") Long id) {
        return this.roleMngService.get(id);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u540d\u79f0")
    @ApiOperationSupport(order=13)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="long"), @ApiImplicitParam(name="name", value="\u89d2\u8272\u540d\u79f0", required=true, dataType="String")})
    @PatchMapping(value={"/role/update/name"})
    public ApiResult<Long> updateRoleName(@RequestParam(name="id") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") @NotNull(message="\u89d2\u8272ID\u4e3a\u7a7a") Long id, @RequestParam(name="name") @NotBlank(message="\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a") @NotBlank(message="\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a") String name) {
        return this.roleMngService.updateName(id, name);
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @ApiOperationSupport(order=14)
    @ApiImplicitParam(name="id", value="\u89d2\u8272ID", required=true, dataType="int")
    @DeleteMapping(value={"/role/del/{id}"})
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.roleMngService.delete(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5b50\u8d26\u53f7\u4fe1\u606f")
    @ApiOperationSupport(order=21)
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody @Valid SubUserSaveVO saveVO) {
        return this.service.save(saveVO);
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u5b50\u8d26\u53f7")
    @ApiOperationSupport(order=22)
    @PostMapping(value={"/saveBatch"})
    public ApiResult<List<Long>> saveBatch(@RequestBody @Valid SubUserBatchSaveVO saveVO) {
        return this.service.saveBatch(saveVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u5b50\u8d26\u53f7\u5217\u8868")
    @ApiOperationSupport(order=23, ignoreParameters={"belongType", "belongerId", "roleCode"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="belongType", value="\u5f52\u5c5e\u7c7b\u578b"), @ApiImplicitParam(name="belongerId", value="\u5f52\u5c5e\u8005ID"), @ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u7f16\u7801")})
    @GetMapping(value={"/list"})
    public ApiResult<List<SubUserListRespVO>> querySubUserList(@RequestParam(name="belongType", required=false) BelongType belongType, @RequestParam(name="belongerId", required=false) String belongerId, @RequestParam(name="roleCode", required=false) String roleCode) {
        return this.service.querySubUserList(belongType, belongerId, roleCode);
    }

    @ApiOperation(value="\u5220\u9664\u5b50\u8d26\u53f7\u8bb0\u5f55")
    @ApiOperationSupport(order=24)
    @ApiImplicitParam(name="delUser", value="\u662f\u5426\u540c\u65f6\u5220\u9664\u767b\u5f55\u8d26\u53f7", dataType="boolean")
    @DeleteMapping(value={"/delete"})
    public ApiResult<Set<Long>> del(@RequestBody Set<Long> ids, @RequestParam(name="delUser", required=false, defaultValue="false") Boolean delUser) {
        return this.service.del(ids, delUser);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b50\u8d26\u53f7\u5206\u914d\u7684\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=25)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="long")
    @GetMapping(value={"/edit"})
    public ApiResult<SubUserDetailRespVO> get(@RequestParam(name="id") @NotNull(message="ID\u4e3a\u7a7a") @NotNull(message="ID\u4e3a\u7a7a") Long id) {
        return this.service.get(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b50\u8d26\u53f7\u5206\u914d\u7684\u89d2\u8272")
    @ApiOperationSupport(order=26)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="long")
    @GetMapping(value={"/user/roles"})
    public ApiResult<List<IdCodeNameParam>> getRolesOfSubUser(@RequestParam(name="id") @NotNull(message="ID\u4e3a\u7a7a") @NotNull(message="ID\u4e3a\u7a7a") Long id) {
        return this.service.getRolesOfSubUser(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b50\u8d26\u53f7\u5206\u914d\u7684\u83dc\u5355")
    @ApiOperationSupport(order=27)
    @ApiImplicitParam(name="id", value="\u8bb0\u5f55ID", required=true, dataType="long")
    @GetMapping(value={"/user/menuCodes"})
    public ApiResult<Set<String>> getMenuCodesOfSubUser(@RequestParam(name="id") @NotNull(message="ID\u4e3a\u7a7a") @NotNull(message="ID\u4e3a\u7a7a") Long id) {
        return this.service.getMenuCodesOfSubUser(id);
    }

    @Autowired
    public void setRoleMngService(RoleMngService roleMngService) {
        this.roleMngService = roleMngService;
    }

    @Autowired
    public void setRoleGroupMngService(RoleGroupMngService roleGroupMngService) {
        this.roleGroupMngService = roleGroupMngService;
    }

    @Autowired
    public void setService(SubUserMngService service) {
        this.service = service;
    }

    @Autowired
    public void setRoleQueryService(RoleQueryService roleQueryService) {
        this.roleQueryService = roleQueryService;
    }
}

