/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.convert;

import com.elitescloud.boot.core.support.common.param.ServiceInstanceClassInfo;
import com.elitescloud.boot.core.support.common.param.ServiceInstanceInfo;
import com.elitescloud.boot.core.support.common.param.ServiceInstanceThreadInfo;
import com.elitescloud.boot.core.support.common.param.ServiceInstanceThreadPoolInfo;
import com.elitescloud.cloudt.system.convert.ServiceInstanceConvert;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceClassInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadPoolsRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadsRespVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceInstanceConvertImpl
implements ServiceInstanceConvert {
    @Override
    public ServiceInstanceInfoRespVO dto2RepVO(ServiceInstanceInfo instanceInfo) {
        String[] activeProfiles;
        Map map1;
        if (instanceInfo == null) {
            return null;
        }
        ServiceInstanceInfoRespVO serviceInstanceInfoRespVO = new ServiceInstanceInfoRespVO();
        serviceInstanceInfoRespVO.setJavaVersion(instanceInfo.getJavaVersion());
        serviceInstanceInfoRespVO.setSpringBootVersion(instanceInfo.getSpringBootVersion());
        serviceInstanceInfoRespVO.setCloudtBootVersion(instanceInfo.getCloudtBootVersion());
        serviceInstanceInfoRespVO.setProjectVersion(instanceInfo.getProjectVersion());
        serviceInstanceInfoRespVO.setRuntimeInfo(this.runtimeInfoToRuntimeInfo(instanceInfo.getRuntimeInfo()));
        Map map = instanceInfo.getSysProperties();
        if (map != null) {
            serviceInstanceInfoRespVO.setSysProperties(new LinkedHashMap<String, Object>(map));
        }
        if ((map1 = instanceInfo.getSysEnv()) != null) {
            serviceInstanceInfoRespVO.setSysEnv(new LinkedHashMap<String, Object>(map1));
        }
        if ((activeProfiles = instanceInfo.getActiveProfiles()) != null) {
            serviceInstanceInfoRespVO.setActiveProfiles(Arrays.copyOf(activeProfiles, activeProfiles.length));
        }
        serviceInstanceInfoRespVO.setPropertySources(this.propertySourceListToPropertySourceList(instanceInfo.getPropertySources()));
        return serviceInstanceInfoRespVO;
    }

    @Override
    public ServiceInstanceClassInfoRespVO dto2RepVO(ServiceInstanceClassInfo instanceInfo) {
        if (instanceInfo == null) {
            return null;
        }
        ServiceInstanceClassInfoRespVO serviceInstanceClassInfoRespVO = new ServiceInstanceClassInfoRespVO();
        serviceInstanceClassInfoRespVO.setExists(instanceInfo.getExists());
        serviceInstanceClassInfoRespVO.setJarVersion(instanceInfo.getJarVersion());
        List list = instanceInfo.getBeanList();
        if (list != null) {
            serviceInstanceClassInfoRespVO.setBeanList(new ArrayList<String>(list));
        }
        return serviceInstanceClassInfoRespVO;
    }

    @Override
    public List<ServiceInstanceThreadsRespVO> dto2RepVO(List<ServiceInstanceThreadInfo> instanceInfo) {
        if (instanceInfo == null) {
            return null;
        }
        ArrayList<ServiceInstanceThreadsRespVO> list = new ArrayList<ServiceInstanceThreadsRespVO>(instanceInfo.size());
        for (ServiceInstanceThreadInfo serviceInstanceThreadInfo : instanceInfo) {
            list.add(this.serviceInstanceThreadInfoToServiceInstanceThreadsRespVO(serviceInstanceThreadInfo));
        }
        return list;
    }

    @Override
    public List<ServiceInstanceThreadPoolsRespVO> tpDto2RepVO(List<ServiceInstanceThreadPoolInfo> instanceInfo) {
        if (instanceInfo == null) {
            return null;
        }
        ArrayList<ServiceInstanceThreadPoolsRespVO> list = new ArrayList<ServiceInstanceThreadPoolsRespVO>(instanceInfo.size());
        for (ServiceInstanceThreadPoolInfo serviceInstanceThreadPoolInfo : instanceInfo) {
            list.add(this.serviceInstanceThreadPoolInfoToServiceInstanceThreadPoolsRespVO(serviceInstanceThreadPoolInfo));
        }
        return list;
    }

    protected ServiceInstanceInfoRespVO.RuntimeInfo runtimeInfoToRuntimeInfo(ServiceInstanceInfo.RuntimeInfo runtimeInfo) {
        if (runtimeInfo == null) {
            return null;
        }
        ServiceInstanceInfoRespVO.RuntimeInfo runtimeInfo1 = new ServiceInstanceInfoRespVO.RuntimeInfo();
        runtimeInfo1.setMaxMemory(runtimeInfo.getMaxMemory());
        runtimeInfo1.setTotalMemory(runtimeInfo.getTotalMemory());
        runtimeInfo1.setFreeMemory(runtimeInfo.getFreeMemory());
        runtimeInfo1.setUsableMemory(runtimeInfo.getUsableMemory());
        runtimeInfo1.setProcessors(runtimeInfo.getProcessors());
        List list = runtimeInfo.getJvmArgs();
        if (list != null) {
            runtimeInfo1.setJvmArgs(new ArrayList<String>(list));
        }
        runtimeInfo1.setStartTime(runtimeInfo.getStartTime());
        runtimeInfo1.setUptime(runtimeInfo.getUptime());
        runtimeInfo1.setLoadedClassCount(runtimeInfo.getLoadedClassCount());
        runtimeInfo1.setThreadCount(runtimeInfo.getThreadCount());
        runtimeInfo1.setPeakThreadCount(runtimeInfo.getPeakThreadCount());
        return runtimeInfo1;
    }

    protected ServiceInstanceInfoRespVO.PropertySource propertySourceToPropertySource(ServiceInstanceInfo.PropertySource propertySource) {
        if (propertySource == null) {
            return null;
        }
        ServiceInstanceInfoRespVO.PropertySource propertySource1 = new ServiceInstanceInfoRespVO.PropertySource();
        propertySource1.setName(propertySource.getName());
        propertySource1.setSourceName(propertySource.getSourceName());
        Map map = propertySource.getProperyMap();
        if (map != null) {
            propertySource1.setProperyMap(new LinkedHashMap<String, Object>(map));
        }
        return propertySource1;
    }

    protected List<ServiceInstanceInfoRespVO.PropertySource> propertySourceListToPropertySourceList(List<ServiceInstanceInfo.PropertySource> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ServiceInstanceInfoRespVO.PropertySource> list1 = new ArrayList<ServiceInstanceInfoRespVO.PropertySource>(list.size());
        for (ServiceInstanceInfo.PropertySource propertySource : list) {
            list1.add(this.propertySourceToPropertySource(propertySource));
        }
        return list1;
    }

    protected ServiceInstanceThreadsRespVO.StackTraceElement stackTraceElementToStackTraceElement(ServiceInstanceThreadInfo.StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        ServiceInstanceThreadsRespVO.StackTraceElement stackTraceElement1 = new ServiceInstanceThreadsRespVO.StackTraceElement();
        stackTraceElement1.setDeclaringClass(stackTraceElement.getDeclaringClass());
        stackTraceElement1.setMethodName(stackTraceElement.getMethodName());
        stackTraceElement1.setFileName(stackTraceElement.getFileName());
        stackTraceElement1.setLineNumber(stackTraceElement.getLineNumber());
        return stackTraceElement1;
    }

    protected List<ServiceInstanceThreadsRespVO.StackTraceElement> stackTraceElementListToStackTraceElementList(List<ServiceInstanceThreadInfo.StackTraceElement> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ServiceInstanceThreadsRespVO.StackTraceElement> list1 = new ArrayList<ServiceInstanceThreadsRespVO.StackTraceElement>(list.size());
        for (ServiceInstanceThreadInfo.StackTraceElement stackTraceElement : list) {
            list1.add(this.stackTraceElementToStackTraceElement(stackTraceElement));
        }
        return list1;
    }

    protected ServiceInstanceThreadsRespVO serviceInstanceThreadInfoToServiceInstanceThreadsRespVO(ServiceInstanceThreadInfo serviceInstanceThreadInfo) {
        if (serviceInstanceThreadInfo == null) {
            return null;
        }
        ServiceInstanceThreadsRespVO serviceInstanceThreadsRespVO = new ServiceInstanceThreadsRespVO();
        serviceInstanceThreadsRespVO.setThreadName(serviceInstanceThreadInfo.getThreadName());
        serviceInstanceThreadsRespVO.setThreadId(serviceInstanceThreadInfo.getThreadId());
        serviceInstanceThreadsRespVO.setLockName(serviceInstanceThreadInfo.getLockName());
        serviceInstanceThreadsRespVO.setDaemon(serviceInstanceThreadInfo.isDaemon());
        serviceInstanceThreadsRespVO.setInNative(serviceInstanceThreadInfo.isInNative());
        serviceInstanceThreadsRespVO.setSuspended(serviceInstanceThreadInfo.isSuspended());
        serviceInstanceThreadsRespVO.setThreadState(serviceInstanceThreadInfo.getThreadState());
        serviceInstanceThreadsRespVO.setPriority(serviceInstanceThreadInfo.getPriority());
        serviceInstanceThreadsRespVO.setStackTrace(this.stackTraceElementListToStackTraceElementList(serviceInstanceThreadInfo.getStackTrace()));
        return serviceInstanceThreadsRespVO;
    }

    protected ServiceInstanceThreadPoolsRespVO.ThreadInfo threadInfoToThreadInfo(ServiceInstanceThreadPoolInfo.ThreadInfo threadInfo) {
        if (threadInfo == null) {
            return null;
        }
        ServiceInstanceThreadPoolsRespVO.ThreadInfo threadInfo1 = new ServiceInstanceThreadPoolsRespVO.ThreadInfo();
        threadInfo1.setThreadName(threadInfo.getThreadName());
        threadInfo1.setThreadId(threadInfo.getThreadId());
        threadInfo1.setStartTime(threadInfo.getStartTime());
        List list = threadInfo.getStackStraceList();
        if (list != null) {
            threadInfo1.setStackStraceList(new ArrayList<String>(list));
        }
        return threadInfo1;
    }

    protected List<ServiceInstanceThreadPoolsRespVO.ThreadInfo> threadInfoListToThreadInfoList(List<ServiceInstanceThreadPoolInfo.ThreadInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ServiceInstanceThreadPoolsRespVO.ThreadInfo> list1 = new ArrayList<ServiceInstanceThreadPoolsRespVO.ThreadInfo>(list.size());
        for (ServiceInstanceThreadPoolInfo.ThreadInfo threadInfo : list) {
            list1.add(this.threadInfoToThreadInfo(threadInfo));
        }
        return list1;
    }

    protected ServiceInstanceThreadPoolsRespVO serviceInstanceThreadPoolInfoToServiceInstanceThreadPoolsRespVO(ServiceInstanceThreadPoolInfo serviceInstanceThreadPoolInfo) {
        if (serviceInstanceThreadPoolInfo == null) {
            return null;
        }
        ServiceInstanceThreadPoolsRespVO serviceInstanceThreadPoolsRespVO = new ServiceInstanceThreadPoolsRespVO();
        serviceInstanceThreadPoolsRespVO.setThreadPoolName(serviceInstanceThreadPoolInfo.getThreadPoolName());
        serviceInstanceThreadPoolsRespVO.setCoreSize(serviceInstanceThreadPoolInfo.getCoreSize());
        serviceInstanceThreadPoolsRespVO.setMaxSize(serviceInstanceThreadPoolInfo.getMaxSize());
        serviceInstanceThreadPoolsRespVO.setCurrentSize(serviceInstanceThreadPoolInfo.getCurrentSize());
        serviceInstanceThreadPoolsRespVO.setActiveCount(serviceInstanceThreadPoolInfo.getActiveCount());
        serviceInstanceThreadPoolsRespVO.setLargestPoolSize(serviceInstanceThreadPoolInfo.getLargestPoolSize());
        serviceInstanceThreadPoolsRespVO.setTaskCount(serviceInstanceThreadPoolInfo.getTaskCount());
        serviceInstanceThreadPoolsRespVO.setCompletedTaskCount(serviceInstanceThreadPoolInfo.getCompletedTaskCount());
        serviceInstanceThreadPoolsRespVO.setQueueType(serviceInstanceThreadPoolInfo.getQueueType());
        serviceInstanceThreadPoolsRespVO.setQueueSize(serviceInstanceThreadPoolInfo.getQueueSize());
        serviceInstanceThreadPoolsRespVO.setQueueRemainingCapacity(serviceInstanceThreadPoolInfo.getQueueRemainingCapacity());
        serviceInstanceThreadPoolsRespVO.setQueueCapacity(serviceInstanceThreadPoolInfo.getQueueCapacity());
        serviceInstanceThreadPoolsRespVO.setRejectHandlerType(serviceInstanceThreadPoolInfo.getRejectHandlerType());
        serviceInstanceThreadPoolsRespVO.setAllowCoreThreadTimeOut(serviceInstanceThreadPoolInfo.getAllowCoreThreadTimeOut());
        serviceInstanceThreadPoolsRespVO.setKeepAliveTime(serviceInstanceThreadPoolInfo.getKeepAliveTime());
        serviceInstanceThreadPoolsRespVO.setThreadInfoList(this.threadInfoListToThreadInfoList(serviceInstanceThreadPoolInfo.getThreadInfoList()));
        return serviceInstanceThreadPoolsRespVO;
    }
}

