/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.model.vo.resp.extend;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiDetailVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.service.impl.ThirdApiLogRetrySupportServiceImpl;
import com.elitescloud.cloudt.system.util.BeanUtils;
import com.elitescloud.cloudt.system.util.ExceptionUtils;
import com.elitescloud.cloudt.system.util.MapUtils;
import com.elitescloud.cloudt.system.util.TenantSpiUtil;
import com.elitescloud.cloudt.system.util.TransformUtil;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class InfinityResult<T> {
    private static final Logger log = LoggerFactory.getLogger(InfinityResult.class);
    @ApiModelProperty(value="\u54cd\u5e94\u503c\u7684\u5b9e\u4f53\u7c7b\u578b")
    private Class<T> responseType;
    private HttpParam param;
    private InfinityLogVO logVO;
    private WebClient.RequestBodySpec uri;

    public List<T> toList() {
        return (List)this.wrapper(response -> response.bodyToFlux(this.responseType).collectList());
    }

    public T toEntity() {
        return (T)this.wrapper(response -> response.bodyToMono(this.responseType));
    }

    private <R> R wrapper(Function<ClientResponse, Mono<R>> fn) {
        LocalDateTime startTime = LocalDateTime.now();
        AtomicReference<Object> httpStatus = new AtomicReference<Object>(null);
        AtomicReference<String> errorMessage = new AtomicReference<String>("");
        Object result = this.uri.exchangeToMono(response -> {
            httpStatus.set(response.statusCode());
            if (response.statusCode() == HttpStatus.OK) {
                return (Mono)fn.apply((ClientResponse)response);
            }
            return response.createException().flatMap(Mono::error);
        }).onErrorResume(e -> {
            httpStatus.set(HttpStatus.INTERNAL_SERVER_ERROR);
            errorMessage.set(ExceptionUtils.formatException(e, 2000));
            log.error("[INFINITY][{}] \u63a5\u53e3\u8bf7\u6c42\u5931\u8d25: ", (Object)this.param.getApiCode(), e);
            return Mono.empty();
        }).block();
        LocalDateTime endTime = LocalDateTime.now();
        boolean success = httpStatus.get() == HttpStatus.OK;
        InfinityLogVO infinityLogVO = this.toInfinityParam(result, success, errorMessage.get(), startTime, endTime);
        ThirdApiLogDTO thirdApiLogDTO = this.toThirdApiLogDTO(infinityLogVO);
        ThirdApiLogRetrySupportServiceImpl sysThirdApiLogRpcService = (ThirdApiLogRetrySupportServiceImpl)SpringUtil.getBean(ThirdApiLogRetrySupportServiceImpl.class);
        sysThirdApiLogRpcService.saveLog(thirdApiLogDTO);
        if (!success) {
            String defaultMessage = "[" + this.param.getApiCode() + "] \u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + ((HttpStatus)httpStatus.get()).value();
            throw new RuntimeException(StrUtil.blankToDefault((CharSequence)errorMessage.get(), (String)defaultMessage));
        }
        return (R)result;
    }

    private ThirdApiLogDTO toThirdApiLogDTO(InfinityLogVO logVO) {
        ThirdApiLogDTO logDTO = new ThirdApiLogDTO();
        logDTO.setAppCode("YST-INFINITE");
        logDTO.setRestful(Boolean.valueOf(true));
        logDTO.setServer(Boolean.valueOf(false));
        logDTO.setServerAddr(logVO.getServerUrl());
        logDTO.setThirdApp(logVO.getTargetApp());
        logDTO.setBusinessType(logVO.getBusinessType());
        logDTO.setBusinessKey(logVO.getBusinessKey());
        logDTO.setClientId("");
        logDTO.setUserId(SecurityContextUtil.currentUserId());
        logDTO.setUsername(SecurityContextUtil.currentUserName());
        logDTO.setUri(logVO.getApiUrl());
        logDTO.setReqMethod(logVO.getRequestMethod());
        logDTO.setReqQueryParams(MapUtils.convert(logVO.getQueryParam()));
        logDTO.setReqBody(BeanUtils.toJsonOrEmpty(logVO.getBodyParam()));
        logDTO.setReqHeaders(MapUtils.convert(logVO.getHeaderParam()));
        logDTO.setReqSuccess(logVO.getRequestSuccess());
        logDTO.setReqFailMsg(logVO.getRequestFailMessage());
        logDTO.setReqTime(DateUtil.parse((CharSequence)logVO.getRequestTime()).toLocalDateTime());
        logDTO.setReqIp(logVO.getAddressIp());
        logDTO.setRespBody(BeanUtils.toJsonOrEmpty(logVO.getResponseBody()));
        logDTO.setRespSuccess(logVO.getResponseSuccess());
        logDTO.setRespFailMsg(logVO.getResponseFailMessage());
        logDTO.setRespTime(DateUtil.parse((CharSequence)logVO.getResponseTime()).toLocalDateTime());
        logDTO.setNeedRetry(Boolean.valueOf(false));
        logDTO.setDetectedOperatorAuth(Boolean.valueOf(false));
        return logDTO;
    }

    private InfinityLogVO toInfinityParam(Object responseBody, boolean requestSuccess, String reqFailMsg, LocalDateTime startTime, LocalDateTime endTime) {
        InfinityApiDetailVO apiConfig = this.param.getApiConfig();
        this.logVO.setAddressIp(HttpServletUtil.currentClientIp());
        this.logVO.setRequestTime(DateUtil.format((LocalDateTime)startTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        this.logVO.setResponseTime(DateUtil.format((LocalDateTime)endTime, (String)"yyyy-MM-dd HH:mm:ss.SSS"));
        long spendTime = LocalDateTimeUtil.between((LocalDateTime)startTime, (LocalDateTime)endTime).toMillis();
        this.logVO.setSpendTime(spendTime);
        this.logVO.setRequestSuccess(requestSuccess);
        this.logVO.setRequestFailMessage(reqFailMsg);
        this.logVO.setResponseBody(responseBody);
        this.logVO.setTenantCode(TenantSpiUtil.currentTenantCode());
        this.logVO.setTargetApp(apiConfig.getPlatformCode());
        this.logVO.setBusinessType(apiConfig.getApiCode());
        this.logVO.setBusinessTypeName(apiConfig.getApiName());
        this.logVO.setBusinessKey(this.param.getBizKey());
        String successStatus = apiConfig.getResponseSuccessStatus();
        String responseStatus = "";
        String successSpel = apiConfig.getResponseSuccessSpel();
        if (StrUtil.isNotBlank((CharSequence)successSpel)) {
            log.info("[INFINITY][ETL] \u63d0\u53d6\u54cd\u5e94\u62a5\u6587\u4e2d\uff0c\u6210\u529f\u72b6\u6001\u6807\u8bc6\u5b57\u6bb5: ");
            responseStatus = TransformUtil.parse(responseBody, successSpel);
        }
        if (StrUtil.isNotBlank((CharSequence)responseStatus) && StrUtil.isNotBlank((CharSequence)successStatus)) {
            boolean status = responseStatus.equals(successStatus);
            this.logVO.setResponseSuccess(status);
            if (!status) {
                log.info("[INFINITY][ETL] \u63d0\u53d6\u54cd\u5e94\u62a5\u6587\u4e2d\uff0c\u9519\u8bef\u4fe1\u606f\u5b57\u6bb5: ");
                this.logVO.setResponseFailMessage(TransformUtil.parse(responseBody, apiConfig.getResponseErrorMessageSpel()));
            }
        } else {
            this.logVO.setResponseSuccess(requestSuccess);
            this.logVO.setResponseFailMessage(reqFailMsg);
        }
        return this.logVO;
    }

    private InfinityResult(Class<T> responseType, HttpParam param, InfinityLogVO logVO, WebClient.RequestBodySpec uri) {
        this.responseType = responseType;
        this.param = param;
        this.logVO = logVO;
        this.uri = uri;
    }

    public static <T> InfinityResult<T> of(Class<T> responseType, HttpParam param, InfinityLogVO logVO, WebClient.RequestBodySpec uri) {
        return new InfinityResult<T>(responseType, param, logVO, uri);
    }
}

