/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.dpr;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.SysDprRoleApiRuleConvert;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UnifyQueryQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.UnifyQueryRespDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.SysDprRoleApiDataRuleListQueryBean;
import com.elitescloud.cloudt.system.modules.dpr.strategy.DprValueResolverFactory;
import com.elitescloud.cloudt.system.service.SysUnifyQueryQueryService;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleDataPermissionRepoProc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RoleAppApiDataPermissionUtil {
    private static final Logger log = LoggerFactory.getLogger(RoleAppApiDataPermissionUtil.class);
    public static final String NO_PERMISSION = "-1";

    public static List<SysDprRoleApiDataRuleListQueryDTO> setSysSysDprRoleApiRuleValue(GeneralUserDetails userInfo, List<SysDprRoleApiDataRuleListQueryBean> sysBean) {
        HashMap dprSysInternallyGroupMap = new HashMap(16);
        List<SysDprRoleApiDataRuleListQueryDTO> sysDprRoleApiDataRuleList = sysBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
            DprRuleValueSysInternallyBo valueBo;
            SysDprRoleApiDataRuleListQueryDTO ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto((SysDprRoleApiDataRuleListQueryBean)sysDprRoleApiDataRuleListQueryBean);
            String dprSysInternally = CharSequenceUtil.blankToDefault((CharSequence)ruleDTO.getDprRuleValue(), (String)ruleDTO.getDprSysInternally());
            if (dprSysInternallyGroupMap.containsKey(dprSysInternally)) {
                valueBo = (DprRuleValueSysInternallyBo)dprSysInternallyGroupMap.get(dprSysInternally);
            } else {
                valueBo = RoleAppApiDataPermissionUtil.resolveDprSysInternal(userInfo, ruleDTO);
                dprSysInternallyGroupMap.put(dprSysInternally, valueBo);
            }
            ruleDTO.setDprRuleValue(valueBo.getDprRuleValue());
            ruleDTO.setDprRuleFieldType(valueBo.getDprRuleFieldType());
            return ruleDTO;
        }).collect(Collectors.toList());
        return sysDprRoleApiDataRuleList;
    }

    private static DprRuleValueSysInternallyBo resolveDprSysInternal(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO dprRule) {
        DprValueResolverSPI.DprRuleValue dprRuleValue = DprValueResolverFactory.resolveDprValue(dprRule, userInfo);
        Assert.notNull((Object)dprRuleValue, (String)"\u89c4\u5219\u503c\u4e3a\u7a7a");
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();
        dprRuleValueSysInternallyBo.setDprRuleValue(RoleAppApiDataPermissionUtil.normalizeDprRuleValue(dprRuleValue));
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare(dprRuleValue.getValueType().showName());
        dprRuleValueSysInternallyBo.setDprRuleValueCode(dprRuleValue.getValueType().code());
        if (dprRuleValue.getFieldType() == null) {
            dprRuleValueSysInternallyBo.setDprRuleFieldType(dprRule.getDprRuleFieldType());
        } else {
            dprRuleValueSysInternallyBo.setDprRuleFieldType(dprRuleValue.getFieldType().name());
            dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(dprRuleValue.getFieldType().getValueDescription());
        }
        dprRuleValueSysInternallyBo.setDprRuleField(dprRule.getDprRuleField());
        return dprRuleValueSysInternallyBo;
    }

    private static String normalizeDprRuleValue(DprValueResolverSPI.DprRuleValue ruleValue) {
        if (ruleValue.getValue() == null) {
            return NO_PERMISSION;
        }
        if (Collection.class.isAssignableFrom(ruleValue.getValue().getClass())) {
            if (CollUtil.isEmpty((Collection)((Collection)ruleValue.getValue()))) {
                return NO_PERMISSION;
            }
            return StringUtils.collectionToDelimitedString((Collection)((Collection)ruleValue.getValue()), (String)",");
        }
        if (ruleValue.getValue().getClass().isArray()) {
            if (ArrayUtil.isEmpty((Object[])((Object[])ruleValue.getValue()))) {
                return NO_PERMISSION;
            }
            return StringUtils.arrayToDelimitedString((Object[])((Object[])ruleValue.getValue()), (String)",");
        }
        return ruleValue.getValue().toString();
    }

    public static String normalizeRuleValue(Collection<?> values) {
        if (CollUtil.isEmpty(values)) {
            return NO_PERMISSION;
        }
        return StringUtils.collectionToDelimitedString(values, (String)",");
    }

    public static boolean isIdField(String fieldName) {
        return fieldName != null && (fieldName.contains("id") || fieldName.contains("Id"));
    }

    public static boolean isCodeField(String fieldName) {
        return fieldName != null && (fieldName.contains("code") || fieldName.contains("Code"));
    }

    public static void setRuleValueForInternal(GeneralUserDetails userInfo, List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        if (CollUtil.isEmpty(ruleList)) {
            return;
        }
        HashMap<String, DprRuleValueSysInternallyBo> dprSysInternallyGroupMap = new HashMap<String, DprRuleValueSysInternallyBo>(16);
        for (SysDprRoleApiDataRuleListQueryDTO ruleDTO : ruleList) {
            DprRuleValueSysInternallyBo valueBo;
            String dprSysInternally = ruleDTO.getDprRuleValue();
            if (dprSysInternallyGroupMap.containsKey(dprSysInternally)) {
                valueBo = (DprRuleValueSysInternallyBo)dprSysInternallyGroupMap.get(dprSysInternally);
            } else {
                valueBo = RoleAppApiDataPermissionUtil.resolveDprSysInternal(userInfo, ruleDTO);
                dprSysInternallyGroupMap.put(dprSysInternally, valueBo);
            }
            ruleDTO.setDprRuleValue(valueBo.getDprRuleValue());
            ruleDTO.setDprRuleFieldType(valueBo.getDprRuleFieldType());
        }
    }

    public static List<SysDprRoleApiDataRuleListQueryDTO> setBusinessSysDprRoleApiRuleValue(GeneralUserDetails userInfo, List<SysDprRoleApiDataRuleListQueryBean> businessBean) {
        List<SysDprRoleApiDataRuleListQueryDTO> beanValueList = businessBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
            SysDprRoleApiDataRuleListQueryDTO ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto((SysDprRoleApiDataRuleListQueryBean)sysDprRoleApiDataRuleListQueryBean);
            Assert.hasText((String)ruleDTO.getDprRuleValue(), (String)("\u503c\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u89d2\u8272\u4e2d\u914d\u7f6e\u4e86\u81ea\u5b9a\u4e49\u503c\u3002Business\u89c4\u5219\uff1a" + ruleDTO.getDprRuleId()));
            return ruleDTO;
        }).collect(Collectors.toList());
        return beanValueList;
    }

    public static void setRuleValueForBusinessSet(GeneralUserDetails userInfo, List<SysDprRoleApiDataRuleListQueryDTO> ruleList) {
        if (CollUtil.isEmpty(ruleList)) {
            return;
        }
        ArrayList<CompletableFuture<Void>> completableFutureList = new ArrayList<CompletableFuture<Void>>(ruleList.size());
        TaskExecutor taskExecutor = (TaskExecutor)SpringContextHolder.getBean(TaskExecutor.class);
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.FALSE.equals(rule.getRefResource())) continue;
            completableFutureList.add(CompletableFuture.runAsync(() -> {
                log.info("query public resource permission start ...");
                long start = System.currentTimeMillis();
                String value = RoleAppApiDataPermissionUtil.queryRefBusinessResourceValue(rule, userInfo);
                log.info("public resource value:{}, {}, {}, {}", new Object[]{rule.getRoleCode(), rule.getDprRuleField(), rule.getRefBusinessObject(), value});
                log.info("query public resource permission end, cost {}ms", (Object)(System.currentTimeMillis() - start));
                rule.setDprRuleValue(value);
            }, (Executor)taskExecutor));
        }
        if (completableFutureList.isEmpty()) {
            return;
        }
        CompletableFuture.allOf((CompletableFuture[])completableFutureList.toArray(CompletableFuture[]::new)).join();
    }

    public static List<SysDprRoleApiDataRuleListQueryDTO> setCustomSysDprRoleApiRuleValue(GeneralUserDetails userInfo, List<SysDprRoleApiDataRuleListQueryBean> businessBean) {
        List<SysDprRoleApiDataRuleListQueryDTO> beanValueList = businessBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
            SysDprRoleApiDataRuleListQueryDTO ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto((SysDprRoleApiDataRuleListQueryBean)sysDprRoleApiDataRuleListQueryBean);
            Assert.hasText((String)ruleDTO.getDprRuleValue(), (String)("\u503c\u7a7a\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u89d2\u8272\u4e2d\u914d\u7f6e\u4e86\u81ea\u5b9a\u4e49\u503c\u3002Custom\u89c4\u5219\uff1a" + ruleDTO.getDprRuleId()));
            return ruleDTO;
        }).collect(Collectors.toList());
        return beanValueList;
    }

    public static void fillDataPermissionValue(List<SysDprRoleApiDataRuleListQueryDTO> ruleList, GeneralUserDetails userInfo) {
        if (ruleList.isEmpty()) {
            return;
        }
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> valueTypeMap = ruleList.stream().filter(t -> !Boolean.TRUE.equals(t.getRuleGroup())).collect(Collectors.groupingBy(SysDprRoleApiDataRuleListQueryDTO::getDprRuleValueType));
        block5: for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> entry : valueTypeMap.entrySet()) {
            DprRuleValueTypeEnum type = DprRuleValueTypeEnum.parse((String)entry.getKey());
            Assert.notNull((Object)type, (String)("\u672a\u77e5\u89c4\u5219\u503c\u7c7b\u578b\uff1a" + entry.getKey()));
            switch (type) {
                case DPR_RULE_VALUE_TYPE_SYS: {
                    RoleAppApiDataPermissionUtil.setRuleValueForInternal(userInfo, entry.getValue());
                    continue block5;
                }
                case DPR_RULE_VALUE_TYPE_CUSTOM: {
                    continue block5;
                }
                case DPR_RULE_VALUE_TYPE_BUSINESS: 
                case DPR_RULE_VALUE_TYPE_COMP: {
                    RoleAppApiDataPermissionUtil.setRuleValueForBusinessSet(userInfo, entry.getValue());
                    continue block5;
                }
            }
            throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b\uff1a" + entry.getKey());
        }
    }

    private static String queryRefBusinessResourceValue(SysDprRoleApiDataRuleListQueryDTO ruleDTO, GeneralUserDetails userInfo) {
        Assert.hasText((String)ruleDTO.getRefBusinessObject(), (String)("\u5b58\u5728\u5173\u8054\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a\uff1a" + ruleDTO.getRoleCode()));
        Assert.hasText((String)ruleDTO.getRoleCode(), (String)"\u5b58\u5728\u6743\u9650\u914d\u7f6e\u7684\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)ruleDTO.getRefField(), (String)"\u5b58\u5728\u7ba1\u7406\u7684\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u4e3a\u7a7a");
        List<SysDprRoleApiDataRuleListQueryDTO> refRuleList = ((RoleDataPermissionRepoProc)((Object)SpringContextHolder.getBean(RoleDataPermissionRepoProc.class))).queryForRefBusinessObjectResourceByRole(ruleDTO.getRoleCode(), ruleDTO.getRefBusinessObject());
        if (refRuleList.isEmpty()) {
            return NO_PERMISSION;
        }
        RoleAppApiDataPermissionUtil.fillDataPermissionValue(refRuleList, userInfo);
        HashMap<String, List> refRuleValues = new HashMap<String, List>(refRuleList.size());
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>(refRuleList.size());
        boolean relationAnd = true;
        boolean valueEquals = true;
        for (SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO : refRuleList) {
            if (CharSequenceUtil.isBlank((CharSequence)sysDprRoleApiDataRuleListQueryDTO.getDprRuleField()) || CharSequenceUtil.isBlank((CharSequence)sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue()) || CharSequenceUtil.isBlank((CharSequence)sysDprRoleApiDataRuleListQueryDTO.getDprRuleFieldType())) {
                log.warn("\u5b58\u5728\u6570\u636e\u6743\u9650\u89c4\u5219\u5b57\u6bb5\u6216\u503c\u4e3a\u7a7a\uff1a{}\uff0c{}\uff0c{}\uff0c{}", new Object[]{sysDprRoleApiDataRuleListQueryDTO.getRoleCode(), sysDprRoleApiDataRuleListQueryDTO.getDprRuleField(), sysDprRoleApiDataRuleListQueryDTO.getDprRuleFieldType(), sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue()});
                continue;
            }
            if (NO_PERMISSION.equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue()) && (DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValueType()) || DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValueType()) || DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_COMP.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValueType()))) {
                return NO_PERMISSION;
            }
            fieldTypeMap.put(sysDprRoleApiDataRuleListQueryDTO.getDprRuleField(), sysDprRoleApiDataRuleListQueryDTO.getDprRuleFieldType());
            List list = refRuleValues.getOrDefault(sysDprRoleApiDataRuleListQueryDTO.getDprRuleField(), new ArrayList(0));
            if (sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue().contains(",")) {
                list.addAll(Arrays.stream(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue().split(",")).collect(Collectors.toList()));
            } else {
                list.add(sysDprRoleApiDataRuleListQueryDTO.getDprRuleValue());
            }
            refRuleValues.put(sysDprRoleApiDataRuleListQueryDTO.getDprRuleField(), list);
            relationAnd = DprRuleRelationEnum.DPR_RULE_RELATION_AND.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleRelation());
            valueEquals = DprRuleConditionEnum.Equal.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleCondition()) || DprRuleConditionEnum.InList.name().equals(sysDprRoleApiDataRuleListQueryDTO.getDprRuleCondition());
        }
        HashMap<String, Object> conditions = new HashMap<String, Object>(refRuleValues.size());
        for (Map.Entry entry : refRuleValues.entrySet()) {
            if (((List)entry.getValue()).contains(NO_PERMISSION)) {
                return NO_PERMISSION;
            }
            if (((List)entry.getValue()).size() == 1) {
                conditions.put((String)entry.getKey(), ObjUtil.convertBasicValue(((List)entry.getValue()).get(0), (String)((String)fieldTypeMap.get(entry.getKey()))));
                continue;
            }
            conditions.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(t -> ObjUtil.convertBasicValue((Object)t, (String)((String)fieldTypeMap.get(entry.getKey())))).collect(Collectors.toList()));
        }
        UnifyQueryQueryDTO unifyQueryQueryDTO = new UnifyQueryQueryDTO();
        unifyQueryQueryDTO.setBusinessObjectCode(ruleDTO.getRefBusinessObject());
        unifyQueryQueryDTO.setQueryFields(List.of(ruleDTO.getRefField()));
        unifyQueryQueryDTO.setConditions(conditions);
        unifyQueryQueryDTO.setConditionFieldTypes(fieldTypeMap);
        unifyQueryQueryDTO.setAnd(Boolean.valueOf(relationAnd));
        unifyQueryQueryDTO.setEquals(Boolean.valueOf(valueEquals));
        Boolean bl = ((BusinessObjectRepoProc)((Object)SpringContextHolder.getBean(BusinessObjectRepoProc.class))).getSupportTenant(unifyQueryQueryDTO.getBusinessObjectCode());
        SysUnifyQueryQueryService unifyQueryService = (SysUnifyQueryQueryService)SpringContextHolder.getBean(SysUnifyQueryQueryService.class);
        UnifyQueryRespDTO unifyQueryData = Boolean.TRUE.equals(bl) ? (UnifyQueryRespDTO)unifyQueryService.query(unifyQueryQueryDTO).computeData() : (UnifyQueryRespDTO)((ApiResult)((TenantDataIsolateProvider)SpringContextHolder.getBean(TenantDataIsolateProvider.class)).byDefaultDirectly(() -> unifyQueryService.query(queryDTO))).computeData();
        Assert.isTrue((boolean)unifyQueryData.getSuccess(), (String)unifyQueryData.getFailMsg());
        return RoleAppApiDataPermissionUtil.obtainValueFromUnifyQueryData(ruleDTO.getRefField(), unifyQueryData.getData());
    }

    private static String obtainValueFromUnifyQueryData(String field, Object data) {
        if (data == null) {
            return NO_PERMISSION;
        }
        if (data instanceof List) {
            List values = ((List)data).stream().map(t -> {
                if (t instanceof Map) {
                    return ((Map)t).get(field);
                }
                return t;
            }).filter(t -> {
                if (t == null) {
                    return false;
                }
                if (t instanceof String) {
                    return CharSequenceUtil.isNotBlank((CharSequence)((String)t));
                }
                return true;
            }).collect(Collectors.toList());
            if (values.isEmpty()) {
                return NO_PERMISSION;
            }
            return RoleAppApiDataPermissionUtil.normalizeRuleValue(values);
        }
        log.error("\u89e3\u6790\u6743\u9650\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonString((Object)data));
        throw new BusinessException("\u89e3\u6790\u6743\u9650\u914d\u7f6e\u5f02\u5e38");
    }
}

