/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class DprSysInternallyDynamic
implements DprValueResolverSPI {
    private static final Logger log = LoggerFactory.getLogger(DprSysInternallyDynamic.class);
    public static final String PREFIX = SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC.code() + "::userType::";

    @NotEmpty
    public DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC};
    }

    public DprValueResolverSPI.DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        String userType = ruleDTO.getDprRuleValue().substring(PREFIX.length());
        Long value = null;
        for (SysUserType sysUserType : userInfo.getUser().getUserTypeList()) {
            if (!userType.equals(sysUserType.getUserType()) || !StringUtils.hasText((String)sysUserType.getIdentityId())) continue;
            value = Long.parseLong(sysUserType.getIdentityId());
        }
        DprValueResolverSPI.DprRuleValue dprRuleValue = new DprValueResolverSPI.DprRuleValue();
        if (value != null) {
            dprRuleValue.setValue(value);
        } else {
            log.error("\u6570\u636e\u6743\u9650\u9519\u8bef\uff1a\u8d26\u53f7\u6ca1\u6709{}\u4fe1\u606f", (Object)userType);
        }
        return dprRuleValue;
    }
}

