/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.modules.dpr.RoleAppApiDataPermissionUtil;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DprSysInternallyOuAll
implements DprValueResolverSPI {
    private static final Logger log = LoggerFactory.getLogger(DprSysInternallyOuAll.class);
    @Autowired
    private OrgRepoProc orgRepoProc;

    @NotEmpty
    public DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_OU_ALL};
    }

    public DprValueResolverSPI.DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprValueResolverSPI.DprRuleValue rule = new DprValueResolverSPI.DprRuleValue();
        if (RoleAppApiDataPermissionUtil.isIdField(ruleDTO.getDprRuleField())) {
            if (userInfo.getUser() == null || userInfo.getUser().getOrgList() == null || userInfo.getUser().getOrgList().isEmpty()) {
                log.error("\u7528\u6237\u4fe1\u606f\u6ca1\u6709\u83b7\u53d6\u5230\u7ec4\u7ec7\u6570\u636e");
            } else {
                List orgList = userInfo.getUser().getOrgList();
                List<Long> orgIds = orgList.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toList());
                Map<Long, IdCodeNameParam> company = this.orgRepoProc.queryParentNameForType(orgIds, OrgType.COMPANY.getValue(), true);
                if (company != null) {
                    List ouIds = company.values().stream().map(IdCodeNameParam::getId).collect(Collectors.toList());
                    rule.setValue(ouIds);
                } else {
                    log.error("\u7528\u6237\u4fe1\u606f\u6ca1\u6709\u83b7\u53d6\u5230\u7ec4\u7ec7\u7684\u516c\u53f8\u6570\u636e ID");
                }
            }
        } else if (userInfo.getUser() == null || userInfo.getUser().getOrgList() == null || userInfo.getUser().getOrgList().isEmpty()) {
            log.error("\u7528\u6237\u4fe1\u606f\u6ca1\u6709\u83b7\u53d6\u5230\u7ec4\u7ec7\u6570\u636e\uff0c\u67e5\u8be2\u6761\u4ef6");
        } else {
            List orgList = userInfo.getUser().getOrgList();
            List<Long> orgIds = orgList.stream().map(SysOrgBasicDTO::getId).collect(Collectors.toList());
            Map<Long, IdCodeNameParam> company = this.orgRepoProc.queryParentNameForType(orgIds, OrgType.COMPANY.getValue(), true);
            if (company != null) {
                List ouCodes = company.values().stream().map(IdCodeNameParam::getCode).collect(Collectors.toList());
                rule.setValue(ouCodes);
            } else {
                log.error("\u7528\u6237\u4fe1\u606f\u6ca1\u6709\u83b7\u53d6\u5230\u7ec4\u7ec7\u7684\u516c\u53f8\u6570\u636e ID\uff0c\u67e5\u8be2\u6761\u4ef6");
            }
        }
        return rule;
    }
}

