/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.lang.UUID;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.constant.SysMsgReceiverTypeEnum;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.req.SysSiteMsgSaveDTO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepoProc;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordRepoProc;
import com.elitescloud.cloudt.system.modules.message.service.SiteMsgMngService;
import com.elitescloud.cloudt.system.service.manager.UserQueryManager;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SiteMsgMngServiceImpl
implements SiteMsgMngService {
    private static final Logger logger = LoggerFactory.getLogger(SiteMsgMngServiceImpl.class);
    @Autowired
    private UserQueryManager userQueryManager;
    @Autowired
    private SysMsgSendRecordRepoProc msgSendRecordRepoProc;
    @Autowired
    private SysMsgSendRecordDtlRepoProc msgSendRecordDtlRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> send(SysSiteMsgSaveDTO saveDTO) {
        Assert.notNull((Object)saveDTO, (String)"\u4fdd\u5b58\u53c2\u6570\u4e3a\u7a7a");
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        Assert.notEmpty((Collection)saveDTO.getReceiverUserIds(), (String)"\u63a5\u6536\u4eba\u8d26\u6237ID\u4e3a\u7a7a");
        Assert.hasText((String)saveDTO.getTitle(), (String)"\u6807\u9898\u4e3a\u7a7a");
        ArrayList<Long> userIds = new ArrayList<Long>(saveDTO.getReceiverUserIds());
        if (saveDTO.getSenderUserId() != null) {
            userIds.add(saveDTO.getSenderUserId());
        }
        Map<Long, IdCodeNameParam> userMap = this.userQueryManager.queryUsers(userIds, tenant == null ? null : tenant.getId()).stream().collect(Collectors.toMap(IdCodeNameParam::getId, param -> param, (t1, t2) -> t1));
        String batchId = UUID.fastUUID().toString();
        LocalDateTime now = LocalDateTime.now();
        String customParamStr = JSONUtil.toJsonString((Object)saveDTO.getCustomParams());
        IdCodeNameParam sender = null;
        if (saveDTO.getSenderUserId() != null) {
            sender = userMap.get(saveDTO.getSenderUserId());
            Assert.notNull((Object)sender, (String)"\u53d1\u9001\u4eba\u4e0d\u5b58\u5728");
        }
        ArrayList<SysMsgSendRecordDtlDO> recordDtlList = new ArrayList<SysMsgSendRecordDtlDO>(userIds.size());
        for (Long receiverUserId : saveDTO.getReceiverUserIds()) {
            IdCodeNameParam receiver;
            SysMsgSendRecordDO record = new SysMsgSendRecordDO();
            record.setMsgType(MsgTypeEnum.CUSTOM.getCode());
            if (sender != null) {
                record.setSendUserId(sender.getId().toString());
                record.setSendUserName(sender.getName());
                record.setSendUserCode(sender.getCode());
            }
            if ((receiver = userMap.get(receiverUserId)) == null) {
                if (Boolean.TRUE.equals(saveDTO.getIgnoreUserNotExist())) continue;
                throw new BusinessException("\u8d26\u6237" + receiverUserId + "\u4e0d\u5b58\u5728");
            }
            record.setRecipientUserId(receiver.getId().toString());
            record.setRecipientUserName(receiver.getName());
            record.setRecipientUserCode(receiver.getCode());
            record.setSendTime(now);
            record.setBatchUuid(batchId);
            record.setCustomParamJson(customParamStr);
            this.msgSendRecordRepoProc.save((Serializable)((Object)record));
            SysMsgSendRecordDtlDO recordDtlDO = this.saveRecordDtl(saveDTO, record);
            recordDtlList.add(recordDtlDO);
        }
        if (recordDtlList.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u6709\u6548\u7684\u63a5\u6536\u4eba\u8d26\u53f7");
        }
        this.msgSendRecordDtlRepoProc.save(recordDtlList);
        return ApiResult.ok((Object)batchId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> delete(String batchId) {
        Assert.hasText((String)batchId, (String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        this.msgSendRecordRepoProc.deleteByBatchId(batchId);
        this.msgSendRecordDtlRepoProc.deleteByBatchId(batchId);
        return ApiResult.ok((Object)batchId);
    }

    private SysMsgSendRecordDtlDO saveRecordDtl(SysSiteMsgSaveDTO saveDTO, SysMsgSendRecordDO record) {
        SysMsgSendRecordDtlDO recordDtlDO = new SysMsgSendRecordDtlDO();
        recordDtlDO.setMsgSendRecordId(record.getId());
        recordDtlDO.setMsgType(record.getMsgType());
        recordDtlDO.setSendState(MsgSendStateEnum.OK.name());
        recordDtlDO.setSentTypeCode(MsgSendTypeEnum.SYS_INTERIOR.name());
        recordDtlDO.setSendTypeName(MsgSendTypeEnum.SYS_INTERIOR.getDescription());
        recordDtlDO.setSentTimeStart(record.getSendTime());
        recordDtlDO.setSentTimeEnd(record.getSendTime());
        recordDtlDO.setSendUserId(record.getSendUserId());
        recordDtlDO.setSendUserName(record.getSendUserName());
        recordDtlDO.setSendUserCode(record.getSendUserCode());
        recordDtlDO.setRecipientUserId(record.getRecipientUserId());
        recordDtlDO.setRecipientUserCode(record.getRecipientUserCode());
        recordDtlDO.setRecipientUserName(record.getRecipientUserName());
        recordDtlDO.setRecipientAccountType(SysMsgReceiverTypeEnum.RECEIVER.name());
        recordDtlDO.setRecipientAccount(record.getRecipientUserCode());
        recordDtlDO.setSubject(saveDTO.getTitle());
        recordDtlDO.setTitleContent(saveDTO.getTitle());
        recordDtlDO.setMessageContent(saveDTO.getContent());
        recordDtlDO.setCustomParamJson(record.getCustomParamJson());
        recordDtlDO.setReadFlg(false);
        recordDtlDO.setBatchUuid(record.getBatchUuid());
        return recordDtlDO;
    }
}

