/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.SearchResult;
import cn.zhxu.bs.param.OrderBy;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.common.MsgReceiveStatusEnum;
import com.elitescloud.cloudt.messenger.common.MsgSendStatusEnum;
import com.elitescloud.cloudt.messenger.model.dto.MsgResultDTO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.BasicsBean;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepoProc;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordRepository;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordDtlQueryBean;
import com.elitescloud.cloudt.system.modules.message.sbean.SysMsgSendRecordQueryBean;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgSendRecordService;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordDtlInteriorQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgSendRecordQueryVO;
import com.elitescloud.cloudt.system.param.SysMsgSentResultDTO;
import com.elitescloud.cloudt.system.param.SysMsgViewResultDTO;
import com.elitescloud.cloudt.system.service.util.BeanSearcherUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class SysMsgSendRecordServiceImpl
implements SysMsgSendRecordService {
    private static final Logger log = LoggerFactory.getLogger(SysMsgSendRecordServiceImpl.class);
    private final SysMsgSendRecordRepository sysMsgSendRecordRepository;
    private final SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository;
    private final SysMsgSendRecordDtlRepoProc recordDtlRepoProc;
    private final BeanSearcher beanSearcher;
    private final BeanSearcherFactory beanSearcherFactory;
    private final TaskExecutor taskExecutor;

    @Autowired
    public SysMsgSendRecordServiceImpl(SysMsgSendRecordRepository sysMsgSendRecordRepository, SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository, BeanSearcherFactory beanSearcherFactory, SysMsgSendRecordDtlRepoProc recordDtlRepoProc, TaskExecutor taskExecutor) {
        this.sysMsgSendRecordRepository = sysMsgSendRecordRepository;
        this.sysMsgSendRecordDtlRepository = sysMsgSendRecordDtlRepository;
        this.recordDtlRepoProc = recordDtlRepoProc;
        this.taskExecutor = taskExecutor;
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = this.beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
    }

    @Override
    public ApiResult<SearchResult<SysMsgSendRecordQueryBean>> sysMsgSendRecordQuery(SysMsgSendRecordQueryVO qvo) {
        MapBuilder mapBuilder = (MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)MapUtils.builder().page((long)qvo.getCurrent().intValue(), qvo.getSize().intValue()).field(SysMsgSendRecordQueryBean::getRecipientUserId, new Object[]{qvo.getRecipientUserId()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getRecipientUserName, new Object[]{qvo.getRecipientUserName()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getSendUserId, new Object[]{qvo.getSendUserId()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getSendUserName, new Object[]{qvo.getSendUserName()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getMsgType, new Object[]{qvo.getMsgTypeCode(), qvo.getSendUserName()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getTemplateCode, new Object[]{qvo.getTemplateCode()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getTemplateName, new Object[]{qvo.getTemplateName()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordQueryBean::getSendTime, new Object[]{qvo.getSendTimeStart(), qvo.getSendTimeEnd()})).op((FieldOp)FieldOps.Between);
        BeanSearcherUtils.setParamsOrderBy((List)qvo.getOrders(), (MapBuilder)mapBuilder, (OrderBy)new OrderBy("sendTime", "asc"));
        SearchResult result = this.beanSearcher.search(SysMsgSendRecordQueryBean.class, mapBuilder.build());
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> sysMsgSendRecordDelete(SysMsgSendRecordDeleteVO sysMsgSendRecordDeleteVO) {
        List<Long> dtlIds;
        List<Long> recordIds = sysMsgSendRecordDeleteVO.getSysMsgSendRecordIdList();
        if (CollUtil.isNotEmpty(recordIds)) {
            this.sysMsgSendRecordRepository.deleteAllByIdInBatch(recordIds);
            recordIds.forEach(this.sysMsgSendRecordDtlRepository::deleteByMsgSendRecordId);
        }
        if (CollUtil.isNotEmpty(dtlIds = sysMsgSendRecordDeleteVO.getRecordDtlIdList())) {
            this.sysMsgSendRecordDtlRepository.deleteAllById(dtlIds);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<List<SysMsgSentResultDTO>> querySentResult(Set<String> batchUuids) {
        Assert.notEmpty(batchUuids, (String)"\u53d1\u9001\u8bb0\u5f55ID\u4e3a\u7a7a");
        List<SysMsgSentResultDTO> result = this.recordDtlRepoProc.querySentResult(batchUuids, MsgSendTypeEnum.SYS_INTERIOR);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<SysMsgViewResultDTO>> getViewedResult(String batchUuid) {
        Assert.hasText((String)batchUuid, (String)"\u53d1\u9001\u8bb0\u5f55ID\u4e3a\u7a7a");
        List<SysMsgViewResultDTO> resultList = this.recordDtlRepoProc.queryViewResult(batchUuid, MsgSendTypeEnum.SYS_INTERIOR);
        for (SysMsgViewResultDTO sysMsgViewResultDTO : resultList) {
            if (sysMsgViewResultDTO.getViewed() != null) continue;
            sysMsgViewResultDTO.setViewed(Boolean.valueOf(false));
        }
        return ApiResult.ok(resultList);
    }

    @Override
    public ApiResult<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO> querySentResult(String batchUuid) {
        if (CharSequenceUtil.isBlank((CharSequence)batchUuid)) {
            return ApiResult.fail((String)"\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a");
        }
        List<SysMsgSendRecordDtlDO> recordDtlList = this.recordDtlRepoProc.queryByBatchId(batchUuid);
        if (recordDtlList.isEmpty()) {
            return ApiResult.fail((String)"\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO resultDTO = this.convertSentResult(recordDtlList).get(0);
        return ApiResult.ok((Object)resultDTO);
    }

    @Override
    public ApiResult<List<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO>> querySentResults(Set<String> batchUuidList) {
        if (CollUtil.isEmpty(batchUuidList)) {
            return ApiResult.fail((String)"\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a");
        }
        List<SysMsgSendRecordDtlDO> recordDtlList = this.recordDtlRepoProc.queryByBatchId(batchUuidList);
        if (recordDtlList.isEmpty()) {
            return ApiResult.fail((String)"\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        List<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO> resultDTO = this.convertSentResult(recordDtlList);
        return ApiResult.ok(resultDTO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> retrySend(String batchUuid) {
        if (CharSequenceUtil.isBlank((CharSequence)batchUuid)) {
            return ApiResult.fail((String)"\u6d88\u606f\u6279\u6b21ID\u4e3a\u7a7a");
        }
        List<SysMsgSendRecordDtlDO> recordDtlList = this.recordDtlRepoProc.queryByBatchId(batchUuid);
        if (recordDtlList.isEmpty()) {
            return ApiResult.fail((String)"\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        Set messageIds = recordDtlList.stream().filter(t -> MsgSendStateEnum.FAILED.name().equals(t.getSendState()) && CharSequenceUtil.isNotBlank((CharSequence)t.getSentEndMessage())).map(SysMsgSendRecordDtlDO::getSentEndMessage).collect(Collectors.toSet());
        if (messageIds.isEmpty()) {
            return ApiResult.ok((Object)batchUuid);
        }
        for (String messageId : messageIds) {
            try {
                Messenger.retrySend((String)messageId, (Boolean)true);
            }
            catch (Exception e) {
                log.error("\u91cd\u8bd5\u6d88\u606f\u5f02\u5e38\uff1a{}", (Object)messageId, (Object)e);
            }
        }
        List msgResultList = null;
        try {
            msgResultList = Messenger.querySendResult(messageIds);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6d88\u606f\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
        }
        if (CollUtil.isNotEmpty((Collection)msgResultList)) {
            for (MsgResultDTO msgResultDTO : msgResultList) {
                String state = MsgSendStatusEnum.SENDING.name().equals(msgResultDTO.getStatusName()) ? MsgSendStateEnum.SENDING.name() : (MsgSendStatusEnum.SENT_FAIL.name().equals(msgResultDTO.getStatusName()) ? MsgSendStateEnum.FAILED.name() : MsgSendStateEnum.OK.name());
                this.recordDtlRepoProc.updateSendResult(batchUuid, msgResultDTO.getMessageId(), state, msgResultDTO.getFailMsg());
            }
        }
        return ApiResult.ok((Object)batchUuid);
    }

    @Override
    public ApiResult<List<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlByRecordId(Long sendRecordId) {
        MapBuilder mapBuilder = ((MapBuilder)((MapBuilder)MapUtils.builder().field(SysMsgSendRecordDtlQueryBean::getMsgSendRecordId, new Object[]{sendRecordId})).op((FieldOp)FieldOps.Equal)).orderBy(SysMsgSendRecordDtlQueryBean::getSentTimeStart).desc();
        SearchResult result = this.beanSearcher.search(SysMsgSendRecordDtlQueryBean.class, mapBuilder.build());
        return ApiResult.ok((Object)result.getDataList());
    }

    @Override
    public ApiResult<SearchResult<SysMsgSendRecordDtlQueryBean>> sysMsgSendRecordDtlInteriorQuery(SysMsgSendRecordDtlInteriorQueryVO qvo) {
        MapBuilder mapBuilder = (MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)MapUtils.builder().selectExclude(new FieldFns.FieldFn[]{SysMsgSendRecordDtlQueryBean::getSentErrMessage}).page((long)qvo.getCurrent().intValue(), qvo.getSize().intValue()).field(SysMsgSendRecordDtlQueryBean::getRecipientUserId, new Object[]{qvo.getRecipientUserId()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getRecipientUserName, new Object[]{qvo.getRecipientUserName()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getRecipientUserCode, new Object[]{qvo.getRecipientUserCode()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getSentTypeCode, new Object[]{qvo.getMsgSendTypeEnum().name()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getSendState, new Object[]{qvo.getSendState()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getReadFlg, new Object[]{qvo.getReadFlag()})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getTitleContent, new Object[]{qvo.getTitle()})).op((FieldOp)FieldOps.Contain)).field(SysMsgSendRecordDtlQueryBean::getMessageContent, new Object[]{qvo.getContent()})).op((FieldOp)FieldOps.Contain)).field(SysMsgSendRecordDtlQueryBean::getSentTimeStart, new Object[]{qvo.getSentTimeStart(), qvo.getSentTimeStartEnd()})).op((FieldOp)FieldOps.Between);
        BeanSearcherUtils.setParamsOrderBy((List)qvo.getOrders(), (MapBuilder)mapBuilder, (OrderBy)new OrderBy("sentTimeStart", "asc"));
        SearchResult result = this.beanSearcher.search(SysMsgSendRecordDtlQueryBean.class, mapBuilder.build());
        if (CollUtil.isNotEmpty((Collection)result.getDataList())) {
            for (SysMsgSendRecordDtlQueryBean data : result.getDataList()) {
                if (!StringUtils.hasText((String)data.getCustomParamJson())) continue;
                data.setCustomParam((Map)JSONUtil.json2Obj((String)data.getCustomParamJson(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
        }
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<SysMsgSendRecordDtlQueryBean> sysMsgSendRecordDtlInteriorByDtlIdQuery(Long dtlId, Long userId) {
        MapBuilder mapBuilder = (MapBuilder)((MapBuilder)MapUtils.builder().field(BasicsBean::getId, new Object[]{dtlId})).op((FieldOp)FieldOps.Equal);
        SysMsgSendRecordDtlQueryBean result = (SysMsgSendRecordDtlQueryBean)this.beanSearcher.searchFirst(SysMsgSendRecordDtlQueryBean.class, mapBuilder.build());
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<Long> countToView() {
        GeneralUserDetails user = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        long num = this.recordDtlRepoProc.countToView(user.getUsername());
        return ApiResult.ok((Object)num);
    }

    @Override
    public ApiResult<SysMsgSendRecordDtlQueryBean> getRecordDetail(String msgId) {
        Assert.hasText((String)msgId, (String)"\u6d88\u606fID\u4e3a\u7a7a");
        String currentUser = SecurityContextUtil.currentUserName();
        MapBuilder mapBuilder = (MapBuilder)((MapBuilder)((MapBuilder)((MapBuilder)MapUtils.builder().field(SysMsgSendRecordDtlQueryBean::getSentEndMessage, new Object[]{msgId})).op((FieldOp)FieldOps.Equal)).field(SysMsgSendRecordDtlQueryBean::getRecipientUserCode, new Object[]{currentUser})).op((FieldOp)FieldOps.Equal);
        SysMsgSendRecordDtlQueryBean result = (SysMsgSendRecordDtlQueryBean)this.beanSearcher.searchFirst(SysMsgSendRecordDtlQueryBean.class, mapBuilder.build());
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> interiorReadUpdate(Long id, Boolean readFlg) {
        this.sysMsgSendRecordDtlRepository.findById(id).ifPresentOrElse(sysMsgSendRecordDtlDO -> {
            if (Boolean.TRUE.equals(sysMsgSendRecordDtlDO.getReadFlg())) {
                return;
            }
            sysMsgSendRecordDtlDO.setReadFlg(readFlg);
            sysMsgSendRecordDtlDO.setReadTime(DateUtil.now());
            this.sysMsgSendRecordDtlRepository.save(sysMsgSendRecordDtlDO);
            if (StringUtils.hasText((String)sysMsgSendRecordDtlDO.getSentEndMessage())) {
                CompletableFuture.runAsync(() -> Messenger.updateReceiveStatus((String)sysMsgSendRecordDtlDO.getSentEndMessage(), (String)sysMsgSendRecordDtlDO.getRecipientUserCode(), (MsgReceiveStatusEnum)MsgReceiveStatusEnum.VIEWED), (Executor)this.taskExecutor).whenComplete((v, e) -> {
                    if (e != null) {
                        log.error("\u66f4\u65b0\u6d88\u606f\u72b6\u6001\u5f02\u5e38\uff1a", e);
                    }
                });
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateViewed(Set<Long> ids, Boolean viewed) {
        Assert.notEmpty(ids, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        viewed = viewed == null || viewed != false;
        this.recordDtlRepoProc.updateViewed(ids, viewed);
        Map<String, String> endMessageMap = this.recordDtlRepoProc.querySentEndMessage(ids);
        CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : endMessageMap.entrySet()) {
                Messenger.updateReceiveStatus((String)((String)entry.getKey()), (String)((String)entry.getValue()), (MsgReceiveStatusEnum)MsgReceiveStatusEnum.VIEWED);
            }
        }, (Executor)this.taskExecutor).whenComplete((v, e) -> {
            if (e != null) {
                log.error("\u66f4\u65b0\u6d88\u606f\u72b6\u6001\u5f02\u5e38\uff1a", e);
            }
        });
        return ApiResult.ok((Object)true);
    }

    private List<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO> convertSentResult(List<SysMsgSendRecordDtlDO> recordDtlBatchList) {
        Set messageIds = recordDtlBatchList.stream().map(SysMsgSendRecordDtlDO::getSentEndMessage).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        List messageResultList = messageIds.isEmpty() ? Collections.emptyList() : Messenger.querySendResult(messageIds);
        Map messageResultMap = CollUtil.isEmpty((Collection)messageResultList) ? Collections.emptyMap() : messageResultList.stream().collect(Collectors.toMap(MsgResultDTO::getMessageId, Function.identity(), (t1, t2) -> t1));
        Map<String, Map> typeRecordDtlMap = recordDtlBatchList.stream().collect(Collectors.groupingBy(SysMsgSendRecordDtlDO::getBatchUuid, Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().collect(Collectors.groupingBy(SysMsgSendRecordDtlDO::getSentTypeCode)))));
        ArrayList<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO> resultDtoList = new ArrayList<com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO>();
        com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO resultDTO = null;
        for (Map.Entry<String, Map> typeEntry : typeRecordDtlMap.entrySet()) {
            String batchId = typeEntry.getKey();
            resultDTO = new com.elitescloud.cloudt.system.dto.resp.SysMsgSentResultDTO();
            Map recordDtlMap = typeEntry.getValue();
            resultDTO.setRecordId(batchId);
            resultDTO.setResultMap(new HashMap(8));
            for (Map.Entry entry : recordDtlMap.entrySet()) {
                SysMsgSentResultDTO.SentTypeResult sentTypeResult = new SysMsgSentResultDTO.SentTypeResult();
                SysMsgSendRecordDtlDO recordDtl = (SysMsgSendRecordDtlDO)((Object)((List)entry.getValue()).get(0));
                long successNum = ((List)entry.getValue()).stream().filter(t -> MsgSendStateEnum.OK.name().equals(t.getSendState())).count();
                boolean isAllSucceed = successNum == (long)((List)entry.getValue()).size();
                sentTypeResult.setSentTime(recordDtl.getSentTimeStart());
                sentTypeResult.setFinishTime(recordDtl.getSentTimeEnd());
                sentTypeResult.setSendState(MsgSendStateEnum.parse((String)recordDtl.getSendState()));
                sentTypeResult.setAllSucceed(Boolean.valueOf(isAllSucceed));
                sentTypeResult.setFailMsg(recordDtl.getSentErrMessage());
                sentTypeResult.setReceiverList(((List)entry.getValue()).stream().map(t -> {
                    SysMsgSentResultDTO.MsgUser msgUser = new SysMsgSentResultDTO.MsgUser();
                    msgUser.setUserId(t.getRecipientUserId());
                    msgUser.setUsername(t.getRecipientUserCode());
                    msgUser.setFullName(t.getRecipientUserName());
                    msgUser.setSendState(MsgSendStateEnum.parse((String)t.getSendState()));
                    msgUser.setAccount(t.getRecipientAccount());
                    msgUser.setAccountType(t.getRecipientAccountType());
                    return msgUser;
                }).collect(Collectors.toList()));
                if (CharSequenceUtil.isNotBlank((CharSequence)recordDtl.getSentEndMessage())) {
                    MsgResultDTO messageResult = (MsgResultDTO)messageResultMap.get(recordDtl.getSentEndMessage());
                    if (MsgSendStatusEnum.SENT_FAIL.name().equals(messageResult.getStatusName())) {
                        sentTypeResult.setFailMsg(messageResult.getFailMsg());
                        sentTypeResult.setSendState(MsgSendStateEnum.FAILED);
                    } else if (MsgSendStatusEnum.SENT.name().equals(messageResult.getStatusName())) {
                        sentTypeResult.setFailMsg("\u53d1\u9001\u6210\u529f");
                        sentTypeResult.setSendState(MsgSendStateEnum.OK);
                    } else if (MsgSendStatusEnum.SENDING.name().equals(messageResult.getStatusName())) {
                        sentTypeResult.setFailMsg("\u53d1\u9001\u4e2d");
                        sentTypeResult.setSendState(MsgSendStateEnum.SENDING);
                    }
                }
                resultDTO.getResultMap().put(MsgSendTypeEnum.parse((String)((String)entry.getKey())), sentTypeResult);
            }
            resultDtoList.add(resultDTO);
        }
        return resultDtoList;
    }
}

