/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.modules.orgtree.common.OrgUdcEnum;
import com.elitescloud.cloudt.system.modules.orgtree.common.UserUtil;
import com.elitescloud.cloudt.system.modules.orgtree.common.UtilEnum;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgBuTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgBuTreeDConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeAndTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreedAllDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVListParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeVersionDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeDRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeDRepoProc;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuTreeDDomainServiceImpl
implements OrgBuTreeDDomainService {
    private static final String ONE = "1";
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final OrgBuTreeDRepoProc orgBuTreeDRepoProc;
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final OrgBuTreeVersionDomainService orgBuTreeVersionService;
    private final UdcProvider sysUdcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<OrgBuTreeDDetailDTO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList) {
        boolean isRoot;
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        ArrayList<OrgBuTreeDDO> buTreeDDos = new ArrayList<OrgBuTreeDDO>();
        paramList.forEach(s -> {
            if (!this.buIdIsExist((OrgBuTreeDSaveParam)s).booleanValue()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u8282\u70b9\u65b0\u589e\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u6811\u4e0a\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            buTreeDDos.add(OrgBuTreeDConvert.INSTANCE.saveParamToDo((OrgBuTreeDSaveParam)s));
        });
        boolean bl = isRoot = ((OrgBuTreeDDO)buTreeDDos.get(0)).getPid() == null || ((OrgBuTreeDDO)buTreeDDos.get(0)).getPid().equals(0L);
        if (isRoot) {
            long pid = 0L;
            int level = 1;
            buTreeDDos.forEach(ddo -> {
                ddo.setPid(pid);
                ddo.setLevel(level);
                ddo.setCodePath(ddo.getBuCode());
            });
        } else {
            Optional pBuNodeOptional = this.orgBuTreeDRepo.findById(((OrgBuTreeDDO)buTreeDDos.get(0)).getPid());
            if (pBuNodeOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u7236\u7ea7\u7ec4\u7ec7");
            }
            OrgBuTreeDDO pBuNode = (OrgBuTreeDDO)pBuNodeOptional.get();
            Integer level = pBuNode.getLevel() == null ? null : Integer.valueOf(pBuNode.getLevel() + 1);
            String codePath = pBuNode.getCodePath() == null ? null : pBuNode.getCodePath();
            buTreeDDos.forEach(ddo -> {
                ddo.setLevel(level);
                ddo.setCodePath(codePath == null ? null : codePath + "/" + ddo.getBuCode());
            });
        }
        List resultList = this.orgBuTreeDRepo.saveAll(buTreeDDos);
        if (StringUtils.isNotBlank((CharSequence)paramList.get(0).getBuTreeDId())) {
            List<OrgBuTreeDDO> orgBuTreeDetailList = this.orgBuTreeDUpdate(paramList, resultList);
            buTreeDDos.addAll(orgBuTreeDetailList);
        }
        List<OrgBuTreeDDetailDTO> orgBuTreeDDetailDTOList = OrgBuTreeDConvert.INSTANCE.doToDto(buTreeDDos);
        return orgBuTreeDDetailDTOList;
    }

    private List<OrgBuTreeDDO> orgBuTreeDUpdate(List<OrgBuTreeDSaveParam> paramList, List<OrgBuTreeDDO> resultList) {
        if (paramList.size() > 1) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u9009\u4e00\u4e2a\u7236\u7ea7");
        }
        OrgBuTreeDSaveParam orgBuTreeDSaveParam = paramList.get(0);
        Optional orgBuTreeDOptional = this.orgBuTreeDRepo.findById(Long.valueOf(orgBuTreeDSaveParam.getBuTreeDId()));
        if (!orgBuTreeDOptional.isPresent()) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38,\u7ec4\u7ec7\u6811\u8282\u70b9:" + orgBuTreeDSaveParam.getBuTreeDId() + "\uff0c\u4e0d\u5b58\u5728");
        }
        OrgBuTreeDDO orgBuTreeDDO = (OrgBuTreeDDO)orgBuTreeDOptional.get();
        List<OrgBuTreeDDO> orgBuTreeDDOList = this.orgBuTreeDRepo.findAllByBuTreeIdAndCodePathLike(orgBuTreeDDO.getBuTreeId(), orgBuTreeDDO.getCodePath() + "%");
        Long pid = resultList.get(0).getId();
        String oldCodePath = orgBuTreeDDO.getCodePath();
        String newCodePath = resultList.get(0).getCodePath() + "/" + orgBuTreeDDO.getBuCode();
        List saveDos = orgBuTreeDDOList.stream().map(s -> {
            if (String.valueOf(s.getId()).equals(orgBuTreeDSaveParam.getBuTreeDId())) {
                s.setPid(pid);
            }
            s.setCodePath(s.getCodePath().replace(oldCodePath, newCodePath));
            s.setLevel(s.getLevel() + 1);
            return s;
        }).collect(Collectors.toList());
        List orgBuTreeDetailList = this.orgBuTreeDRepo.saveAll(saveDos);
        return orgBuTreeDetailList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTreeDetail(Long id, Long buTreeId) {
        List<OrgBuTreedAllDTO> result = this.orgBuTreedAllSearch(id, UtilEnum.CODE_TYPE.getValue(), buTreeId);
        result.stream().map(s -> s.getId()).forEach(arg_0 -> ((OrgBuTreeDRepo)this.orgBuTreeDRepo).deleteById(arg_0));
        this.orgBuTreeDRepo.deleteById(id);
    }

    @Override
    @SysCodeProc
    public List<OrgBuTreedAllDTO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId) {
        if (UtilEnum.CODE_TYPE.getValue().equals(searchType)) {
            ArrayList<OrgBuTreedAllDTO> result = new ArrayList<OrgBuTreedAllDTO>();
            List<OrgBuTreedAllDTO> orgBuTreedVOList = this.orgBuTreeDRepoProc.selectAllBuByBuTreeId(buTreeId);
            if (CollectionUtils.isNotEmpty(orgBuTreedVOList)) {
                Map udcMap = this.sysUdcService.getValueMapByUdcCode("yst-supp", "BU_TYPE");
                orgBuTreedVOList.forEach(s -> s.setBuTypeName((String)udcMap.get(s.getBuType())));
                return this.build(orgBuTreedVOList, id, result);
            }
            return Collections.emptyList();
        }
        return this.orgBuTreeDRepoProc.selectByPid(id);
    }

    @Override
    public List<OrgBuTreeDDTO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId) {
        return this.orgBuTreeVersionService.getOrgBuTreeDFromSystem(buTreeId, searchType, buTreeDId);
    }

    private List<OrgBuTreedAllDTO> build(List<OrgBuTreedAllDTO> orgBuTreedVOList, Long id, List<OrgBuTreedAllDTO> result) {
        List treedList = orgBuTreedVOList.stream().filter(s -> id.equals(s.getPid())).collect(Collectors.toList());
        for (OrgBuTreedAllDTO vo : treedList) {
            result.add(vo);
            this.build(orgBuTreedVOList, vo.getId(), result);
        }
        return result;
    }

    public Boolean buIdIsExist(OrgBuTreeDSaveParam param) {
        List buIds;
        Optional<List<OrgBuTreeDDO>> optional = this.orgBuTreeDRepo.findByBuTreeId(Long.valueOf(param.getBuTreeId()));
        if (optional.isPresent() && StringUtils.isNotBlank((CharSequence)param.getBuId()) && (buIds = optional.get().stream().map(s -> s.getBuId()).collect(Collectors.toList())).contains(Long.valueOf(param.getBuId()))) {
            return false;
        }
        return true;
    }

    public List<OrgBuTreedAllDTO> buTreedDown(List<OrgBuTreedAllDTO> orgBuTreeDDOs, Long pid, List<OrgBuTreedAllDTO> result) {
        if (pid == null || pid == 0L) {
            return result;
        }
        Optional<OrgBuTreedAllDTO> buOptional = orgBuTreeDDOs.stream().filter(s -> s.getId().equals(pid)).findFirst();
        buOptional.ifPresent(t -> {
            result.add((OrgBuTreedAllDTO)t);
            this.buTreedDown(orgBuTreeDDOs, t.getPid(), result);
        });
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #param.id", condition="#param.id != null")
    public void saveBuTreeDV(OrgBuTreeVSaveParam param) {
        OrgBuTreeDO orgBuTreeDO = OrgBuTreeConvert.INSTANCE.saveVDParaToDo(param);
        boolean updateFlag = false;
        if (null == param.getId()) {
            if (ONE.equals(param.getBuTreeVersion())) {
                orgBuTreeDO.setNowVersion(ONE);
                if (this.orgBuTreeRepo.existsByBuTreeCode(param.getBuTreeCode())) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
                }
            } else {
                List<OrgBuTreeDTO> buTreeVersion = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(OrgBuTreeVListParam.builder().buTreeCode(param.getBuTreeCode()).build());
                Map collect = buTreeVersion.stream().collect(HashMap::new, (m, v) -> m.put(Integer.valueOf(v.getNowVersion()), v.getBuTreeStatus()), HashMap::putAll);
                Optional maxNowVersion = collect.keySet().stream().max(Integer::compareTo);
                if (maxNowVersion.isPresent()) {
                    String status = (String)collect.get(maxNowVersion.get());
                    if (OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(status)) {
                        throw new BusinessException("\u5f53\u524d\u5b58\u5728\u5c1a\u672a\u53d1\u5e03\u7684\u7ec4\u7ec7\u6811\uff0c\u65e0\u6cd5\u521b\u5efa\u65b0\u7248\u672c\u7ec4\u7ec7\u6811");
                    }
                }
                Integer maxVersion = null;
                if (maxNowVersion.isPresent()) {
                    maxVersion = (Integer)maxNowVersion.get();
                    String nowVersion = "" + (maxVersion + 1);
                    if (param.getBuTreeVersion().equals(nowVersion)) {
                        orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
                    } else {
                        orgBuTreeDO.setNowVersion(nowVersion);
                    }
                } else {
                    orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
                }
            }
        } else {
            orgBuTreeDO.setNowVersion(param.getBuTreeVersion());
            updateFlag = true;
        }
        orgBuTreeDO.setBuTreeVersion(null);
        Long id = null;
        if (null != param.getId()) {
            Optional byId = this.orgBuTreeRepo.findById(param.getId());
            if (!byId.isPresent()) throw new BusinessException("\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728");
            OrgBuTreeDO buTreeDO = (OrgBuTreeDO)byId.get();
            OrgBuTreeConvert.INSTANCE.updateDoFromParamV(buTreeDO, param);
            this.orgBuTreeRepo.save(buTreeDO);
            id = buTreeDO.getId();
        } else {
            orgBuTreeDO.setIsNowVersion(false);
            orgBuTreeDO.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal());
            orgBuTreeDO.setDeleteFlag(0);
            OrgBuTreeDO save = (OrgBuTreeDO)this.orgBuTreeRepo.save(orgBuTreeDO);
            id = save.getId();
        }
        List<OrgBuTreeVDSaveParam> buTreeDList = param.getTreeVDSaveParams();
        this.orgBuTreeVersionService.saveBuTreeDV(buTreeDList, id, updateFlag);
    }

    @Override
    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return this.orgBuTreeRepoProc.getBuTreeVersionByBuTreeCode(buTreeCode);
    }

    @Override
    public List<OrgBuTreeDTO> getBuTreeListByParam(OrgBuTreeVListParam param) {
        return this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(param);
    }

    @Override
    @SysCodeProc
    public OrgBuTreeAndTreeDDTO getBuTreeDListByBuTreeCode(OrgBuTreeVListParam param) {
        List<OrgBuTreeDTO> buTreeListByBuTreeCode = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(param);
        if (buTreeListByBuTreeCode.isEmpty()) {
            return null;
        }
        if (buTreeListByBuTreeCode.size() == 1) {
            OrgBuTreeDTO orgBuTreeDTO = buTreeListByBuTreeCode.get(0);
            OrgBuTreeAndTreeDDTO orgBuTreeAndTreeDVO = OrgBuTreeConvert.INSTANCE.dtoToDDto(orgBuTreeDTO);
            if (orgBuTreeDTO != null) {
                orgBuTreeAndTreeDVO.setOrgBuTreeDVOList(this.orgBuTreeVersionService.getOrgBuTreeDByCache(orgBuTreeDTO.getId(), UtilEnum.CODE_TYPE.getValue(), null));
            }
            return orgBuTreeAndTreeDVO;
        }
        throw new BusinessException("\u51fa\u73b0\u91cd\u590d\u7248\u672c\u6570\u636e\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    @Override
    public void releaseBuTreeVersion(Long id) {
        Optional nowVersionOptional = this.orgBuTreeRepo.findById(id);
        if (nowVersionOptional.isPresent()) {
            OrgBuTreeDO nowVersion = (OrgBuTreeDO)nowVersionOptional.get();
            List<OrgBuTreeDO> nowActiveBuTreeList = this.orgBuTreeRepoProc.getNowActiveBuTree(nowVersion.getBuTreeCode());
            LocalDateTime now = LocalDateTime.now();
            if (CollectionUtils.isEmpty(nowActiveBuTreeList)) {
                nowVersion.setReleaseTime(now);
                nowVersion.setReleaseUser(Objects.requireNonNull(UserUtil.getNowUser()).getUsername());
                nowVersion.setIsNowVersion(true);
                nowVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal());
                this.orgBuTreeRepo.save(nowVersion);
            } else {
                int size = nowActiveBuTreeList.size();
                if (size > 1) {
                    throw new BusinessException("\u7ec4\u7ec7\u6811\u5b58\u5728\u591a\u4e2a\u751f\u6548\u7684\u7248\u672c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                }
                OrgBuTreeDO oldVersion = nowActiveBuTreeList.get(0);
                oldVersion.setIsNowVersion(false);
                oldVersion.setDisableTime(now);
                oldVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal());
                nowVersion.setReleaseTime(now);
                nowVersion.setReleaseUser(Objects.requireNonNull(UserUtil.getNowUser()).getUsername());
                nowVersion.setIsNowVersion(true);
                nowVersion.setBuTreeStatus(OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal());
                this.orgBuTreeRepo.save(oldVersion);
                this.orgBuTreeRepo.save(nowVersion);
            }
        }
    }

    @Override
    public List<OrgBuTreeDDTO> findBuTreeDByParam(OrgBuTreeDParam param) {
        return this.orgBuTreeDRepoProc.findBuTreeDByParam(param);
    }

    public OrgBuTreeDDomainServiceImpl(OrgBuTreeDRepo orgBuTreeDRepo, OrgBuTreeDRepoProc orgBuTreeDRepoProc, OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeRepoProc orgBuTreeRepoProc, OrgBuTreeVersionDomainService orgBuTreeVersionService, UdcProvider sysUdcService) {
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.orgBuTreeDRepoProc = orgBuTreeDRepoProc;
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
        this.sysUdcService = sysUdcService;
    }
}

