/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeAndTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreedAllDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeDeleteEmployeeParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeEmployeeParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeQueryEmployeeParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeDSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVListParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeAndTreeDVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDDetailVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeDVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreeVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.OrgBuTreedAllVO;
import com.elitescloud.cloudt.system.modules.orgtree.service.MultiOrgTreeQueryService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.MultiOrgTreeRepoProc;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeEmployeeDoRepo;
import com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class OrgBuTreeDServiceImpl
implements OrgBuTreeDService {
    private final OrgBuTreeDDomainService orgBuTreeDDomainService;
    private final OrgBuTreeEmployeeDoRepo orgBuTreeEmployeeDoRepo;
    private final EmployeeRepoProc employeeRepoProc;
    private final MultiOrgTreeRepoProc multiOrgTreeRepoProc;
    private final EmployeeMngService employeeMngService;
    private final OrgBuTreeService orgBuTreeService;
    private final MultiOrgTreeQueryService multiOrgTreeQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<OrgBuTreeDDetailVO> orgBuTreeDCreate(List<OrgBuTreeDSaveParam> paramList) {
        List<OrgBuTreeDDetailDTO> orgBuTreeDDetailDTOList = this.orgBuTreeDDomainService.orgBuTreeDCreate(paramList);
        return OrgTreeConvert.INSTANCE.treeDDDtoToVo(orgBuTreeDDetailDTOList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteTreeDetail(Long id, Long buTreeId) {
        this.orgBuTreeDDomainService.deleteTreeDetail(id, buTreeId);
    }

    @Override
    @SysCodeProc
    public List<OrgBuTreedAllVO> orgBuTreedAllSearch(Long id, String searchType, Long buTreeId) {
        List<OrgBuTreedAllDTO> orgBuTreedAllDTOS = this.orgBuTreeDDomainService.orgBuTreedAllSearch(id, searchType, buTreeId);
        return OrgTreeConvert.INSTANCE.treeDAllDtoToVo(orgBuTreedAllDTOS);
    }

    @Override
    public List<OrgBuTreeDVO> orgBuTreeDSearchTree(Long buTreeId, String searchType, Long buTreeDId) {
        List<OrgBuTreeDDTO> orgBuTreeDDTOS = this.orgBuTreeDDomainService.orgBuTreeDSearchTree(buTreeId, searchType, buTreeDId);
        return OrgTreeConvert.INSTANCE.treeDDtoToVo(orgBuTreeDDTOS);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBuTreeDV(OrgBuTreeVSaveParam param) {
        this.orgBuTreeDDomainService.saveBuTreeDV(param);
    }

    @Override
    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return this.orgBuTreeDDomainService.getBuTreeVersionByBuTreeCode(buTreeCode);
    }

    @Override
    public List<OrgBuTreeVO> getBuTreeListByParam(OrgBuTreeVListParam param) {
        List<OrgBuTreeDTO> buTreeListByParam = this.orgBuTreeDDomainService.getBuTreeListByParam(param);
        return OrgTreeConvert.INSTANCE.treeDtoToVo(buTreeListByParam);
    }

    @Override
    @SysCodeProc
    public OrgBuTreeAndTreeDVO getBuTreeDListByParam(OrgBuTreeVListParam param) {
        OrgBuTreeAndTreeDDTO buTreeDListByBuTreeCode = this.orgBuTreeDDomainService.getBuTreeDListByBuTreeCode(param);
        return OrgTreeConvert.INSTANCE.dtoToVo(buTreeDListByBuTreeCode);
    }

    @Override
    public void releaseBuTreeVersion(Long id) {
        this.orgBuTreeDDomainService.releaseBuTreeVersion(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> buTreeNodeSaveEmployee(BuTreeNodeEmployeeParam param) {
        this.orgBuTreeEmployeeDoRepo.deleteByBuIdAndBuTreeId(param.getBuId(), param.getBuTreeId());
        ArrayList<OrgBuTreeEmployeeDO> buTreeEmployee = new ArrayList<OrgBuTreeEmployeeDO>();
        for (Long aLong : param.getEmployeeId()) {
            OrgBuTreeEmployeeDO orgBuTreeEmployeeDo = new OrgBuTreeEmployeeDO();
            orgBuTreeEmployeeDo.setBuTreeId(param.getBuTreeId());
            orgBuTreeEmployeeDo.setBuId(param.getBuId());
            orgBuTreeEmployeeDo.setBuCode(param.getBuCode());
            orgBuTreeEmployeeDo.setEmployeeId(aLong);
            buTreeEmployee.add(orgBuTreeEmployeeDo);
        }
        this.orgBuTreeEmployeeDoRepo.saveAll(buTreeEmployee);
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public ApiResult<String> buTreeNodeDeleteEmployee(BuTreeNodeDeleteEmployeeParam param) {
        QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> qdo.buId.eq(arg_0), (Object)param.getBuId()).and(arg_0 -> qdo.buTreeId.eq(arg_0), (Object)param.getBuTreeId()).and(arg_0 -> qdo.employeeId.in(arg_0), param.getEmployeeId()).getPredicate();
        this.orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> this.orgBuTreeEmployeeDoRepo.delete(orgBuTreeEmployeeDO));
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<EmployeePagedRespVO>> buTreeNodeQueryEmployee(BuTreeNodeQueryEmployeeParam param) {
        Assert.notNull((Object)param.getBuTreeId(), (String)"\u6811ID\u4e3a\u7a7a");
        Assert.notNull((Object)param.getBuId(), (String)"BuId\u4e3a\u7a7a");
        List<Long> employeeIds = this.multiOrgTreeRepoProc.queryBoundEmployeeIds(param);
        if (employeeIds.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<EmployeePagedRespVO> employeeList = this.employeeRepoProc.listMngOfPage(employeeIds);
        this.employeeMngService.fillPage(employeeList, null, null);
        return ApiResult.ok(employeeList);
    }

    @Override
    @Transactional
    public ApiResult<String> buTreeNodeAddEmployee(BuTreeNodeEmployeeParam param) {
        QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> qdo.buId.eq(arg_0), (Object)param.getBuId()).and(arg_0 -> qdo.buTreeId.eq(arg_0), (Object)param.getBuTreeId()).and(arg_0 -> qdo.employeeId.in(arg_0), param.getEmployeeId()).getPredicate();
        ArrayList orgBuTreeEmployeeDOS = new ArrayList();
        this.orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> orgBuTreeEmployeeDOS.add(orgBuTreeEmployeeDO.getEmployeeId()));
        ArrayList<OrgBuTreeEmployeeDO> buTreeEmployee = new ArrayList<OrgBuTreeEmployeeDO>();
        for (Long aLong : param.getEmployeeId()) {
            if (orgBuTreeEmployeeDOS.contains(aLong)) {
                return ApiResult.fail((String)("\u5458\u5de5\u5df2\u7ed1\u5b9a:" + aLong));
            }
            OrgBuTreeEmployeeDO orgBuTreeEmployeeDo = new OrgBuTreeEmployeeDO();
            orgBuTreeEmployeeDo.setBuTreeId(param.getBuTreeId());
            orgBuTreeEmployeeDo.setBuId(param.getBuId());
            orgBuTreeEmployeeDo.setBuCode(param.getBuCode());
            orgBuTreeEmployeeDo.setEmployeeId(aLong);
            buTreeEmployee.add(orgBuTreeEmployeeDo);
        }
        this.orgBuTreeEmployeeDoRepo.saveAll(buTreeEmployee);
        return ApiResult.ok();
    }

    @Override
    public ApiResult<List<EmpOrgTreeOrgDTO>> searchOrgByOrgTreeCodeAndEmpId(SearchByOrgTreeCodeAndEmpIdParam param) {
        OrgBuTreeDO orgBuTreeDO = this.orgBuTreeService.getOrgBuTreeDetailByCode(param.getOrgTreeCode());
        if (orgBuTreeDO == null) {
            return ApiResult.fail((String)("\u6c92\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7f16\u7801\u7ec4\u7ec7\u6811" + param.getOrgTreeCode()));
        }
        QOrgBuTreeEmployeeDO qdo = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> qdo.buTreeId.eq(arg_0), (Object)orgBuTreeDO.getId()).and(arg_0 -> qdo.employeeId.eq(arg_0), (Object)param.getEmpId()).getPredicate();
        ArrayList orgBuTreeEmployeeDOS = new ArrayList();
        this.orgBuTreeEmployeeDoRepo.findAll(predicate).iterator().forEachRemaining(orgBuTreeEmployeeDO -> orgBuTreeEmployeeDOS.add(orgBuTreeEmployeeDO));
        if (orgBuTreeEmployeeDOS.size() == 0) {
            return ApiResult.fail((String)("\u5f53\u7ec4\u7ec7\u6811\uff08" + param.getOrgTreeCode() + "\uff09\u548c\u5458\u5de5(" + param.getEmpId() + ")\u6ca1\u6709\u627e\u5230\u5458\u5de5\u6240\u5728\u7ec4\u7ec7\u6570\u636e"));
        }
        ApiResult<List<OrgTreeNodeRespVO>> apiResult = this.multiOrgTreeQueryService.getTree(orgBuTreeDO.getId(), true, false, true);
        if (!apiResult.isSuccess()) {
            return ApiResult.fail((String)apiResult.getErrorMsg());
        }
        ArrayList<EmpOrgTreeOrgDTO> empOrgTreeOrgVos = new ArrayList<EmpOrgTreeOrgDTO>();
        List data = (List)apiResult.getData();
        if (data == null || data.size() == 0) {
            return ApiResult.ok();
        }
        if (data.size() > 1) {
            return ApiResult.fail((String)("\u6570\u636e\u5f02\u5e38\uff0c\u7ec4\u7ec7\u6811\u6709\u591a\u4e2a\u6839\u8282\u70b9\uff08\u7f16\u7801" + param.getOrgTreeCode() + " ID" + orgBuTreeDO.getId() + " \u540d\u79f0" + orgBuTreeDO.getBuTreeName() + ")"));
        }
        OrgTreeNodeRespVO orgTreeNodeRespVO = (OrgTreeNodeRespVO)data.get(0);
        for (OrgBuTreeEmployeeDO orgBuTreeEmployeeDO2 : orgBuTreeEmployeeDOS) {
            EmpOrgTreeOrgDTO empOrgTreeOrgVo = new EmpOrgTreeOrgDTO();
            empOrgTreeOrgVo.setEmpId(param.getEmpId());
            empOrgTreeOrgVo.setBuTreeId(orgBuTreeDO.getId());
            empOrgTreeOrgVo.setBuTreeType(orgBuTreeDO.getBuTreeType());
            empOrgTreeOrgVo.setBuTreeCode(orgBuTreeDO.getBuTreeCode());
            empOrgTreeOrgVo.setBuTreeName(orgBuTreeDO.getBuTreeName());
            empOrgTreeOrgVo.setNowVersion(orgBuTreeDO.getNowVersion());
            OrgTreeNodeRespVO presentTreeNodeRespVO = OrgBuTreeDServiceImpl.findNodeById(orgTreeNodeRespVO, orgBuTreeEmployeeDO2.getBuId());
            empOrgTreeOrgVo.setOrgTreeNodeRespVO(presentTreeNodeRespVO);
            empOrgTreeOrgVos.add(empOrgTreeOrgVo);
        }
        return ApiResult.ok(empOrgTreeOrgVos);
    }

    public static OrgTreeNodeRespVO findNodeById(OrgTreeNodeRespVO root, Long targetId) {
        if (root.getId().equals(targetId)) {
            return root;
        }
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return null;
        }
        for (OrgTreeNodeRespVO child : root.getChildren()) {
            OrgTreeNodeRespVO found = OrgBuTreeDServiceImpl.findNodeById(child, targetId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static OrgTreeNodeRespVO findNodeByCode(OrgTreeNodeRespVO root, String targetCode) {
        if (root.getCode().equals(targetCode)) {
            return root;
        }
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return null;
        }
        for (OrgTreeNodeRespVO child : root.getChildren()) {
            OrgTreeNodeRespVO found = OrgBuTreeDServiceImpl.findNodeByCode(child, targetCode);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public OrgBuTreeDServiceImpl(OrgBuTreeDDomainService orgBuTreeDDomainService, OrgBuTreeEmployeeDoRepo orgBuTreeEmployeeDoRepo, EmployeeRepoProc employeeRepoProc, MultiOrgTreeRepoProc multiOrgTreeRepoProc, EmployeeMngService employeeMngService, OrgBuTreeService orgBuTreeService, MultiOrgTreeQueryService multiOrgTreeQueryService) {
        this.orgBuTreeDDomainService = orgBuTreeDDomainService;
        this.orgBuTreeEmployeeDoRepo = orgBuTreeEmployeeDoRepo;
        this.employeeRepoProc = employeeRepoProc;
        this.multiOrgTreeRepoProc = multiOrgTreeRepoProc;
        this.employeeMngService = employeeMngService;
        this.orgBuTreeService = orgBuTreeService;
        this.multiOrgTreeQueryService = multiOrgTreeQueryService;
    }
}

