/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.common.OrgBuTreeStatus;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeEmployeeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.BuTreeNodeQueryEmployeeParam;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class MultiOrgTreeRepoProc
extends BaseRepoProc<OrgBuTreeDO> {
    private static final QOrgBuTreeDO QDO = QOrgBuTreeDO.orgBuTreeDO;
    private static final QOrgBuTreeDDO QDO_D = QOrgBuTreeDDO.orgBuTreeDDO;
    private static final QOrgBuTreeEmployeeDO QDO_TREE_EMP = QOrgBuTreeEmployeeDO.orgBuTreeEmployeeDO;
    private static final QSysOrgDO QDO_ORG = QSysOrgDO.sysOrgDO;
    private static final QSysEmployeeDO QDO_EMP = QSysEmployeeDO.sysEmployeeDO;

    public MultiOrgTreeRepoProc() {
        super((EntityPathBase)QDO);
    }

    public List<IdCodeNameParam> queryListTree() {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{MultiOrgTreeRepoProc.QDO.id, MultiOrgTreeRepoProc.QDO.buTreeCode.as("code"), MultiOrgTreeRepoProc.QDO.buTreeName.as("name")});
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)MultiOrgTreeRepoProc.QDO.buTreeStatus, (Object)OrgBuTreeStatus.ACTIVE.getValue()).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO)).where(predicate)).orderBy(this.defaultOrder())).fetch();
    }

    public List<OrgTreeNodeRespVO> queryTreeLeaf(long treeId) {
        QBean qBean = Projections.bean(OrgTreeNodeRespVO.class, (Expression[])new Expression[]{MultiOrgTreeRepoProc.QDO_D.id, MultiOrgTreeRepoProc.QDO_D.pid.as("parentId"), MultiOrgTreeRepoProc.QDO_D.sortNo, MultiOrgTreeRepoProc.QDO_D.buId.as("tempId")});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBean).from((EntityPath)QDO_D)).where((Predicate)MultiOrgTreeRepoProc.QDO_D.buTreeId.eq((Object)treeId))).fetch();
    }

    public List<Long> queryBoundEmployeeIds(BuTreeNodeQueryEmployeeParam param) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(MultiOrgTreeRepoProc.QDO_TREE_EMP.buTreeId, (Object)param.getBuTreeId()).andEq(MultiOrgTreeRepoProc.QDO_TREE_EMP.buId, (Object)param.getBuId()).and(true, () -> ((JPQLQuery)JPAExpressions.select((Expression)MultiOrgTreeRepoProc.QDO_EMP.id).from(new EntityPath[]{QDO_EMP}).where(new Predicate[]{MultiOrgTreeRepoProc.QDO_EMP.id.eq(MultiOrgTreeRepoProc.QDO_TREE_EMP.employeeId)})).exists()).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(MultiOrgTreeRepoProc.QDO_TREE_EMP.employeeId).from((EntityPath)QDO_TREE_EMP)).where(predicate)).fetch();
    }

    public List<SysEmployeeBasicDTO> queryBoundEmployee(long treeId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanEmployeeBasicDTO()).from((EntityPath)QDO_EMP)).leftJoin((EntityPath)QDO_TREE_EMP)).on((Predicate)MultiOrgTreeRepoProc.QDO_TREE_EMP.employeeId.eq((Expression)MultiOrgTreeRepoProc.QDO_EMP.id))).where((Predicate)MultiOrgTreeRepoProc.QDO_TREE_EMP.buTreeId.eq((Object)treeId))).fetch();
    }

    public void deleteEmployeeOfTree(long treeId) {
        this.jpaQueryFactory.delete((EntityPath)QDO_TREE_EMP).where(new Predicate[]{MultiOrgTreeRepoProc.QDO_TREE_EMP.buTreeId.eq((Object)treeId)}).execute();
    }

    private OrderSpecifier<?> defaultOrder() {
        return MultiOrgTreeRepoProc.QDO.createTime.asc();
    }

    private QBean<SysEmployeeBasicDTO> qBeanEmployeeBasicDTO() {
        return Projections.bean(SysEmployeeBasicDTO.class, (Expression[])new Expression[]{MultiOrgTreeRepoProc.QDO_EMP.id, MultiOrgTreeRepoProc.QDO_EMP.userId, MultiOrgTreeRepoProc.QDO_EMP.rootOrgId, MultiOrgTreeRepoProc.QDO_EMP.lastName, MultiOrgTreeRepoProc.QDO_EMP.firstName, MultiOrgTreeRepoProc.QDO_EMP.gender, MultiOrgTreeRepoProc.QDO_EMP.code, MultiOrgTreeRepoProc.QDO_EMP.email, MultiOrgTreeRepoProc.QDO_EMP.phone, MultiOrgTreeRepoProc.QDO_EMP.type, MultiOrgTreeRepoProc.QDO_EMP.served, MultiOrgTreeRepoProc.QDO_EMP.photo, MultiOrgTreeRepoProc.QDO_EMP.enabled, MultiOrgTreeRepoProc.QDO_EMP.sortNo, MultiOrgTreeRepoProc.QDO_TREE_EMP.buId.as("orgId")});
    }
}

