/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.common.OrgUdcEnum;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreePagingDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.QOrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreePagingParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVListParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVPagingParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OrgBuTreeRepoProc {
    private static final String DRAFT = OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal();
    private static final String ACTIVE = OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal();
    private final JPAQueryFactory jpaQueryFactory;
    private final QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;

    private JPAQuery<OrgBuTreePagingDTO> select() {
        QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreePagingDTO.class, (Expression[])new Expression[]{orgBuTreeDO.id, orgBuTreeDO.buTreeCode, orgBuTreeDO.buTreeName, orgBuTreeDO.buTreeType, orgBuTreeDO.buTreeStatus, orgBuTreeDO.nowVersion, orgBuTreeDO.createTime, orgBuTreeDO.modifyTime, orgBuTreeDO.updater, orgBuTreeDO.creator, orgBuTreeDO.versionInstruction})).from((EntityPath)orgBuTreeDO);
    }

    private Predicate where(OrgBuTreePagingParam param) {
        QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;
        BooleanExpression predicate = orgBuTreeDO.deleteFlag.eq((Object)0).or((Predicate)orgBuTreeDO.deleteFlag.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)orgBuTreeDO.buTreeCode.like("%" + param.getBuTreeCode() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)orgBuTreeDO.buTreeName.like("%" + param.getBuTreeName() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)orgBuTreeDO.buTreeType.eq((Object)param.getBuTreeType()));
        predicate = StringUtils.isBlank((CharSequence)param.getBuTreeStatus()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)orgBuTreeDO.buTreeStatus.eq((Object)param.getBuTreeStatus()));
        return predicate;
    }

    public PagingVO<OrgBuTreePagingDTO> searchByParams(OrgBuTreePagingParam param) {
        QOrgBuTreeDO orgBuTreeDO = QOrgBuTreeDO.orgBuTreeDO;
        JPAQuery query = (JPAQuery)this.select().where(this.where(param));
        param.fillOrders(query, orgBuTreeDO);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<OrgBuTreeDTO> getBuTreeListByBuTreeCode(OrgBuTreeVListParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (param.getId() != null) {
            predicates.add(this.orgBuTreeDO.id.eq((Object)param.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getVersion())) {
            predicates.add(this.orgBuTreeDO.nowVersion.eq((Object)param.getVersion()));
        }
        if (null != param.getWhetherViewResumeData() && param.getWhetherViewResumeData().booleanValue()) {
            predicates.add(this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal()).or((Predicate)this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal())));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDTO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<OrgBuTreeDO> getNowActiveBuTree(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode).and((Predicate)this.orgBuTreeDO.isNowVersion.eq(Boolean.valueOf(true))))).fetch();
    }

    public List<String> findActiveVersionByBuTreeCode(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO.nowVersion).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode).and((Predicate)this.orgBuTreeDO.isNowVersion.eq(Boolean.valueOf(true))))).fetch();
    }

    public List<OrgBuTreeDTO> findOrgBuTreeVoByParam(OrgBuTreeParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getNowVersion())) {
            predicates.add(this.orgBuTreeDO.nowVersion.eq((Object)param.getNowVersion()));
        }
        if (null != param.getIsNowVersion()) {
            predicates.add(this.orgBuTreeDO.isNowVersion.eq(param.getIsNowVersion()));
        }
        if (CollectionUtils.isNotEmpty(param.getBuTreeCodes())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.in(param.getBuTreeCodes()));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDTO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public PagingVO<OrgBuTreeDTO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getBuTreeCode())) {
            predicates.add(this.orgBuTreeDO.buTreeCode.eq((Object)param.getBuTreeCode()));
        }
        predicates.add(this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_ACTIVE.getUdcVal()).or((Predicate)this.orgBuTreeDO.buTreeStatus.eq((Object)OrgUdcEnum.ORG_BUTREE_STATUS_CLOSED.getUdcVal())));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDTO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.createTime, this.orgBuTreeDO.creator, this.orgBuTreeDO.releaseTime, this.orgBuTreeDO.releaseUser, this.orgBuTreeDO.isNowVersion, this.orgBuTreeDO.versionInstruction, this.orgBuTreeDO.disableTime})).from((EntityPath)this.orgBuTreeDO)).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.orgBuTreeDO);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<String> getBuTreeVersionByBuTreeCode(String buTreeCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.orgBuTreeDO.nowVersion).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.buTreeCode.eq((Object)buTreeCode))).fetch();
    }

    public OrgBuTreeDetailDTO findBuTreeDetailById(Long id) {
        return (OrgBuTreeDetailDTO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(OrgBuTreeDetailDTO.class, (Expression[])new Expression[]{this.orgBuTreeDO.id, this.orgBuTreeDO.buTreeType, this.orgBuTreeDO.buTreeStatus, this.orgBuTreeDO.buTreeCode, this.orgBuTreeDO.buTreeName, this.orgBuTreeDO.buTreeVersion, this.orgBuTreeDO.nowVersion, this.orgBuTreeDO.versionInstruction})).from((EntityPath)this.orgBuTreeDO)).where((Predicate)this.orgBuTreeDO.id.eq((Object)id))).fetchOne();
    }

    public void updateStatusByIds(List<Long> ids, String buTreeStatus) {
        this.jpaQueryFactory.update((EntityPath)this.orgBuTreeDO).set((Path)this.orgBuTreeDO.buTreeStatus, (Object)buTreeStatus).set((Path)this.orgBuTreeDO.isNowVersion, (Object)false).set(this.orgBuTreeDO.disableTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.orgBuTreeDO.id.in(ids)}).execute();
    }

    public OrgBuTreeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

