/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.warning.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class AbstractSysWarningService {
    private static final Map<String, Integer> WEEK_MAP = new HashMap<String, Integer>();
    private static final Map<String, Integer> MONTH_MAP = new HashMap<String, Integer>();

    AbstractSysWarningService() {
    }

    protected int obtainDayOfWeek(String userInput) {
        if (userInput.startsWith("\u661f\u671f")) {
            userInput = userInput.substring(2);
        } else if (userInput.startsWith("\u5468")) {
            userInput = userInput.substring(1);
        }
        if (WEEK_MAP.containsKey(userInput)) {
            return WEEK_MAP.get(userInput);
        }
        int week = Integer.parseInt(userInput);
        if (week >= 1 && week <= 7) {
            return week;
        }
        throw new IllegalArgumentException("\u661f\u671f\u7684\u53d6\u503c\u8303\u56f4\u4e3a1-7");
    }

    protected int obtainDayOfMonth(String userInput) {
        if (userInput.endsWith("\u65e5")) {
            userInput = userInput.substring(0, userInput.length() - 1);
        } else if (userInput.startsWith("\u53f7")) {
            userInput = userInput.substring(0, userInput.length() - 1);
        }
        if (MONTH_MAP.containsKey(userInput)) {
            return MONTH_MAP.get(userInput);
        }
        int week = Integer.parseInt(userInput);
        if (week >= 1 && week <= 31) {
            return week;
        }
        throw new IllegalArgumentException("\u65e5\u53d6\u503c\u8303\u56f4\u4e3a1-31");
    }

    protected String convertPrettyExecType(SysWarningTimeEnum execTimeType, String execTypeValues, LocalTime execStartTime) {
        if (execTimeType == null) {
            return null;
        }
        switch (execTimeType) {
            case DAY: {
                return "\u6bcf\u65e5 " + DatetimeUtil.toStr((LocalTime)execStartTime);
            }
            case WEEK: {
                if (StrUtil.isBlank((CharSequence)execTypeValues)) {
                    return null;
                }
                CharSequence[] valuesWeek = (String[])Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : WEEK_MAP.entrySet()) {
                        if (!entry.getValue().toString().equals(t)) continue;
                        return entry.getKey();
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(String[]::new);
                if (valuesWeek.length == 0) {
                    return null;
                }
                if (valuesWeek.length == 1) {
                    return "\u6bcf\u5468" + valuesWeek[0] + DatetimeUtil.toStr((LocalTime)execStartTime);
                }
                return "\u6bcf\u5468(" + String.join((CharSequence)"\u3001", valuesWeek) + ")" + DatetimeUtil.toStr((LocalTime)execStartTime);
            }
            case MONTH: {
                if (StrUtil.isBlank((CharSequence)execTypeValues)) {
                    return null;
                }
                String[] valuesMonth = (String[])Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : MONTH_MAP.entrySet()) {
                        if (!entry.getValue().toString().equals(t)) continue;
                        return String.valueOf(entry.getValue()) + "\u65e5";
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(String[]::new);
                if (valuesMonth.length == 0) {
                    return null;
                }
                if (valuesMonth.length == 1) {
                    return "\u6bcf\u6708" + valuesMonth[0] + " " + DatetimeUtil.toStr((LocalTime)execStartTime);
                }
                return "\u6bcf\u6708(" + String.join((CharSequence)"\u3001", execTypeValues) + ") " + DatetimeUtil.toStr((LocalTime)execStartTime);
            }
            case CUSTOM: {
                if (StrUtil.isBlank((CharSequence)execTypeValues)) {
                    return null;
                }
                String[] valuesCustom = execTypeValues.split(",");
                if (valuesCustom.length == 2) {
                    return "\u81ea\u5b9a\u4e49(" + valuesCustom[0] + "\u81f3" + valuesCustom[1] + ") " + DatetimeUtil.toStr((LocalTime)execStartTime);
                }
                return null;
            }
        }
        return null;
    }

    protected List<String> convertExecType(SysWarningTimeEnum execTimeType, String execTypeValues) {
        if (execTimeType == null) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)execTypeValues)) {
            return Collections.emptyList();
        }
        switch (execTimeType) {
            case DAY: {
                return Collections.emptyList();
            }
            case WEEK: {
                return Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : WEEK_MAP.entrySet()) {
                        if (!entry.getValue().toString().equals(t)) continue;
                        return entry.getKey();
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
            }
            case MONTH: {
                if (StrUtil.isBlank((CharSequence)execTypeValues)) {
                    return null;
                }
                return Arrays.stream(execTypeValues.split(",")).map(t -> {
                    for (Map.Entry<String, Integer> entry : MONTH_MAP.entrySet()) {
                        if (!entry.getValue().toString().equals(t)) continue;
                        return String.valueOf(entry.getValue());
                    }
                    return null;
                }).filter(Objects::nonNull).toList();
            }
            case CUSTOM: {
                if (StrUtil.isBlank((CharSequence)execTypeValues)) {
                    return null;
                }
                return Arrays.stream(execTypeValues.split(",")).toList();
            }
        }
        return null;
    }

    static {
        WEEK_MAP.put("\u4e00", 1);
        WEEK_MAP.put("\u4e8c", 2);
        WEEK_MAP.put("\u4e09", 3);
        WEEK_MAP.put("\u56db", 4);
        WEEK_MAP.put("\u4e94", 5);
        WEEK_MAP.put("\u516d", 6);
        WEEK_MAP.put("\u65e5", 7);
        MONTH_MAP.put("\u4e00", 1);
        MONTH_MAP.put("\u4e8c", 2);
        MONTH_MAP.put("\u4e09", 3);
        MONTH_MAP.put("\u56db", 4);
        MONTH_MAP.put("\u4e94", 5);
        MONTH_MAP.put("\u516d", 6);
        MONTH_MAP.put("\u4e03", 7);
        MONTH_MAP.put("\u516b", 8);
        MONTH_MAP.put("\u4e5d", 9);
        MONTH_MAP.put("\u5341", 10);
        MONTH_MAP.put("\u5341\u4e00", 11);
        MONTH_MAP.put("\u5341\u4e8c", 12);
        MONTH_MAP.put("\u5341\u4e09", 13);
        MONTH_MAP.put("\u5341\u56db", 14);
        MONTH_MAP.put("\u5341\u4e94", 15);
        MONTH_MAP.put("\u5341\u516d", 16);
        MONTH_MAP.put("\u5341\u4e03", 17);
        MONTH_MAP.put("\u5341\u516b", 18);
        MONTH_MAP.put("\u5341\u4e5d", 19);
        MONTH_MAP.put("\u4e8c\u5341", 20);
        MONTH_MAP.put("\u4e8c\u5341\u4e00", 21);
        MONTH_MAP.put("\u4e8c\u5341\u4e8c", 22);
        MONTH_MAP.put("\u4e8c\u5341\u4e09", 23);
        MONTH_MAP.put("\u4e8c\u5341\u56db", 24);
        MONTH_MAP.put("\u4e8c\u5341\u4e94", 25);
        MONTH_MAP.put("\u4e8c\u5341\u516d", 26);
        MONTH_MAP.put("\u4e8c\u5341\u4e03", 27);
        MONTH_MAP.put("\u4e8c\u5341\u516b", 28);
        MONTH_MAP.put("\u4e8c\u5341\u4e5d", 29);
        MONTH_MAP.put("\u4e09\u5341", 30);
        MONTH_MAP.put("\u4e09\u5341\u4e00", 31);
    }
}

