/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.warning.service.impl;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.modules.warning.service.SysWarningRecordMngService;
import com.elitescloud.cloudt.system.modules.warning.service.impl.AbstractSysWarningService;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordDetailDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRecordNoticeDO;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningNoticeRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRecordDetailRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRecordRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRuleRepoProc;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordDetailPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRecordPageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRecordPageRespVO;
import com.elitescloud.cloudt.system.service.repo.TenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysWarningRecordMngServiceImpl
extends AbstractSysWarningService
implements SysWarningRecordMngService {
    @Autowired
    private SysWarningRecordRepoProc recordRepoProc;
    @Autowired
    private SysWarningRuleRepoProc ruleRepoProc;
    @Autowired
    private SysWarningRecordDetailRepoProc detailRepoProc;
    @Autowired
    private SysWarningNoticeRepoProc noticeRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private TenantUserRepoProc tenantUserRepoProc;
    @Autowired
    private UdcProvider udcProvider;

    @Override
    public ApiResult<PagingVO<SysWarningRecordPageRespVO>> pageQuery(SysWarningRecordPageQueryVO queryVO) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        Long tenantId = tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
        List userIds = StrUtil.isBlank((CharSequence)queryVO.getReceiver()) ? Collections.emptyList() : (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tenantUserRepoProc.queryUserIdByLastname(tenantId, queryVO.getReceiver(), true));
        PagingVO<SysWarningRecordDO> pageData = this.recordRepoProc.pageQuery(queryVO, userIds);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(t -> new SysWarningRecordPageRespVO()));
        }
        Set<String> ruleCodes = pageData.stream().map(SysWarningRecordDO::getRuleCode).collect(Collectors.toSet());
        Map ruleMap = this.ruleRepoProc.listIdCodeNames(ruleCodes).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Function.identity(), (t1, t2) -> t1));
        Map sceneMap = this.udcProvider.getValueMapByUdcCode("cloudt-system", "WARNING_SCENE");
        PagingVO pageResp = pageData.map(t -> {
            SysWarningRecordPageRespVO respVO = new SysWarningRecordPageRespVO();
            respVO.setId(t.getId());
            respVO.setExecTime(t.getExecTime());
            respVO.setFinishTime(t.getFinishTime());
            respVO.setRuleCode(t.getRuleCode());
            respVO.setRuleName(ruleMap.containsKey(t.getRuleCode()) ? ((IdCodeNameParam)ruleMap.get(t.getRuleCode())).getName() : null);
            respVO.setScene(t.getScene());
            respVO.setSceneName((String)sceneMap.get(t.getScene()));
            respVO.setNumTotal(t.getNumTotal());
            respVO.setNumSuccess(t.getNumSuccess());
            respVO.setNumFail(t.getNumFail());
            return respVO;
        });
        return ApiResult.ok((Object)pageResp);
    }

    @Override
    public ApiResult<PagingVO<SysWarningRecordDetailRespVO>> getDetail(SysWarningRecordDetailPageQueryVO queryVO) {
        PagingVO<SysWarningRecordDetailDO> pageData = this.detailRepoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(t -> new SysWarningRecordDetailRespVO()));
        }
        Set<Long> detailIds = pageData.stream().map(BaseModel::getId).collect(Collectors.toSet());
        Map<Long, List<SysWarningRecordNoticeDO>> noticesMap = this.noticeRepoProc.listByDetailId(detailIds);
        Set userIds = noticesMap.values().stream().flatMap(t -> t.stream().map(SysWarningRecordNoticeDO::getNoticeUserId)).collect(Collectors.toSet());
        Map userMap = userIds.isEmpty() ? Collections.emptyMap() : (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.queryUserName(userIds).stream().collect(Collectors.toMap(IdNameParam::getId, Function.identity(), (t1, t2) -> t1)));
        PagingVO pageResp = pageData.map(t -> {
            SysWarningRecordDetailRespVO respVO = new SysWarningRecordDetailRespVO();
            respVO.setId(t.getId());
            respVO.setDocCode(t.getDocCode());
            respVO.setDocName(t.getDocName());
            respVO.setSuccess(t.getVerifyPass());
            respVO.setFailReason(t.getFailReason());
            respVO.setNoticed(false);
            if (noticesMap.containsKey(t.getId())) {
                respVO.setReceivers(((List)noticesMap.get(t.getId())).stream().filter(tt -> {
                    if (Boolean.TRUE.equals(t.getVerifyPass())) {
                        return Boolean.TRUE.equals(tt.getNoticeSent());
                    }
                    return true;
                }).map(t1 -> ((IdNameParam)userMap.get(t1.getNoticeUserId())).getName()).collect(Collectors.joining(",")));
            }
            return respVO;
        });
        return ApiResult.ok((Object)pageResp);
    }

    @Override
    public ApiResult<Boolean> rePush(Long recordDetailId) {
        return ApiResult.ok((Object)true);
    }
}

