/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.warning.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.cron.CronBuilder;
import com.elitescloud.boot.util.cron.constant.CronWeek;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateRepoProc;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningNoticeRateEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningOprEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningRelEnum;
import com.elitescloud.cloudt.system.modules.warning.common.SysWarningTimeEnum;
import com.elitescloud.cloudt.system.modules.warning.provider.SysWarningJob;
import com.elitescloud.cloudt.system.modules.warning.service.SysWarningRuleMngService;
import com.elitescloud.cloudt.system.modules.warning.service.impl.AbstractSysWarningService;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningRuleDO;
import com.elitescloud.cloudt.system.modules.warning.service.model.entity.SysWarningSceneCondDO;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningRuleRepoProc;
import com.elitescloud.cloudt.system.modules.warning.service.repo.SysWarningScendCondRepoProc;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.query.SysWarningRulePageQueryVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRuleDetailRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.resp.SysWarningRulePageRespVO;
import com.elitescloud.cloudt.system.modules.warning.web.model.vo.save.SysWarningRuleSaveVO;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzJobEnum;
import com.elitescloud.cloudt.system.quartz.common.SysQuartzJobType;
import com.elitescloud.cloudt.system.quartz.model.bo.SysQuartzJobSaveParam;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.CronSysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.model.bo.schedule.SysQuartzTrigger;
import com.elitescloud.cloudt.system.quartz.service.SysQuartzMngService;
import com.elitescloud.cloudt.system.quartz.service.SysQuartzQueryService;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysWarningRuleMngServiceImpl
extends AbstractSysWarningService
implements SysWarningRuleMngService {
    private static final Logger logger = LoggerFactory.getLogger(SysWarningRuleMngServiceImpl.class);
    private static final String JOB_CODE_PREFIX = "warning::";
    @Autowired
    private SysWarningRuleRepoProc warningRuleRepoProc;
    @Autowired
    private SysWarningScendCondRepoProc warningScendCondRepoProc;
    @Autowired
    private SysMsgTemplateRepoProc msgTemplateRepoProc;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private SysQuartzMngService sysQuartzMngService;
    @Autowired
    private SysQuartzQueryService sysQuartzQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(SysWarningRuleSaveVO saveVO) {
        SysWarningRuleDO ruleDO = this.checkAndConvertRule(saveVO);
        this.warningRuleRepoProc.save((Serializable)((Object)ruleDO));
        List<SysWarningSceneCondDO> sceneCondDOList = this.checkAndConvertScene(ruleDO.getRuleCode(), saveVO.getSceneConditionList());
        this.warningScendCondRepoProc.deleteByRuleCode(ruleDO.getRuleCode());
        if (!sceneCondDOList.isEmpty()) {
            this.warningScendCondRepoProc.save(sceneCondDOList);
        }
        this.saveWarningJob(ruleDO.getId());
        return ApiResult.ok((Object)ruleDO.getId());
    }

    @Override
    public ApiResult<PagingVO<SysWarningRulePageRespVO>> pageMng(SysWarningRulePageQueryVO queryVO) {
        PagingVO<SysWarningRulePageRespVO> pageData = this.warningRuleRepoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData);
        }
        Map udcSceneMap = this.udcProvider.getValueMapByUdcCode("cloudt-system", "WARNING_SCENE");
        pageData.each(respVO -> {
            respVO.setSceneName((String)udcSceneMap.get(respVO.getScene()));
            SysWarningTimeEnum execTimeType = SysWarningTimeEnum.getByValue(respVO.getExecTimeType());
            respVO.setExecTimeTypeName(execTimeType == null ? null : execTimeType.getDescription());
            respVO.setExecTimePretty(this.convertPrettyExecType(execTimeType, respVO.getExecTimeValues(), respVO.getExecStartTime()));
            SysWarningNoticeRateEnum noticeRate = SysWarningNoticeRateEnum.getByValue(respVO.getNoticeRateValue());
            respVO.setNoticeRateValueName(noticeRate == null ? null : noticeRate.getDescription());
            if (StrUtil.isNotBlank((CharSequence)respVO.getSendTypes())) {
                respVO.setSendTypeList(Arrays.stream(respVO.getSendTypes().split(",")).toList());
                respVO.setSendTypeList(Arrays.stream(respVO.getSendTypes().split(",")).map(t -> {
                    MsgSendTypeEnum sendType = MsgSendTypeEnum.parse((String)t);
                    return sendType == null ? null : sendType.getDescription();
                }).toList());
            }
        });
        return ApiResult.ok(pageData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateEnabled(List<Long> ids, Boolean enabled) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(ids);
        }
        if ((ids = this.warningRuleRepoProc.exists(ids)).isEmpty()) {
            return ApiResult.ok((Object)ids);
        }
        if (enabled == null) {
            enabled = false;
        }
        this.warningRuleRepoProc.updateEnabled(ids, enabled);
        for (Long id : ids) {
            this.saveWarningJob(id);
        }
        return ApiResult.ok((Object)ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> delete(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(ids);
        }
        if ((ids = this.warningRuleRepoProc.exists(ids)).isEmpty()) {
            return ApiResult.ok((Object)ids);
        }
        this.warningScendCondRepoProc.deleteByRuleIds(ids);
        this.warningRuleRepoProc.delete(ids);
        for (Long id : ids) {
            this.deleteWarningJob(id);
        }
        return ApiResult.ok((Object)ids);
    }

    @Override
    public ApiResult<SysWarningRuleDetailRespVO> getDetail(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        SysWarningRuleDO ruleDO = (SysWarningRuleDO)((Object)this.warningRuleRepoProc.get(id));
        if (ruleDO == null) {
            return ApiResult.ok();
        }
        SysWarningRuleDetailRespVO respVO = new SysWarningRuleDetailRespVO();
        respVO.setId(ruleDO.getId());
        respVO.setRuleCode(ruleDO.getRuleCode());
        respVO.setRuleName(ruleDO.getRuleName());
        respVO.setEnabled(ruleDO.getEnabled());
        respVO.setDescription(ruleDO.getDescription());
        Map sceneMap = this.udcProvider.getValueMapByUdcCode("cloudt-system", "WARNING_SCENE");
        respVO.setScene(ruleDO.getScene());
        respVO.setSceneName((String)sceneMap.get(ruleDO.getScene()));
        respVO.setSceneConditionList(this.getSceneConditionList(id));
        respVO.setTimeCondition(this.getTimeConditionList(ruleDO));
        respVO.setNotice(this.getNoticeMsg(ruleDO));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<String>> getNextTriggerTime(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        String jobCode = JOB_CODE_PREFIX + id;
        return this.sysQuartzQueryService.getNextFiredTime(jobCode, Integer.valueOf(10));
    }

    private void deleteWarningJob(Long ruleId) {
        logger.info("\u89c4\u5219[{}]\u5df2\u5220\u9664\uff0c\u5220\u9664\u4efb\u52a1", (Object)ruleId);
        String jobCode = JOB_CODE_PREFIX + ruleId;
        ApiResult jobInfo = this.sysQuartzQueryService.getJob(jobCode);
        if (jobInfo == null) {
            return;
        }
        this.sysQuartzMngService.deleteJob(jobCode);
    }

    private void saveWarningJob(Long ruleId) {
        SysWarningRuleDO warningRuleDO = (SysWarningRuleDO)((Object)this.warningRuleRepoProc.get(ruleId));
        Assert.notNull((Object)((Object)warningRuleDO), (String)"\u89c4\u5219\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String jobCode = JOB_CODE_PREFIX + ruleId;
        if (Boolean.FALSE.equals(warningRuleDO.getEnabled())) {
            logger.info("\u89c4\u5219[{}]\u5df2\u7981\u7528\uff0c\u505c\u6b62\u4efb\u52a1", (Object)warningRuleDO.getRuleCode());
            ApiResult jobInfo = this.sysQuartzQueryService.getJob(jobCode);
            if (jobInfo == null) {
                return;
            }
            this.sysQuartzMngService.pauseJob(jobCode).computeData();
            return;
        }
        SysQuartzJobSaveParam jobSaveParam = new SysQuartzJobSaveParam();
        jobSaveParam.setJobCode(jobCode);
        jobSaveParam.setJobName(warningRuleDO.getRuleName());
        jobSaveParam.setJobType((SysQuartzJobType)SysQuartzJobEnum.BUSINESS_WARNING_RULE);
        jobSaveParam.setDescription("\u9884\u8b66\u4efb\u52a1\uff1a" + warningRuleDO.getRuleName() + "," + (String)ObjUtil.defaultIfNull((Object)warningRuleDO.getDescription(), (Object)""));
        jobSaveParam.setJobClass(SysWarningJob.class);
        HashMap<String, String> jobData = new HashMap<String, String>();
        jobData.put("ruleId", String.valueOf(ruleId));
        jobData.put("ruleCode", warningRuleDO.getRuleCode());
        jobSaveParam.setJobData(jobData);
        CronBuilder cronBuilder = CronBuilder.newBuilder().second().of(new Integer[]{warningRuleDO.getExecStartTime() == null ? 0 : warningRuleDO.getExecStartTime().getSecond()}).and().minute().of(new Integer[]{warningRuleDO.getExecStartTime() == null ? 0 : warningRuleDO.getExecStartTime().getMinute()}).and().hour().of(new Integer[]{warningRuleDO.getExecStartTime() == null ? 0 : warningRuleDO.getExecStartTime().getHour()}).and();
        SysWarningTimeEnum timeEnum = SysWarningTimeEnum.getByValue(warningRuleDO.getExecTimeType());
        Assert.notNull((Object)((Object)timeEnum), (String)"\u6267\u884c\u65f6\u95f4\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        String cron = null;
        Date start = new Date();
        Date end = null;
        switch (timeEnum) {
            case DAY: {
                cron = cronBuilder.build();
                break;
            }
            case MONTH: {
                List<Integer> days = Arrays.stream(warningRuleDO.getExecTimeValues().split(",")).map(this::obtainDayOfMonth).toList();
                cron = cronBuilder.day().of(days).and().build();
                break;
            }
            case WEEK: {
                List<CronWeek> weeks = Arrays.stream(warningRuleDO.getExecTimeValues().split(",")).map(t -> {
                    int week = this.obtainDayOfWeek((String)t) + 1;
                    if (week == 8) {
                        week = 1;
                    }
                    CronWeek cronWeek = CronWeek.getByValue((int)week);
                    Assert.notNull((Object)cronWeek, (String)("\u83b7\u53d6\u5468\u5931\u8d25\uff1a" + t), (Object[])new Object[0]);
                    return cronWeek;
                }).toList();
                cron = cronBuilder.week().of(weeks).and().build();
                break;
            }
            case CUSTOM: {
                cron = cronBuilder.build();
                List<Date> customDates = Arrays.stream(warningRuleDO.getExecTimeValues().split(",")).filter(CharSequenceUtil::isNotBlank).map(DatetimeUtil::parseForDate).toList();
                if (!customDates.isEmpty()) {
                    start = customDates.get(0);
                }
                if (customDates.size() <= 1) break;
                end = customDates.get(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6267\u884c\u65f6\u95f4\u7c7b\u578b\u9519\u8bef");
            }
        }
        jobSaveParam.setTrigger((SysQuartzTrigger)new CronSysQuartzTrigger(cron));
        jobSaveParam.setStartTime(start);
        jobSaveParam.setEndTime(end);
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        jobSaveParam.setTenantId(tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId());
        this.sysQuartzMngService.saveJob(jobSaveParam).computeData();
    }

    private SysWarningRuleDetailRespVO.NoticeMsg getNoticeMsg(SysWarningRuleDO ruleDO) {
        List userIds;
        List<String> roleCodes;
        SysWarningRuleDetailRespVO.NoticeMsg noticeMsg = new SysWarningRuleDetailRespVO.NoticeMsg();
        noticeMsg.setTmplName(StrUtil.isBlank((CharSequence)ruleDO.getNoticeTmplCode()) ? null : this.msgTemplateRepoProc.getNameByTemplateCode(ruleDO.getNoticeTmplCode()));
        if (noticeMsg.getTmplName() != null) {
            noticeMsg.setTmplCode(ruleDO.getNoticeTmplCode());
        }
        if (StrUtil.isBlank((CharSequence)ruleDO.getSendTypes())) {
            noticeMsg.setSendTypeList(Collections.emptyList());
            noticeMsg.setSendTypeNameList(Collections.emptyList());
        } else {
            noticeMsg.setSendTypeList(Arrays.stream(ruleDO.getSendTypes().split(",")).map(MsgSendTypeEnum::parse).filter(Objects::nonNull).toList());
            noticeMsg.setSendTypeNameList(noticeMsg.getSendTypeList().stream().map(MsgSendTypeEnum::getDescription).toList());
        }
        noticeMsg.setEnabledRecvByRole(ruleDO.getEnabledRecvByRole());
        List<String> list = roleCodes = StrUtil.isBlank((CharSequence)ruleDO.getRecvRoleCodes()) ? Collections.emptyList() : Arrays.stream(ruleDO.getRecvRoleCodes().split(",")).toList();
        if (roleCodes.isEmpty()) {
            noticeMsg.setRecvRoleCodes(Collections.emptyList());
            noticeMsg.setRecvRoleNames(Collections.emptyList());
        } else {
            List<IdCodeNameParam> roles = this.roleRepoProc.queryIdCodeNamesByCode(roleCodes);
            noticeMsg.setRecvRoleCodes(roles.stream().map(IdCodeNameParam::getCode).toList());
            noticeMsg.setRecvRoleNames(roles.stream().map(IdCodeNameParam::getName).toList());
        }
        noticeMsg.setOnlyPushWarningObj(ruleDO.getOnlyPushWarningObj());
        noticeMsg.setEnabledRecvByUser(ruleDO.getEnabledRecvByUser());
        List<Object> list2 = userIds = StrUtil.isBlank((CharSequence)ruleDO.getRecvUserIds()) ? Collections.emptyList() : Arrays.stream(ruleDO.getRecvUserIds().split(",")).map(Long::parseLong).toList();
        if (userIds.isEmpty()) {
            noticeMsg.setRecvUserIds(Collections.emptyList());
            noticeMsg.setRecvUserNames(Collections.emptyList());
        } else {
            List users = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.queryUserName(userIds));
            noticeMsg.setRecvUserIds(users.stream().map(IdNameParam::getId).toList());
            noticeMsg.setRecvUserNames(users.stream().map(IdNameParam::getName).toList());
        }
        return noticeMsg;
    }

    private SysWarningRuleDetailRespVO.ExecTime getTimeConditionList(SysWarningRuleDO ruleDO) {
        SysWarningRuleDetailRespVO.ExecTime execTime = new SysWarningRuleDetailRespVO.ExecTime();
        SysWarningTimeEnum timeType = SysWarningTimeEnum.getByValue(ruleDO.getExecTimeType());
        execTime.setTimeType(timeType);
        execTime.setTimeTypeName(timeType == null ? null : timeType.getDescription());
        execTime.setValueList(this.convertExecType(timeType, ruleDO.getExecTimeValues()));
        execTime.setStartTime(ruleDO.getExecStartTime());
        execTime.setExcludedWorkday(ruleDO.getExcludedWorkday());
        execTime.setWorkdayStartTime(ruleDO.getWorkdayStartTime());
        execTime.setWorkdayEndTime(ruleDO.getWorkdayEndTime());
        execTime.setExcludedHolidays(ruleDO.getExcludedHolidays());
        SysWarningNoticeRateEnum noticeRate = SysWarningNoticeRateEnum.getByValue(ruleDO.getNoticeRateValue());
        execTime.setNoticeRate(noticeRate);
        execTime.setNoticeRateName(noticeRate == null ? null : noticeRate.getDescription());
        execTime.setNoticeRateValue(ruleDO.getCustomNoticeRate());
        return execTime;
    }

    private List<SysWarningRuleDetailRespVO.SceneCondition> getSceneConditionList(Long ruleId) {
        List<SysWarningSceneCondDO> sceneCondList = this.warningScendCondRepoProc.listByRuleId(ruleId);
        if (sceneCondList.isEmpty()) {
            return Collections.emptyList();
        }
        Map termMap = this.udcProvider.getValueMapByUdcCode("cloudt-system", "WARNING_CONDITION");
        return sceneCondList.stream().map(t -> {
            SysWarningRuleDetailRespVO.SceneCondition cond = new SysWarningRuleDetailRespVO.SceneCondition();
            cond.setCondTerm(t.getCondTerm());
            cond.setCondTermName((String)termMap.get(t.getCondTerm()));
            SysWarningOprEnum opr = SysWarningOprEnum.getByValue(t.getOprValue());
            cond.setOpr(opr);
            cond.setOprName(opr == null ? null : opr.getDescription());
            cond.setValueList((List)JSONUtil.json2Obj((String)t.getValueListJson(), (TypeReference)new TypeReference<List<String>>(){}));
            SysWarningRelEnum rel = SysWarningRelEnum.getByValue(t.getRelValue());
            cond.setRel(rel);
            cond.setRelName(rel == null ? null : rel.getDescription());
            return cond;
        }).toList();
    }

    private List<SysWarningSceneCondDO> checkAndConvertScene(String ruleCode, List<SysWarningRuleSaveVO.SceneCondition> sceneConditionList) {
        if (CollUtil.isEmpty(sceneConditionList)) {
            return Collections.emptyList();
        }
        AtomicInteger seqNum = new AtomicInteger(0);
        return sceneConditionList.stream().map(t -> {
            SysWarningSceneCondDO sceneCondDO = new SysWarningSceneCondDO();
            sceneCondDO.setRuleCode(ruleCode);
            sceneCondDO.setCondTerm(t.getCondTerm());
            Assert.notNull((Object)((Object)t.getOpr()), (String)"\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            sceneCondDO.setOprValue(t.getOpr().name());
            Assert.notNull(t.getValueList(), (String)"\u6570\u636e\u8303\u56f4\u4e3a\u7a7a", (Object[])new Object[0]);
            sceneCondDO.setValueListJson(JSONUtil.toJsonString(t.getValueList()));
            sceneCondDO.setRelValue(t.getRel() == null ? null : t.getRel().name());
            sceneCondDO.setSortNo(seqNum.incrementAndGet());
            return sceneCondDO;
        }).collect(Collectors.toList());
    }

    private SysWarningRuleDO checkAndConvertRule(SysWarningRuleSaveVO saveVO) {
        boolean isNew;
        SysWarningRuleDO ruleDO = saveVO.getId() == null ? new SysWarningRuleDO() : (SysWarningRuleDO)((Object)this.warningRuleRepoProc.get(saveVO.getId()));
        boolean bl = isNew = saveVO.getId() == null;
        if (isNew) {
            if (CharSequenceUtil.isBlank((CharSequence)saveVO.getRuleCode())) {
                String ruleCode = this.seqNumProvider.generateCode("cloudt-system", "sys_warning_rule_code", null);
                Assert.notBlank((CharSequence)ruleCode, (String)"", (Object[])new Object[0]);
                ruleDO.setRuleCode(ruleCode);
            } else {
                ruleDO.setRuleCode(saveVO.getRuleCode());
            }
            Assert.isFalse((boolean)this.warningRuleRepoProc.existsRuleCode(saveVO.getRuleCode()), (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        } else {
            Assert.notNull((Object)((Object)ruleDO), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        ruleDO.setRuleName(saveVO.getRuleName());
        ruleDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)false));
        ruleDO.setDescription(saveVO.getDescription());
        ruleDO.setScene(saveVO.getScene());
        this.checkAndConvertExecTimeCond(ruleDO, saveVO.getTimeCondition());
        this.checkAndConvertExecNotice(ruleDO, saveVO.getNotice());
        return ruleDO;
    }

    private void checkAndConvertExecTimeCond(SysWarningRuleDO ruleDO, SysWarningRuleSaveVO.ExecTime execTimeCond) {
        Assert.notNull((Object)execTimeCond, (String)"\u6267\u884c\u6761\u4ef6\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        SysWarningTimeEnum timeType = execTimeCond.getTimeType();
        Assert.notNull((Object)((Object)timeType), (String)"\u6267\u884c\u6761\u4ef6\u7684\u65f6\u95f4\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        ruleDO.setExecTimeType(timeType.name());
        if (SysWarningTimeEnum.DAY != timeType) {
            if (SysWarningTimeEnum.WEEK == timeType) {
                Assert.notEmpty(execTimeCond.getValueList(), (String)"\u6267\u884c\u65f6\u95f4\u7684\u6bcf\u5468\u7684\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
                String values = execTimeCond.getValueList().stream().map(t -> "" + super.obtainDayOfWeek((String)t)).collect(Collectors.joining(","));
                ruleDO.setExecTimeValues(values);
            } else if (SysWarningTimeEnum.MONTH == timeType) {
                Assert.notEmpty(execTimeCond.getValueList(), (String)"\u6267\u884c\u65f6\u95f4\u7684\u6bcf\u6708\u7684\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
                String values = execTimeCond.getValueList().stream().map(t -> "" + super.obtainDayOfMonth((String)t)).collect(Collectors.joining(","));
                ruleDO.setExecTimeValues(values);
            } else if (SysWarningTimeEnum.CUSTOM == timeType) {
                Assert.notEmpty(execTimeCond.getValueList(), (String)"\u6267\u884c\u65f6\u95f4\u7684\u81ea\u5b9a\u4e49\u7684\u65f6\u95f4\u533a\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
                String values = execTimeCond.getValueList().stream().limit(2L).peek(t -> {
                    try {
                        DatetimeUtil.parseLocalDate((String)t);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u4e3ayyyy-MM-dd");
                    }
                }).collect(Collectors.joining(","));
                ruleDO.setExecTimeValues(values);
            } else {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u7c7b\u578b");
            }
        }
        Assert.notNull((Object)execTimeCond.getStartTime(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
        ruleDO.setExecStartTime(execTimeCond.getStartTime());
        ruleDO.setExcludedWorkday((Boolean)ObjectUtil.defaultIfNull((Object)execTimeCond.getExcludedWorkday(), (Object)false));
        if (ruleDO.getExcludedWorkday().booleanValue()) {
            Assert.notNull((Object)execTimeCond.getWorkdayStartTime(), (String)"\u5de5\u4f5c\u65e5\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notNull((Object)execTimeCond.getWorkdayEndTime(), (String)"\u5de5\u4f5c\u65e5\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            ruleDO.setWorkdayStartTime(execTimeCond.getWorkdayStartTime());
            ruleDO.setWorkdayEndTime(execTimeCond.getWorkdayEndTime());
        }
        ruleDO.setExcludedHolidays((Boolean)ObjectUtil.defaultIfNull((Object)execTimeCond.getExcludedHolidays(), (Object)false));
        Assert.notNull((Object)((Object)execTimeCond.getNoticeRate()), (String)"\u901a\u77e5\u9891\u7387\u4e3a\u7a7a", (Object[])new Object[0]);
        ruleDO.setNoticeRateValue(execTimeCond.getNoticeRate().name());
        ruleDO.setCustomNoticeRate(execTimeCond.getNoticeRateValue());
    }

    private void checkAndConvertExecNotice(SysWarningRuleDO ruleDO, SysWarningRuleSaveVO.NoticeMsg noticeMsg) {
        Assert.notNull((Object)noticeMsg, (String)"\u6d88\u606f\u901a\u77e5\u4e3a\u7a7a", (Object[])new Object[0]);
        ruleDO.setNoticeTmplCode(noticeMsg.getTmplCode());
        Assert.notEmpty(noticeMsg.getSendTypeList(), (String)"\u63a8\u9001\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
        String sendTypes = noticeMsg.getSendTypeList().stream().map(Enum::name).collect(Collectors.joining(","));
        ruleDO.setSendTypes(sendTypes);
        ruleDO.setEnabledRecvByRole((Boolean)ObjectUtil.defaultIfNull((Object)noticeMsg.getEnabledRecvByRole(), (Object)false));
        if (ruleDO.getEnabledRecvByRole().booleanValue()) {
            Assert.notEmpty(noticeMsg.getRecvRoleCodes(), (String)"\u63a8\u9001\u5bf9\u8c61\u89d2\u8272\u4e3a\u7a7a", (Object[])new Object[0]);
            ruleDO.setRecvRoleCodes(noticeMsg.getRecvRoleCodes().stream().distinct().collect(Collectors.joining(",")));
        }
        ruleDO.setOnlyPushWarningObj((Boolean)ObjectUtil.defaultIfNull((Object)noticeMsg.getOnlyPushWarningObj(), (Object)false));
        ruleDO.setEnabledRecvByUser((Boolean)ObjectUtil.defaultIfNull((Object)noticeMsg.getEnabledRecvByUser(), (Object)false));
        if (ruleDO.getEnabledRecvByUser().booleanValue()) {
            Assert.notNull(noticeMsg.getRecvUserIds(), (String)"\u63a8\u9001\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            ruleDO.setRecvUserIds(noticeMsg.getRecvUserIds().stream().distinct().map(Object::toString).collect(Collectors.joining(",")));
        }
    }
}

