/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.wecom.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.modules.wecom.common.WecomUserConverter;
import com.elitescloud.cloudt.system.modules.wecom.model.AccessToken;
import com.elitescloud.cloudt.system.modules.wecom.model.login.Code2UserInfoResult;
import com.elitescloud.cloudt.system.modules.wecom.model.login.WecomLoginPropsVO;
import com.elitescloud.cloudt.system.modules.wecom.service.WecomAuthService;
import com.elitescloud.cloudt.system.modules.wecom.util.WeComTool;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class WecomAuthServiceImpl
implements WecomAuthService {
    private static final Logger logger = LoggerFactory.getLogger(WecomAuthServiceImpl.class);
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private WecomUserConverter wecomUserConverter;
    @Autowired
    private InternalAuthenticationGranter internalAuthenticationGranter;

    @Override
    public ApiResult<WecomLoginPropsVO> getLoginProps() {
        SystemProperties.WecomAuth authProps = this.systemProperties.getWecomAuth();
        if (CharSequenceUtil.isBlank((CharSequence)authProps.getAppId()) || CharSequenceUtil.isBlank((CharSequence)authProps.getAgentId())) {
            return ApiResult.fail((String)"\u4f01\u4e1a\u5fae\u4fe1\u672a\u914d\u7f6e");
        }
        WecomLoginPropsVO props = new WecomLoginPropsVO();
        props.setAppId(authProps.getAppId());
        props.setAgentId(authProps.getAgentId());
        props.setLoginType(authProps.getLoginType());
        return ApiResult.ok((Object)props);
    }

    @Override
    public ApiResult<String> getAuthorizeUrl(String redirectUri, String state) {
        Assert.notBlank((CharSequence)redirectUri, (String)"\u91cd\u5b9a\u5411\u5730\u5740\u4e3a\u7a7a", (Object[])new Object[0]);
        SystemProperties.WecomAuth authProps = this.systemProperties.getWecomAuth();
        if (CharSequenceUtil.isBlank((CharSequence)authProps.getAppId()) || CharSequenceUtil.isBlank((CharSequence)authProps.getAgentId())) {
            return ApiResult.fail((String)"\u4f01\u4e1a\u5fae\u4fe1\u672a\u914d\u7f6e");
        }
        String uri = UriComponentsBuilder.fromHttpUrl((String)authProps.getAuthUrl()).queryParam("login_type", new Object[]{authProps.getLoginType()}).queryParam("appid", new Object[]{authProps.getAppId()}).queryParam("agentid", new Object[]{authProps.getAgentId()}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParamIfPresent("state", Optional.ofNullable(CharSequenceUtil.blankToDefault((CharSequence)state, null))).toUriString();
        logger.info("\u8ba4\u8bc1\u5730\u5740\uff1a{}", (Object)uri);
        return ApiResult.ok((Object)uri);
    }

    @Override
    public ApiResult<OAuthToken> code2Token(HttpServletRequest request, HttpServletResponse response, String code) {
        Assert.notBlank((CharSequence)code, (String)"\u6388\u6743\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        logger.info("\u6388\u6743\u7801\u6362\u53d6token\uff1a{}", (Object)code);
        SystemProperties.WecomAuth authProps = this.systemProperties.getWecomAuth();
        String accessToken = WecomAuthServiceImpl.getAccessTokenOfWecom(authProps.getAppId(), authProps.getAgentSecret());
        Code2UserInfoResult userInfoResult = WeComTool.code2UserInfo(accessToken, code);
        if (!userInfoResult.isSuccess()) {
            logger.error("\u6388\u6743\u7801\u6362\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)JSONUtil.toJsonString((Object)userInfoResult));
            return ApiResult.fail((String)("\u4f01\u5fae\u8ba4\u8bc1\u5931\u8d25\uff1a" + userInfoResult.getErrcode() + ", " + userInfoResult.getErrmsg()));
        }
        logger.info("\u6388\u6743\u7801\u6362\u53d6\u7528\u6237\u4fe1\u606f\uff1a{}, {}", (Object)userInfoResult.getUserid(), (Object)userInfoResult.getExternal_userid());
        InternalAuthenticationGranter.InternalAuthenticationToken authentication = null;
        try {
            authentication = this.wecomUserConverter.convert(userInfoResult.getUserid(), userInfoResult.getUser_ticket(), accessToken);
        }
        catch (Exception e) {
            String msg = e instanceof BusinessException ? ", " + e.getMessage() : "";
            throw new BusinessException("\u8ba4\u8bc1\u5931\u8d25" + msg, (Throwable)e);
        }
        OAuthToken token = null;
        try {
            token = this.internalAuthenticationGranter.authenticate(request, response, authentication);
        }
        catch (AuthenticationException e) {
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5f02\u5e38\uff0c" + e.getMessage()));
        }
        return ApiResult.ok((Object)token);
    }

    private static String getAccessTokenOfWecom(String corpId, String corpSecret) {
        String tokenKey;
        RedisUtils redisUtils = (RedisUtils)SpringContextHolder.getBean(RedisUtils.class);
        String token = (String)redisUtils.get(tokenKey = "wecom:accessToken:" + corpId + ":" + corpSecret);
        if (StringUtils.hasText((String)token)) {
            return token;
        }
        AccessToken accessToken = WeComTool.getToken(corpId, corpSecret);
        if (accessToken.isSuccess()) {
            token = accessToken.getAccess_token();
            redisUtils.set(tokenKey, (Object)token, (long)(accessToken.getExpires_in() - 60), TimeUnit.SECONDS);
            return token;
        }
        throw new BusinessException("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743\u5931\u8d25," + String.valueOf(ObjUtil.defaultIfNull((Object)accessToken.getErrcode(), (Object)-1)) + (String)ObjUtil.defaultIfNull((Object)accessToken.getErrmsg(), (Object)""));
    }
}

