/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.wecom.util;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.boot.util.RestTemplateHelper;
import com.elitescloud.cloudt.system.modules.wecom.model.AccessToken;
import com.elitescloud.cloudt.system.modules.wecom.model.CommonResult;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentDeleteResult;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentIdListResult;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentSaveParam;
import com.elitescloud.cloudt.system.modules.wecom.model.department.DepartmentSaveResult;
import com.elitescloud.cloudt.system.modules.wecom.model.login.Code2UserInfoResult;
import com.elitescloud.cloudt.system.modules.wecom.model.login.Ticket2UserDetailResult;
import com.elitescloud.cloudt.system.modules.wecom.model.msg.MsgResult;
import com.elitescloud.cloudt.system.modules.wecom.model.user.OpenId2UserIdResult;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserCreateResultParam;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserDeleteBatchParam;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserId2OpenIdResult;
import com.elitescloud.cloudt.system.modules.wecom.model.user.UserSaveParam;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class WeComTool {
    private static final Logger logger = LoggerFactory.getLogger(WeComTool.class);
    private static final RestTemplateHelper restTemplateHelper = RestTemplateHelper.instance((RestTemplate)RestTemplateFactory.instance());

    public static AccessToken getToken(@NotBlank String corpid, @NotBlank String corpsecret) {
        Assert.notBlank((CharSequence)corpid, (String)"\u4f01\u4e1aID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)corpsecret, (String)"\u5e94\u7528\u7684\u51ed\u8bc1\u79d8\u94a5\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u521b\u5efatoken\uff1a{}, {}", (Object)corpid, (Object)corpsecret);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=" + corpid + "&corpsecret=" + corpsecret;
        return (AccessToken)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<AccessToken>(){}, new Object[0]);
    }

    public static DepartmentSaveResult departmentCreate(@NotBlank String accessToken, @NotNull DepartmentSaveParam saveParam) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)saveParam, (String)"\u90e8\u95e8\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getName(), (String)"\u90e8\u95e8\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveParam.getParentid() == null) {
            saveParam.setParentid(1L);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u521b\u5efa\u90e8\u95e8\uff1a{}", (Object)JSONUtil.toJsonString((Object)saveParam));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=" + accessToken;
        return (DepartmentSaveResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity((Object)saveParam), (TypeReference)new TypeReference<DepartmentSaveResult>(){}, new Object[0]);
    }

    public static DepartmentSaveResult departmentUpdate(@NotBlank String accessToken, @NotNull DepartmentSaveParam saveParam) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)saveParam, (String)"\u90e8\u95e8\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getName(), (String)"\u90e8\u95e8\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveParam.getParentid() == null) {
            saveParam.setParentid(1L);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u90e8\u95e8\uff1a{}", (Object)JSONUtil.toJsonString((Object)saveParam));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=" + accessToken;
        return (DepartmentSaveResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity((Object)saveParam), (TypeReference)new TypeReference<DepartmentSaveResult>(){}, new Object[0]);
    }

    public static DepartmentDeleteResult departmentDelete(@NotBlank String accessToken, @NotNull Long id) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)id, (String)"\u90e8\u95e8ID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u90e8\u95e8\uff1a{}", (Object)id);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=" + accessToken + "&id=" + id;
        return (DepartmentDeleteResult)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<DepartmentDeleteResult>(){}, new Object[0]);
    }

    public static DepartmentIdListResult departmentIdList(@NotBlank String accessToken, Long id) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u5b50\u90e8\u95e8ID\u5217\u8868\uff1a{}", (Object)id);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/simplelist?access_token=" + accessToken;
        if (id != null) {
            url = url + "&id=" + id;
        }
        return (DepartmentIdListResult)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<DepartmentIdListResult>(){}, new Object[0]);
    }

    public static UserCreateResultParam userCreate(@NotBlank String accessToken, @NotNull UserSaveParam saveParam) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)saveParam, (String)"\u6210\u5458\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getUserid(), (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getName(), (String)"\u6210\u5458\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u521b\u5efa\u6210\u5458\uff1a{}", (Object)JSONUtil.toJsonString((Object)saveParam));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=" + accessToken;
        return (UserCreateResultParam)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity((Object)saveParam), (TypeReference)new TypeReference<UserCreateResultParam>(){}, new Object[0]);
    }

    public static CommonResult userUpdate(@NotBlank String accessToken, @NotNull UserSaveParam saveParam) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)saveParam, (String)"\u6210\u5458\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getUserid(), (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)saveParam.getName(), (String)"\u6210\u5458\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u66f4\u65b0\u6210\u5458\uff1a{}", (Object)JSONUtil.toJsonString((Object)saveParam));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=" + accessToken;
        return (CommonResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity((Object)saveParam), (TypeReference)new TypeReference<CommonResult>(){}, new Object[0]);
    }

    public static CommonResult userDelete(@NotBlank String accessToken, @NotBlank String userId) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)userId, (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u6210\u5458\uff1a{}", (Object)userId);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=" + accessToken + "&userid=" + userId;
        return (CommonResult)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<CommonResult>(){}, new Object[0]);
    }

    public static CommonResult userDeleteBatch(@NotBlank String accessToken, @NotNull UserDeleteBatchParam param) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(param == null ? null : param.getUseridlist(), (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u5220\u9664\u6210\u5458\uff1a{}", (Object)JSONUtil.toJsonString((Object)param));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=" + accessToken;
        return (CommonResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity((Object)param), (TypeReference)new TypeReference<CommonResult>(){}, new Object[0]);
    }

    public static UserId2OpenIdResult userId2OpenId(@NotBlank String accessToken, @NotBlank String userId) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)userId, (String)"\u6210\u5458ID\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("userid\u8f6copenid\uff1a{}", (Object)userId);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=" + accessToken;
        return (UserId2OpenIdResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("userid", userId)), (TypeReference)new TypeReference<UserId2OpenIdResult>(){}, new Object[0]);
    }

    public static OpenId2UserIdResult openId2UserId(@NotBlank String accessToken, @NotBlank String openId) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)openId, (String)"OpenId\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("openid\u8f6cuserid\uff1a{}", (Object)openId);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=" + accessToken;
        return (OpenId2UserIdResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("openid", openId)), (TypeReference)new TypeReference<OpenId2UserIdResult>(){}, new Object[0]);
    }

    public static Code2UserInfoResult code2UserInfo(@NotBlank String accessToken, @NotBlank String code) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)code, (String)"\u6388\u6743\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("code\u8f6c\u7528\u6237\u8eab\u4efd\uff1a{}", (Object)code);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=" + accessToken + "&code=" + code;
        return (Code2UserInfoResult)restTemplateHelper.exchangeSafely(url, HttpMethod.GET, null, (TypeReference)new TypeReference<Code2UserInfoResult>(){}, new Object[0]);
    }

    public static Ticket2UserDetailResult ticket2UserDetail(@NotBlank String accessToken, @NotBlank String ticket) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)ticket, (String)"\u7968\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("ticket\u8f6c\u7528\u6237\u8eab\u4efd\uff1a{}", (Object)ticket);
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=" + accessToken;
        return (Ticket2UserDetailResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(Map.of("user_ticket", ticket)), (TypeReference)new TypeReference<Ticket2UserDetailResult>(){}, new Object[0]);
    }

    public static MsgResult sendMessage(@NotBlank String accessToken, @NotNull Object msg) {
        Assert.notBlank((CharSequence)accessToken, (String)"AccessToken\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)msg, (String)"\u6d88\u606f\u4f53\u4e3a\u7a7a", (Object[])new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u9001\u5e94\u7528\u6d88\u606f\uff1a{}", (Object)JSONUtil.toJsonString((Object)msg));
        }
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + accessToken;
        return (MsgResult)restTemplateHelper.exchangeSafely(url, HttpMethod.POST, new HttpEntity(msg), (TypeReference)new TypeReference<MsgResult>(){}, new Object[0]);
    }
}

