/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.export;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.provider.export.param.ExportEmployeeBO;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EmployeeExportProvider
implements DataExport<ExportEmployeeBO, EmployeePageQueryVO> {
    private static final Logger log = LoggerFactory.getLogger(EmployeeExportProvider.class);
    private final EmployeeMngService service;

    public EmployeeExportProvider(EmployeeMngService service) {
        this.service = service;
    }

    public String getTmplCode() {
        return "system_employee_export";
    }

    @BusinessObjectOperation(businessObjectType="Sys_Employee:\u5458\u5de5", operationType=OperationTypeEnum.EXPORT, operationDescription="\u5458\u5de5\u5bfc\u51fa", dataPermissionEnabled=true, permissionRef="sys_emp_mng_page", fieldPermissionAutoFilter=true, detail="\u57fa\u4e8e\u6a21\u677f\u7684\u5458\u5de5\u5bfc\u51fa\u529f\u80fd")
    public PagingVO<ExportEmployeeBO> executeExport(EmployeePageQueryVO queryParam) {
        PagingVO pageData = ((PagingVO)this.service.page(queryParam).getData()).map(EmployeeConvert.INSTANCE::pageRespVo2ExportBO);
        if (pageData.isEmpty()) {
            return pageData;
        }
        List<Long> empIds = pageData.stream().map(EmployeePagedRespVO::getId).collect(Collectors.toList());
        List<Long> userIds = pageData.stream().filter(t -> Boolean.FALSE.equals(t.getWithoutLoginAccount())).map(EmployeePagedRespVO::getUserId).collect(Collectors.toList());
        Map empOrgMap = (Map)this.service.getEmployeeOrgs(empIds).getData();
        Map empRoleMap = (Map)this.service.getEmployeeRolesByUserIds(userIds).getData();
        pageData.each(t -> {
            if (t.getJoinTime() != null) {
                t.setJoinTimeStr(DatetimeUtil.FORMATTER_DATETIME.format(t.getJoinTime()));
            }
            t.setEnabledName(Boolean.FALSE.equals(t.getEnabled()) ? "\u5426" : "\u662f");
            if (empOrgMap != null) {
                t.setOrgNames(empOrgMap.getOrDefault(t.getId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.joining(",")));
                t.setOrgCodes(empOrgMap.getOrDefault(t.getId(), Collections.emptyList()).stream().map(IdCodeNameParam::getCode).collect(Collectors.joining(",")));
            }
            if (empRoleMap != null) {
                t.setRoleNames(empRoleMap.getOrDefault(t.getUserId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.joining(",")));
                t.setRoleCodes(empRoleMap.getOrDefault(t.getUserId(), Collections.emptyList()).stream().map(IdCodeNameParam::getCode).collect(Collectors.joining(",")));
            }
            t.setWithoutLoginAccountName(Boolean.TRUE.equals(t.getWithoutLoginAccount()) ? "\u662f" : "\u5426");
        });
        return pageData;
    }

    public Integer pageSize() {
        return 10;
    }
}

