/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.imports;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.base.SafeEnum;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.imports.param.ImportEmployeeBO;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
public class EmployeeImportProvider
implements DataImport<ImportEmployeeBO> {
    private static final Logger log = LogManager.getLogger(EmployeeImportProvider.class);
    private UdcProvider udcProvider;
    private EmployeeMngService mngService;
    private OrgQueryService orgQueryService;
    private RoleQueryService roleQueryService;

    public String getTmplCode() {
        return "system_employee_import";
    }

    public List<String> executeImport(List<ImportEmployeeBO> dataList, int startRowIndex) {
        Map<String, Map<String, String>> udcNameValueMap = this.udcProvider.listByUdcCode(Set.of(new EmployeeType().getUdcCode())).stream().collect(Collectors.toMap(SysUdcDTO::getUdcCode, t -> t.getValueList().stream().collect(Collectors.toMap(SysUdcDTO.UdcValue::getUdcValueName, SysUdcDTO.UdcValue::getUdcValueCode, (t1, t2) -> t1)), (t1, t2) -> t1));
        HashMap<String, Long> orgCodeIdMap = new HashMap<String, Long>(32);
        HashMap<String, Long> roleCodeIdMap = new HashMap<String, Long>(32);
        Map<String, String> genderMap = Gender.all().stream().collect(Collectors.toMap(SafeEnum::getDescription, SafeEnum::getValue, (t1, t2) -> t1));
        ArrayList<String> failMsg = new ArrayList<String>();
        for (ImportEmployeeBO employeeBO : dataList) {
            String errMsg = null;
            try {
                errMsg = this.saveEmployee(employeeBO, udcNameValueMap, orgCodeIdMap, roleCodeIdMap, genderMap);
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u5458\u5de5\u5f02\u5e38\uff1a", (Throwable)e);
                errMsg = e.getMessage();
            }
            failMsg.add(errMsg);
        }
        return failMsg;
    }

    public Integer stepSize() {
        return 10;
    }

    private String saveEmployee(ImportEmployeeBO employeeBO, Map<String, Map<String, String>> udcMap, Map<String, Long> orgCodeIdMap, Map<String, Long> roleCodeIdMap, Map<String, String> genderMap) {
        Assert.hasText((String)employeeBO.getCode(), (String)"\u5458\u5de5\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)employeeBO.getUsername(), (String)"\u767b\u5f55\u53f7\u4e3a\u7a7a");
        Assert.hasText((String)employeeBO.getFullName(), (String)"\u59d3\u540d\u4e3a\u7a7a");
        if (StringUtils.hasText((String)employeeBO.getGenderName())) {
            employeeBO.setGender(genderMap.get(employeeBO.getGenderName()));
        }
        if (StringUtils.hasText((String)employeeBO.getTypeName())) {
            Map typeMap = udcMap.computeIfAbsent(new EmployeeType().getUdcCode(), udcCode -> {
                SysUdcDTO udc = this.udcProvider.getByUdcCode(udcCode);
                if (udc == null || CollUtil.isEmpty((Collection)udc.getValueList())) {
                    return Collections.emptyMap();
                }
                return udc.getValueList().stream().collect(Collectors.toMap(SysUdcDTO.UdcValue::getUdcValueName, SysUdcDTO.UdcValue::getUdcValueCode, (t1, t2) -> t1));
            });
            employeeBO.setType((String)typeMap.get(employeeBO.getTypeName()));
        }
        employeeBO.setEnabled("\u662f".equals(employeeBO.getEnabledName()));
        if (StringUtils.hasText((String)employeeBO.getJoinTimeStr())) {
            try {
                employeeBO.setJoinTime(LocalDateTime.parse(employeeBO.getJoinTimeStr(), DatetimeUtil.FORMATTER_DATETIME));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (StringUtils.hasText((String)employeeBO.getOrgCodes())) {
            HashSet<Long> orgIds = new HashSet<Long>();
            for (String s : employeeBO.getOrgCodes().split(",")) {
                Long orgId = orgCodeIdMap.computeIfAbsent(s.trim(), t -> {
                    Long id = (Long)this.orgQueryService.getIdByOrgCode((String)t).getData();
                    Assert.notNull((Object)id, (String)("\u7ec4\u7ec7[" + t + "]\u4e0d\u5b58\u5728"));
                    return id;
                });
                orgIds.add(orgId);
            }
            employeeBO.setOrgIds(orgIds);
        }
        Assert.notEmpty(employeeBO.getOrgIds(), (String)"\u672a\u914d\u7f6e\u6709\u6548\u7ec4\u7ec7");
        if (StringUtils.hasText((String)employeeBO.getRoleCodes())) {
            HashSet<Long> roleIds = new HashSet<Long>();
            for (String s : employeeBO.getRoleCodes().split(",")) {
                Long roleId = roleCodeIdMap.computeIfAbsent(s.trim(), t -> {
                    Long id = (Long)this.roleQueryService.getIdByCode((String)t).getData();
                    Assert.notNull((Object)id, (String)("\u89d2\u8272[" + t + "]\u4e0d\u5b58\u5728"));
                    return id;
                });
                roleIds.add(roleId);
            }
            employeeBO.setRoleIds(roleIds);
        }
        employeeBO.setWithoutLoginAccount("\u662f".equals(employeeBO.getWithoutLoginAccountName()));
        ApiResult<Long> saveResult = this.mngService.importEmployee(employeeBO);
        return saveResult.isSuccess() ? null : saveResult.getMsg();
    }

    @Autowired
    public void setUdcProvider(UdcProvider udcProvider) {
        this.udcProvider = udcProvider;
    }

    @Autowired
    public void setMngService(EmployeeMngService mngService) {
        this.mngService = mngService;
    }

    @Autowired
    public void setOrgQueryService(OrgQueryService orgQueryService) {
        this.orgQueryService = orgQueryService;
    }

    @Autowired
    public void setRoleQueryService(RoleQueryService roleQueryService) {
        this.roleQueryService = roleQueryService;
    }
}

