/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClearExpiredResourcesTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClearExpiredResourcesTask.class);
    @Autowired
    private ResourceByteMngService mngService;
    @Autowired
    private ResourceByteRepoProc resourceByteRepoProc;

    @Override
    public void run() {
        List<SysResourceByteDO> expiredFiles = this.resourceByteRepoProc.queryExpiredTempResource(LocalDateTime.now().plusDays(2L), 50);
        if (expiredFiles.isEmpty()) {
            return;
        }
        for (SysResourceByteDO expiredFile : expiredFiles) {
            this.mngService.delete(expiredFile.getId());
            logger.info("\u5220\u9664\u8fc7\u671f\u7684\u4e34\u65f6\u6587\u4ef6\uff1a{}\uff0c{}", (Object)expiredFile.getResourceKey(), (Object)expiredFile.getCreateTime());
        }
    }
}

