/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rest;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.context.ExecutorContextHolder;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.common.CacheableServiceClient;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RsaUtil;
import com.elitescloud.boot.web.common.param.SignatureModel;
import com.elitescloud.boot.web.common.signature.ApiSignature;
import com.elitescloud.boot.web.config.WebProperties;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.cacheable.SysCacheSettingRpcService;
import com.elitescloud.cloudt.system.controller.mng.org.EmployeeMngController;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.SysUdcRpcService;
import com.elitescloud.cloudt.system.provider.mq.SystemMqBinding;
import com.elitescloud.cloudt.system.provider.orgsync.WecomEmpSync;
import com.elitescloud.cloudt.system.provider.orgsync.WecomOrgSync;
import com.elitescloud.cloudt.system.rest.TestOpenFeign;
import com.elitescloud.cloudt.system.service.OpenApiMngService;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/sys/test"}, produces={"application/json"})
@Api(value="\u63a5\u53e3\u6d4b\u8bd5", tags={"\u3010\u8c03\u8bd5\u3011\u6d4b\u8bd5"})
@BusinessObject(businessType="Sys_Test:\u6d4b\u8bd5")
public class SysTestController {
    private static final Logger log = LoggerFactory.getLogger(SysTestController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private RedisUtils redisUtils;
    @Autowired(required=false)
    private SystemMqBinding systemMqBinding;
    @Autowired
    private SysUdcRpcService udcRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private TestOpenFeign openFeign;
    @Autowired(required=false)
    @Qualifier(value="restTemplateCloudtSignable")
    private RestTemplate restTemplate;

    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3")
    @ApiOperationSupport(order=2)
    @GetMapping(value={"/hello"})
    public ApiResult<String> hello(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = request.getHeaders(headerName);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                log.info("headerName:{}, value:{}", (Object)headerName, (Object)value);
            }
        }
        return ApiResult.ok((Object)"Hello, this is \u4e91\u65f6\u901a");
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/users/current"})
    public ApiResult<String> getCurrentUser(String req) throws JsonProcessingException {
        GeneralUserDetails obj = SecurityContextUtil.currentUser();
        if (StringUtils.hasText((String)req)) {
            throw new BusinessException("\u5f02\u5e38");
        }
        String res = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
        return ApiResult.ok((Object)res);
    }

    @ApiOperation(value="\u7528\u6237\u4fe1\u606f\u83b7\u53d6\uff08\u6a21\u62df\u767b\u9646\uff09")
    @ApiOperationSupport(order=10)
    @GetMapping(value={"/user/get"})
    public String getUserInfo(String username) throws JsonProcessingException {
        log.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f");
        SysUserDTO obj = this.userQueryService.getUserByUsername(username);
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)obj);
    }

    @ApiOperation(value="\u901a\u8fc7ID\u53d6\u5f97\u7528\u6237\u660e\u7ec6\uff08\u65b0\uff09")
    @ApiOperationSupport(order=21)
    @GetMapping(value={"/users/details/{id}"})
    public ApiResult<SysUserDetailsVO> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.sysUserService.findDetailsById(id));
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5220\u9664\u4f01\u5fae\u7ec4\u7ec7")
    @ApiOperationSupport(order=22)
    @GetMapping(value={"/org/wecom/delete"})
    public ApiResult<Boolean> deleteWecomOrg(@RequestParam(name="id") Long id) {
        ((WecomOrgSync)SpringContextHolder.getBean(WecomOrgSync.class)).onDelete(id);
        return ApiResult.ok((Object)true);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5220\u9664\u6240\u6709\u4f01\u5fae\u7ec4\u7ec7")
    @ApiOperationSupport(order=22)
    @GetMapping(value={"/org/wecom/deleteAll"})
    public ApiResult<Boolean> deleteWecomOrgAll(@RequestParam(name="id", required=false) Long id) {
        ((WecomOrgSync)SpringContextHolder.getBean(WecomOrgSync.class)).deleteAllOrg(id);
        return ApiResult.ok((Object)true);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u5220\u9664\u4f01\u5fae\u7528\u6237")
    @ApiOperationSupport(order=23)
    @GetMapping(value={"/emp/wecom/delete"})
    public ApiResult<Boolean> deleteWecomUser(@RequestParam(name="id") Long id) {
        ((WecomEmpSync)SpringContextHolder.getBean(WecomEmpSync.class)).onDelete(id);
        return ApiResult.ok((Object)true);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2redis keys")
    @ApiOperationSupport(order=30)
    @GetMapping(value={"/redis/keys"})
    public ApiResult<Set<String>> scanRedisKeys(String prefix, String del) {
        String key = prefix + "*";
        Set keys = this.redisUtils.getRedisTemplate().keys((Object)key);
        log.info("\u6570\u91cf\uff1a{}", (Object)keys.size());
        List keys1 = this.redisUtils.scan(key);
        if ("true".equals(del)) {
            if (CollUtil.isNotEmpty((Collection)keys)) {
                for (String s : keys) {
                    this.redisUtils.del(new String[]{s});
                }
            }
            if (CollUtil.isNotEmpty((Collection)keys1)) {
                for (String s : keys1) {
                    this.redisUtils.del(new String[]{s});
                }
            }
        }
        return ApiResult.ok(new HashSet(keys1));
    }

    @ApiOperation(value="\u6d4b\u8bd5redis\u503c\u64cd\u4f5c")
    @ApiOperationSupport(order=31)
    @GetMapping(value={"/redis/get"})
    @BusinessObjectOperation(logEnabled=true, operationType=OperationTypeEnum.ELSE, operationDescription="\u6d4b\u8bd5redis\u503c\u64cd\u4f5c")
    public ApiResult<String> testRedisValue(String key, String value) {
        if (!StringUtils.hasText((String)key)) {
            return ApiResult.fail((String)"key\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)value)) {
            this.redisUtils.set(key, (Object)value);
            return ApiResult.ok((Object)("\u8bbe\u7f6e\u503c\uff1a" + value));
        }
        value = (String)this.redisUtils.get(key);
        return ApiResult.ok((Object)("\u53d6\u5f97\u503c\uff1a" + value));
    }

    @ApiOperation(value="MQ\u53d1\u9001\u6d88\u606f")
    @ApiOperationSupport(order=40)
    @GetMapping(value={"/mq/send"})
    public ApiResult<String> testSendMq() {
        Message message = MessageBuilder.withPayload((Object)"hello").setHeader("un", (Object)"wangs").build();
        this.systemMqBinding.systemOutput().send(message);
        return ApiResult.ok((Object)"success");
    }

    @ApiOperation(value="CloudtMQ")
    @ApiOperationSupport(order=41)
    @GetMapping(value={"/mq/cloudt"})
    public ApiResult<String> cloudtMq(@RequestParam(name="channel", required=false) String channel, @RequestParam(name="pub", required=false, defaultValue="false") Boolean pub) throws Exception {
        if (CharSequenceUtil.isBlank((CharSequence)channel)) {
            channel = "mq_wangs";
        }
        FileInfoVO fileInfoVO = new FileInfoVO();
        fileInfoVO.setFileCode(DatetimeUtil.currentTimeLong());
        fileInfoVO.setUploadTime(LocalDateTime.now());
        if (Boolean.TRUE.equals(pub)) {
            ((MessageQueueTemplate)SpringContextHolder.getBean(MessageQueueTemplate.class)).publishMessage(channel, (Serializable)fileInfoVO);
        } else {
            ((MessageQueueTemplate)SpringContextHolder.getBean(MessageQueueTemplate.class)).sendMessage(channel, (Serializable)fileInfoVO);
        }
        return ApiResult.ok((Object)fileInfoVO.getFileCode());
    }

    @ApiOperation(value="\u6d4b\u8bd5\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f")
    @ApiOperationSupport(order=50)
    @GetMapping(value={"/server/info"})
    @BusinessObjectOperation(logEnabled=true, operationType=OperationTypeEnum.ELSE, operationDescription="\u6d4b\u8bd5\u83b7\u53d6\u670d\u52a1\u5668\u4fe1\u606f", allowRepeatRequest=false, businessParamValueKey="#p1")
    public ApiResult<Map<String, Object>> testGetServerInfo(HttpServletRequest request, String sn) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("\u5185\u6838\u6570", Runtime.getRuntime().availableProcessors());
        result.put("\u8bf7\u6c42\u8def\u5f84", request.getRequestURL());
        result.put("\u5ba2\u6237\u7aefIP", HttpServletUtil.currentClientIp());
        result.put("remoteAddr", request.getRemoteAddr());
        result.put("header-origin", request.getHeader("Origin"));
        result.put("header-host", request.getHeader("Host"));
        result.put("header-referer", request.getHeader("Referer"));
        result.put("\u89e3\u6790\u5f97\u57df\u540d", HttpServletUtil.obtainDomain((HttpServletRequest)request));
        log.info("\u83b7\u53d6\u5ba2\u6237\u7aefIP\uff1a{}", (Object)SysTestController.getClientIP(request, new String[0]));
        log.info("\u6267\u884c\u8005\uff1a{}", (Object)ExecutorContextHolder.get());
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            log.info("\u79df\u6237\uff1a{}", (Object)((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant());
            CompletableFuture.runAsync(() -> {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                log.info("\u5f02\u6b65\u83b7\u53d6\u5ba2\u6237\u7aefIP\uff1a{}", (Object)SysTestController.getClientIP(request, new String[0]));
                log.info("\u5f02\u6b65\u6267\u884c\u8005\uff1a{}", (Object)ExecutorContextHolder.get());
                log.info("\u7528\u6237\uff1a{}", (Object)SecurityContextUtil.currentUser());
                log.info("\u79df\u6237\uff1a{}", (Object)((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant());
            }, (Executor)this.taskExecutor);
            return null;
        }, "1009");
        return ApiResult.ok(result);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u83b7\u53d6OpenAPI")
    @ApiOperationSupport(order=51)
    @GetMapping(value={"/openApi/get"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DOWNLOAD, operationDescription="\u8fd4\u56de\u5e73\u53f0\u7684OpenAPI JSON")
    public String getJson(@RequestParam(name="single", required=false, defaultValue="false") Boolean single) throws IOException {
        OpenAPI openAPI = null;
        if (Boolean.TRUE.equals(single)) {
            openAPI = (OpenAPI)((OpenApiMngService)SpringContextHolder.getBean(OpenApiMngService.class)).testAnalyzeController(EmployeeMngController.class).getData();
        }
        openAPI = (OpenAPI)((OpenApiMngService)SpringContextHolder.getBean(OpenApiMngService.class)).testAnalyzeController(null).getData();
        return Json.pretty((Object)openAPI);
    }

    private static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return SysTestController.getClientIPByHeader(request, headers);
    }

    private static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            log.info("\u5c1d\u8bd5\u83b7\u53d6\u8bf7\u6c42\u5934\uff1a{}, {}", (Object)header, (Object)ip);
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        log.info("\u5c1d\u8bd5\u83b7\u53d6RemoteAddr:{}", (Object)ip);
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u8bf7\u6c42\u5934")
    @ApiOperationSupport(order=51)
    @GetMapping(value={"/request/headers"})
    public ApiResult<MultiValueMap<String, String>> testGetHeaders(HttpServletRequest request) {
        MultiValueMap headers = HttpServletUtil.getHeaders((HttpServletRequest)request);
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)headers);
        return ApiResult.ok((Object)headers);
    }

    @ApiOperation(value="\u83b7\u53d6MDC\u503c")
    @ApiOperationSupport(order=52)
    @GetMapping(value={"/mdc/value"})
    public ApiResult<String> testMdc(@RequestParam(name="name", required=false) String name) {
        if (CharSequenceUtil.isBlank((CharSequence)name)) {
            return ApiResult.ok((Object)JSONUtil.toJsonString((Object)MDC.getCopyOfContextMap()));
        }
        this.taskExecutor.execute(() -> {
            System.out.println(111);
            log.info("\u5f02\u6b65\u7ebf\u7a0b\uff1a{}", (Object)JSONUtil.toJsonString((Object)MDC.getCopyOfContextMap()));
        });
        CompletableFuture.runAsync(() -> {
            System.out.println(222);
            log.info("\u5f02\u6b65\u7ebf\u7a0b\uff1a{}", (Object)JSONUtil.toJsonString((Object)MDC.getCopyOfContextMap()));
        }, (Executor)this.taskExecutor);
        String value = MDC.get((String)name);
        return ApiResult.ok((Object)value);
    }

    @ApiOperation(value="\u4e0a\u4f20\u8d44\u6e90\u6587\u4ef6")
    @ApiOperationSupport(order=53)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6"), @ApiImplicitParam(name="businessType", value="\u4e1a\u52a1\u7c7b\u578b")})
    @PostMapping(value={"/res/upload"})
    public ApiResult<FileInfoVO> testUploadResource(@RequestParam(name="file") MultipartFile file, @RequestParam(name="businessType") String businessType) {
        return ((ResourceByteMngService)SpringContextHolder.getBean(ResourceByteMngService.class)).saveResource(file, businessType);
    }

    @ApiOperation(value="\u67e5\u8be2UDC\u4fe1\u606f")
    @ApiOperationSupport(order=60)
    @GetMapping(value={"/udc/get"})
    public ApiResult<SysUdcDTO> getUdc(String appCode, String udcCode) {
        return this.udcRpcService.get(appCode, udcCode);
    }

    @ApiOperation(value="\u67e5\u8be2UDC\u5217\u8868")
    @ApiOperationSupport(order=61)
    @PostMapping(value={"/udc/list"})
    @BusinessObjectOperation(logEnabled=true, operationType=OperationTypeEnum.ELSE, operationDescription="\u67e5\u8be2UDC\u5217\u8868", allowRepeatRequest=false)
    public ApiResult<List<SysUdcDTO>> listUdc(String appCode, @RequestBody Set<String> udcCodes) {
        return this.udcRpcService.listByUdcCode(appCode, udcCodes);
    }

    @ApiOperation(value="\u83b7\u53d6UDC\u4fe1\u606f\uff08\u7f13\u5b58\uff09")
    @ApiOperationSupport(order=62)
    @GetMapping(value={"/udc/get/cache"})
    public ApiResult<SysUdcDTO> getUdcCache(String appCode, String udcCode) {
        SysUdcDTO udcDto = this.udcProvider.getByUdcCode(appCode, udcCode);
        return ApiResult.ok((Object)udcDto);
    }

    @ApiOperation(value="\u751f\u6210ID")
    @ApiOperationSupport(order=63)
    @GetMapping(value={"/id/next"})
    public ApiResult<Serializable> idNext() {
        return ApiResult.ok((Object)IdGenerator.generate());
    }

    @ApiOperation(value="\u53d1\u53f7\u5668")
    @ApiOperationSupport(order=64)
    @GetMapping(value={"/seq/next"})
    public ApiResult<List<String>> seq(String appCode, String ruleCode, Integer num) {
        List value = this.seqNumProvider.generateCode(appCode, ruleCode, null, (Integer)ObjectUtil.defaultIfNull((Object)num, (Object)1));
        return ApiResult.ok((Object)value);
    }

    @ApiOperation(value="\u53d1\u9001\u7ad9\u5185\u4fe1")
    @ApiOperationSupport(order=65)
    @PostMapping(value={"/messenger/site"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.ELSE, operationDescription="\u53d1\u9001\u7ad9\u5185\u4fe1", allowRepeatRequest=false, businessParamValueKey="#p0.subject")
    public ApiResult<String> testSendSiteMsg(@RequestBody MessageSiteVO siteVO) {
        String msgId = Messenger.siteMessage().setSubject(CharSequenceUtil.blankToDefault((CharSequence)siteVO.getSubject(), (String)"\u672a\u63d0\u4f9b\u6807\u9898")).setContent(CharSequenceUtil.blankToDefault((CharSequence)siteVO.getContent(), (String)"\u672a\u63d0\u4f9b\u5185\u5bb9")).setReceiverList(List.of(new MessageAccountVO(CharSequenceUtil.blankToDefault((CharSequence)siteVO.getUsername(), (String)"admin")))).setBusinessType(CharSequenceUtil.blankToDefault((CharSequence)siteVO.getBusinessType(), (String)"approve")).setBusinessParams(siteVO.getBusinessParams()).build().send();
        return ApiResult.ok((Object)msgId);
    }

    @ApiOperation(value="\u53d1\u9001\u90ae\u4ef6")
    @ApiOperationSupport(order=66)
    @ApiImplicitParam(name="emailAddress", value="\u90ae\u7bb1\u5730\u5740", required=true)
    @BusinessObjectOperation(logEnabled=true, operationType=OperationTypeEnum.ELSE, operationDescription="\u53d1\u9001\u90ae\u4ef6", allowRepeatRequest=false)
    @PostMapping(value={"/messenger/email"})
    public ApiResult<String> testSendEmailMsg(@RequestParam(name="emailAddress") String emailAddress) {
        Assert.hasText((String)emailAddress, (String)"\u90ae\u4ef6\u5730\u5740\u4e3a\u7a7a");
        String msgId = Messenger.email().setSubject("\u6d4b\u8bd5\u90ae\u4ef6").setContent("\u90ae\u4ef6\u5185\u5bb9").setReceiverList(List.of(new MessageAccountVO(emailAddress, "wangs"))).build().send();
        return ApiResult.ok((Object)msgId);
    }

    @ApiOperation(value="\u53d1\u9001html\u90ae\u4ef6")
    @ApiOperationSupport(order=66)
    @ApiImplicitParams(value={@ApiImplicitParam(name="emailAddress", value="\u90ae\u7bb1\u5730\u5740", required=true), @ApiImplicitParam(name="fileUrl", value="\u56fe\u7247\u7684\u8bbf\u95ee\u8def\u5f84", required=true)})
    @BusinessObjectOperation(logEnabled=true, operationType=OperationTypeEnum.ELSE, operationDescription="\u53d1\u9001\u90ae\u4ef6", allowRepeatRequest=false)
    @PostMapping(value={"/messenger/emailHtml"})
    public ApiResult<String> testSendEmailMsg(@RequestParam(name="emailAddress") String emailAddress, @RequestParam(name="fileUrl") String fileUrl) {
        Assert.hasText((String)emailAddress, (String)"\u90ae\u4ef6\u5730\u5740\u4e3a\u7a7a");
        String msgId = Messenger.richTextEmail().setSubject("\u6d4b\u8bd5\u90ae\u4ef6").setContent("\u90ae\u4ef6\u5185\u5bb9\uff0c<img src='" + fileUrl + "' />").setReceiverList(List.of(new MessageAccountVO(emailAddress, "wangs"))).build().send();
        return ApiResult.ok((Object)msgId);
    }

    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1")
    @ApiOperationSupport(order=67)
    @ApiImplicitParams(value={@ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7", required=true), @ApiImplicitParam(name="templateCode", value="\u6a21\u677f\u7f16\u7801"), @ApiImplicitParam(name="signName", value="\u7b7e\u540d")})
    @PostMapping(value={"/messenger/sms"})
    public ApiResult<String> testSendSmsMsg(@RequestParam(name="mobile") String mobile, @RequestParam(name="templateCode", required=false) String templateCode, @RequestParam(name="signName", required=false) String signName) {
        Assert.hasText((String)mobile, (String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        String msgId = Messenger.templateSms().setSubject("\u6807\u9898").setContent("\u5185\u5bb9").setReceiverList(List.of(new MessageAccountVO(mobile))).setTemplateCode(CharSequenceUtil.blankToDefault((CharSequence)templateCode, (String)"SMS_269440639")).setTemplateParam(Map.of("code", "147852")).setSignName(signName).build().send();
        return ApiResult.ok((Object)msgId);
    }

    @ApiOperation(value="\u53d1\u9001App\u6d88\u606f")
    @ApiOperationSupport(order=68)
    @ApiImplicitParam(name="username", value="\u7528\u6237\u540d", required=true)
    @GetMapping(value={"/messenger/app"})
    public ApiResult<String> testSendAppMsg(@RequestParam(name="username") String username) {
        Assert.hasText((String)username, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        String msgId = Messenger.appMessage().setSubject("\u4f60\u6709\u65b0\u7684\u5ba1\u6279\u63d0\u9192").setContent("\u8fd9\u662f\u5f85\u5ba1\u6279\u7684\u5185\u5bb9...").setReceiverList(List.of(new MessageAccountVO(username))).setBusinessType("appr_order").setBusinessParams(Map.of("code", "147852")).build().send();
        return ApiResult.ok((Object)msgId);
    }

    @ApiOperation(value="\u7f13\u5b58\u4e2d\u83b7\u53d6\u8bbe\u7f6e\u9879")
    @ApiOperationSupport(order=69)
    @ApiImplicitParam(name="code", value="\u7f13\u5b58\u7f16\u7801")
    @GetMapping(value={"/cache/setting"})
    public ApiResult<Object> testGetSettingCache(@RequestParam(name="code", required=false) String code) {
        SysCacheSettingRpcService rpcService = (SysCacheSettingRpcService)SpringContextHolder.getBean(SysCacheSettingRpcService.class);
        if (StringUtils.hasText((String)code)) {
            return ApiResult.ok((Object)rpcService.oneByNo(code));
        }
        return ApiResult.ok((Object)rpcService.all());
    }

    @ApiOperation(value="\u6e05\u7a7a\u7f13\u5b58\u9879")
    @ApiOperationSupport(order=70)
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCode", value="\u5e94\u7528\u7f16\u7801", required=true), @ApiImplicitParam(name="code", value="\u7f13\u5b58\u670d\u52a1\u6807\u8bc6")})
    @GetMapping(value={"/cache/clear"})
    public ApiResult<Boolean> testClearCache(@RequestParam(name="appCode") String appCode, @RequestParam(name="code", required=false) String code) {
        CacheableServiceClient rpcService = (CacheableServiceClient)DynamicClientHelper.getClient((String)appCode, CacheableServiceClient.class, (String)"/secRpc/cloudt/cacheServiceClient");
        rpcService.clearAll(code);
        return ApiResult.ok((Object)true);
    }

    @ApiOperation(value="\u83b7\u53d6\u6ce8\u518c\u7684\u670d\u52a1")
    @ApiOperationSupport(order=71)
    @GetMapping(value={"/service/list"})
    public ApiResult<String> testGetServices(String instanceName) {
        log.info("\u670d\u52a1\u5217\u8868\uff1a{}", (Object)String.join((CharSequence)",", this.discoveryClient.getServices()));
        if (StringUtils.hasText((String)instanceName)) {
            for (ServiceInstance instance : this.discoveryClient.getInstances(instanceName)) {
                log.info("instanceId\uff1a{}, serviceId\uff1a{}, schema: {} Host\uff1a{}, Port\uff1a{}, Uri\uff1a{}, secure: {} metadata\uff1a{}", new Object[]{instance.getInstanceId(), instance.getServiceId(), instance.getScheme(), instance.getHost(), instance.getPort(), instance.getUri(), instance.isSecure(), instance.getMetadata()});
            }
        }
        return ApiResult.ok((Object)"success");
    }

    @ApiOperation(value="\u89e3\u6790\u5bfc\u5165\u7684UDC")
    @ApiOperationSupport(order=81)
    @PostMapping(value={"/udc/import"})
    public ApiResult<String> testImportUdc(@RequestParam(value="file") MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return ApiResult.fail((String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        List<String> sqlList = this.generateUdcSql(file);
        return ApiResult.ok((Object)String.join((CharSequence)"", sqlList));
    }

    @ApiOperation(value="\u6d4b\u8bd5\u63a5\u53e3\u81ea\u52a8\u9a8c\u7b7e")
    @ApiOperationSupport(order=82)
    @PostMapping(value={"/sign"})
    @ApiSignature(model=SignatureModel.VERIFY_SIGN)
    public ApiResult<SysSettingVO> testSignature(@RequestBody SysSettingVO sysSettingVO, HttpServletRequest request) {
        String headerName = ((WebProperties)SpringContextHolder.getBean(WebProperties.class)).getApiSign().getSignatureParamName();
        System.out.println(request.getHeader(headerName));
        return ApiResult.ok((Object)sysSettingVO);
    }

    @ApiOperation(value="\u6d4b\u8bd5RestTemplate\u7b7e\u540d")
    @ApiOperationSupport(order=83)
    @GetMapping(value={"/sign/restTemplate"})
    public ApiResult<String> testSignature() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("settingNo", DatetimeUtil.currentTimeLong());
        ResponseEntity result = this.restTemplate.postForEntity("http://127.0.0.1:9010/sys/test/sign", body, String.class, new Object[0]);
        return ApiResult.ok((Object)((String)result.getBody()));
    }

    @ApiOperation(value="\u751f\u6210RSA\u5bc6\u94a5\u5bf9")
    @ApiOperationSupport(order=84)
    @GetMapping(value={"/rsa/generate"})
    public ApiResult<Map<String, String>> testGenerateRsa() {
        KeyPair keypair = RsaUtil.generateKeyPair();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("publicKey", RsaUtil.convertKey2Str((Key)keypair.getPublic()));
        result.put("privateKey", RsaUtil.convertKey2Str((Key)keypair.getPrivate()));
        return ApiResult.ok(result);
    }

    @ApiOperation(value="\u6d4b\u8bd5RSA\u7b7e\u540d")
    @ApiOperationSupport(order=85)
    @PostMapping(value={"/rsa/sign/test"})
    public ApiResult<String> testSignature(@RequestBody SignVO signVO) {
        String result = RsaUtil.sign((PrivateKey)RsaUtil.convert2PrivateKey((String)signVO.getPrivateKey()), (String)signVO.getSignatureAlgorithm(), (String)signVO.getPlainText());
        return ApiResult.ok((Object)result);
    }

    @ApiOperation(value="\u6d4b\u8bd5RSA\u9a8c\u8bc1\u7b7e\u540d")
    @ApiOperationSupport(order=85)
    @PostMapping(value={"/rsa/sign/testVerify"})
    public ApiResult<Boolean> testVerifySignature(@RequestBody VerifySignVO signVO) {
        boolean result = RsaUtil.verifySign((PublicKey)RsaUtil.convert2PublicKey((String)signVO.getPublicKey()), (String)signVO.getSignatureAlgorithm(), (String)signVO.getPlainText(), (String)signVO.getSignature());
        return ApiResult.ok((Object)result);
    }

    @ApiOperation(value="\u663e\u793a\u56fe\u7247", hidden=true)
    @ApiOperationSupport(order=99)
    @Ignore
    @ApiImplicitParam(name="fileCode", value="\u6587\u4ef6\u552f\u4e00\u6807\u8bc6", required=true)
    @GetMapping(value={"/img/show"})
    public HttpEntity<Resource> show(@RequestParam(name="fileCode") String fileCode, HttpServletResponse response) {
        log.info("\u8bf7\u6c42\uff1a{}", (Object)fileCode);
        HttpEntity httpEntity = null;
        try {
            httpEntity = ((FileService)SpringContextHolder.getBean(FileService.class)).preview(fileCode, null);
        }
        catch (Exception e) {
            log.error("\u9884\u89c8\u56fe\u7247\u5f02\u5e38\uff1a", (Throwable)e);
            return ResponseEntity.badRequest().build();
        }
        if (httpEntity.getHeaders().getContentType() == null) {
            response.setContentType("image/jpeg");
        }
        response.setHeader("Cache-Control", CacheControl.noStore().getHeaderValue());
        return httpEntity;
    }

    private List<String> generateUdcSql(MultipartFile file) throws Exception {
        List dataList = ExcelImportUtil.instance((InputStream)file.getInputStream()).headRow(Integer.valueOf(1)).sheetNo(Set.of(Integer.valueOf(1))).dataType(null, Integer.valueOf(1)).readAllSync();
        log.info("\u6570\u636e\u91cf\uff1a{}", (Object)dataList.size());
        ArrayList udcParamList = new ArrayList();
        ArrayList udcValueParamList = new ArrayList();
        HashSet<CallSite> existsUdc = new HashSet<CallSite>();
        HashSet<CallSite> existsUdcValue = new HashSet<CallSite>();
        int i = 0;
        long id = System.currentTimeMillis();
        for (Map data : dataList) {
            ++i;
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            HashMap<String, Number> udcValueParams = new HashMap<String, Number>();
            Object appCode = data.get("app_code");
            Object udcCode = data.get("udc_code");
            Object udcValueCode = data.get("udc_value_code");
            if (!existsUdc.contains(String.valueOf(appCode) + ":" + String.valueOf(udcCode))) {
                hashMap.put("id", id + (long)i);
                hashMap.put("tenant_id", -1);
                hashMap.put("app_code", (Number)appCode);
                hashMap.put("udc_code", (Number)udcCode);
                hashMap.put("udc_name", (Number)data.get("udc_name"));
                hashMap.put("udc_describe", (Number)data.get("udc_describe"));
                existsUdc.add((CallSite)((Object)(String.valueOf(appCode) + ":" + String.valueOf(udcCode))));
                udcParamList.add(hashMap);
            }
            if (existsUdcValue.contains(String.valueOf(appCode) + ":" + String.valueOf(udcCode) + ":" + String.valueOf(udcValueCode))) {
                System.out.println("\u5df2\u5b58\u5728\uff1a" + String.valueOf(appCode) + ":" + String.valueOf(udcCode) + ":" + String.valueOf(udcValueCode));
                continue;
            }
            existsUdcValue.add((CallSite)((Object)(String.valueOf(appCode) + ":" + String.valueOf(udcCode) + ":" + String.valueOf(udcValueCode))));
            udcValueParams.put("id", id + (long)i);
            udcValueParams.put("tenant_id", -1);
            udcValueParams.put("app_code", (Number)appCode);
            udcValueParams.put("udc_code", (Number)udcCode);
            udcValueParams.put("udc_value_code", (Number)udcValueCode);
            udcValueParams.put("udc_value_name", (Number)data.get("udc_value_name"));
            udcValueParams.put("udc_order", (Number)data.get("udc_order"));
            udcValueParams.put("udc_value_describe", (Number)data.get("udc_value_describe"));
            udcValueParamList.add(udcValueParams);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        for (Map map : udcParamList) {
            map.put("allow_update", 1);
            map.put("allow_add_value", 0);
            sqlList.add(this.convertSql("sys_platform_udc", map));
        }
        for (Map map : udcValueParamList) {
            map.put("allow_start", 1);
            map.put("allow_default", 1);
            sqlList.add(this.convertSql("sys_platform_udc_value", map));
        }
        return sqlList;
    }

    private String convertSql(String tableName, Map<String, Object> params) {
        ArrayList<String> fieldList = new ArrayList<String>();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof String) {
                if (CharSequenceUtil.isBlank((CharSequence)((String)entry.getValue()))) continue;
                valueList.add("'" + String.valueOf(entry.getValue()) + "'");
            } else {
                valueList.add(entry.getValue().toString());
            }
            fieldList.add(entry.getKey());
        }
        return "insert into " + tableName + "(" + String.join((CharSequence)", ", fieldList) + ") values (" + String.join((CharSequence)", ", valueList) + ");";
    }

    static {
        InterceptUri.addAllowUri(Set.of("/sys/test/**"));
    }

    @ApiModel(description="\u7ad9\u5185\u4fe1\u4fe1\u606f")
    public static class MessageSiteVO
    implements Serializable {
        private static final long serialVersionUID = -1485869990419072189L;
        @ApiModelProperty(value="\u6807\u9898", position=1, required=true)
        private String subject;
        @ApiModelProperty(value="\u5185\u5bb9", position=2, required=true)
        private String content;
        @ApiModelProperty(value="\u63a5\u6536\u4eba\u8d26\u53f7", position=3, required=true)
        private String username;
        @ApiModelProperty(value="\u4e1a\u52a1\u7c7b\u578b", position=4, required=true)
        private String businessType;
        @ApiModelProperty(value="\u4e1a\u52a1\u6269\u5c55\u53c2\u6570", position=5)
        private Map<String, String> businessParams;

        public String getSubject() {
            return this.subject;
        }

        public String getContent() {
            return this.content;
        }

        public String getUsername() {
            return this.username;
        }

        public String getBusinessType() {
            return this.businessType;
        }

        public Map<String, String> getBusinessParams() {
            return this.businessParams;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setBusinessType(String businessType) {
            this.businessType = businessType;
        }

        public void setBusinessParams(Map<String, String> businessParams) {
            this.businessParams = businessParams;
        }
    }

    public static class SignVO
    implements Serializable {
        private static final long serialVersionUID = -6909523282514635746L;
        @ApiModelProperty(value="\u79c1\u94a5")
        private String privateKey;
        @ApiModelProperty(value="\u7b7e\u540d\u7b97\u6cd5")
        private String signatureAlgorithm;
        @ApiModelProperty(value="\u660e\u6587\u5185\u5bb9")
        private String plainText;

        public String getPrivateKey() {
            return this.privateKey;
        }

        public String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public String getPlainText() {
            return this.plainText;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public void setPlainText(String plainText) {
            this.plainText = plainText;
        }
    }

    public static class VerifySignVO
    implements Serializable {
        private static final long serialVersionUID = -6909523282514635746L;
        @ApiModelProperty(value="\u516c\u94a5")
        private String publicKey;
        @ApiModelProperty(value="\u7b7e\u540d\u7b97\u6cd5")
        private String signatureAlgorithm;
        @ApiModelProperty(value="\u660e\u6587\u5185\u5bb9")
        private String plainText;
        @ApiModelProperty(value="\u7b7e\u540d")
        private String signature;

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public String getPlainText() {
            return this.plainText;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public void setPlainText(String plainText) {
            this.plainText = plainText;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }
    }
}

