/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.SysNoticeRpcService;
import com.elitescloud.cloudt.system.provider.dto.save.SysNoticeSaveDTO;
import com.elitescloud.cloudt.system.service.NoticeMngService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/notice"}, produces={"application/json"})
public class SysNoticeRpcServiceImpl
implements SysNoticeRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SysNoticeRpcServiceImpl.class);
    @Autowired
    private NoticeMngService mngService;

    public ApiResult<Long> publish(SysNoticeSaveDTO saveDTO) {
        return this.mngService.publish(saveDTO);
    }

    public ApiResult<List<Long>> publish(List<SysNoticeSaveDTO> saveDTOList) {
        if (CollUtil.isEmpty(saveDTOList)) {
            return ApiResult.fail((String)"\u516c\u544a\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<Long> saveIds = new ArrayList<Long>();
        for (SysNoticeSaveDTO saveDTO : saveDTOList) {
            try {
                Long id = (Long)this.mngService.publish(saveDTO).computeData();
                if (id == null) continue;
                saveIds.add(id);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u516c\u544a\u5f02\u5e38\uff1a{}", (Object)JSONUtil.toJsonString((Object)saveDTO), (Object)e);
                if (saveIds.isEmpty()) continue;
                this.mngService.delete(new HashSet<Long>(saveIds), true);
            }
        }
        return ApiResult.ok(saveIds);
    }

    public ApiResult<Long> revoke(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u516c\u544aID\u4e3a\u7a7a");
        }
        return this.mngService.delete(Set.of(id), true).map(t -> id);
    }

    public ApiResult<Set<Long>> revokeBatch(Set<Long> ids) {
        return this.mngService.delete(ids, true);
    }
}

