/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.service.AuthUserService;
import com.elitescloud.cloudt.system.service.PermissionMngService;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/userPermission"}, produces={"application/json"})
public class SysUserPermissionRpcServiceImpl
implements SysUserPermissionRpcService {
    private static final Logger logger = LoggerFactory.getLogger(SysUserPermissionRpcServiceImpl.class);
    private PermissionMngService permissionMngService;
    private PermissionQueryService permissionQueryService;
    private AuthUserService authUserService;
    private TextEncryptor encryptor;
    private UserRepoProc userRepoProc;
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public ApiResult<List<IdCodeNameParam>> listAllRoles(String tenantCode) {
        return this.permissionQueryService.listAllRoles(tenantCode);
    }

    public ApiResult<List<IdCodeNameParam>> listAllRolesByTenantOrg(String tenantOrgCode) {
        return this.permissionQueryService.listAllRolesByTenantOrg(tenantOrgCode);
    }

    public ApiResult<Long> saveUserRoles(Long userId, List<Long> roleIds) {
        return this.permissionMngService.saveUserRoles(userId, roleIds);
    }

    public ApiResult<List<Long>> saveUserRoles(List<UserRoleSaveDTO> saveDTOList) {
        return this.permissionMngService.saveUserRoles(saveDTOList);
    }

    public ApiResult<Set<Long>> getUserIdByRoleCode(String roleCode) {
        return this.permissionQueryService.getUserIdByRoleCode(roleCode);
    }

    public ApiResult<List<SysUserBasicDTO>> listUserByRole(String roleCode) {
        return this.permissionQueryService.listUserByRole(roleCode);
    }

    public ApiResult<OAuthToken> authByUserId(AuthUserIdQueryDTO queryDTO) {
        if (this.authUserService == null) {
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u8ba4\u8bc1");
        }
        String userIdTxt = null;
        try {
            userIdTxt = this.decrypt(queryDTO.getUserIdCypher());
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u5bc6\u7528\u6237ID\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u52a0\u5bc6\u65b9\u5f0f\u6b63\u786e");
        }
        if (CharSequenceUtil.isBlank((CharSequence)userIdTxt)) {
            return ApiResult.fail((String)"\u7528\u6237\u6807\u8bc6\u4e3a\u7a7a");
        }
        return this.authUserService.authenticate(null, null, InternalAuthenticationGranter.IdType.USER_ID.name(), userIdTxt);
    }

    public ApiResult<OAuthToken> authByUserMobile(AuthUserIdQueryDTO queryDTO) {
        if (this.authUserService == null) {
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u8ba4\u8bc1");
        }
        String mobileTxt = null;
        try {
            mobileTxt = this.decrypt(queryDTO.getUserIdCypher());
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u5bc6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u52a0\u5bc6\u65b9\u5f0f\u6b63\u786e");
        }
        if (CharSequenceUtil.isBlank((CharSequence)mobileTxt)) {
            return ApiResult.fail((String)"\u7528\u6237\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        return this.authUserService.authenticate(null, null, InternalAuthenticationGranter.IdType.MOBILE.name(), mobileTxt);
    }

    public ApiResult<OAuthToken> authByUserEmail(AuthUserIdQueryDTO queryDTO) {
        if (this.authUserService == null) {
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u8ba4\u8bc1");
        }
        String emailTxt = null;
        try {
            emailTxt = this.decrypt(queryDTO.getUserIdCypher());
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u5bc6\u7528\u6237\u90ae\u7bb1\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u52a0\u5bc6\u65b9\u5f0f\u6b63\u786e");
        }
        if (CharSequenceUtil.isBlank((CharSequence)emailTxt)) {
            return ApiResult.fail((String)"\u7528\u6237\u90ae\u7bb1\u4e3a\u7a7a");
        }
        return this.authUserService.authenticate(null, null, InternalAuthenticationGranter.IdType.EMAIL.name(), emailTxt);
    }

    public ApiResult<OAuthToken> authByOuterKey(AuthUserIdQueryDTO queryDTO) {
        if (this.authUserService == null) {
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301\u8ba4\u8bc1");
        }
        String outerKeyTxt = null;
        try {
            outerKeyTxt = this.decrypt(queryDTO.getUserIdCypher());
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u5bc6\u7528\u6237\u5916\u90e8\u6807\u8bc6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u52a0\u5bc6\u65b9\u5f0f\u6b63\u786e");
        }
        if (CharSequenceUtil.isBlank((CharSequence)outerKeyTxt)) {
            return ApiResult.fail((String)"\u7528\u6237\u5916\u90e8\u6807\u8bc6\u4e3a\u7a7a");
        }
        List<Long> ids = this.userRepoProc.getIdByOuterKey(outerKeyTxt);
        if (ids.isEmpty()) {
            return ApiResult.fail((String)"\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        if (ids.size() > 1) {
            return ApiResult.fail((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d26\u53f7\u6807\u8bc6");
        }
        return this.authUserService.authenticate(null, null, InternalAuthenticationGranter.IdType.USER_ID.name(), ids.get(0).toString());
    }

    public ApiResult<String> getTokenByTicket(String ticket) {
        if (this.authUserService == null) {
            return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301ticket\u6362token");
        }
        return this.authUserService.ticket2Token(ticket);
    }

    private String decrypt(String cipher) {
        if (CharSequenceUtil.isBlank((CharSequence)cipher)) {
            return null;
        }
        try {
            return this.encryptor.decrypt(cipher);
        }
        catch (Exception e) {
            logger.info("\u89e3\u5bc6\u5931\u8d25\uff0c\u5bc6\u6587\uff1a{}\uff0c\u5f02\u5e38\uff1a", (Object)cipher, (Object)e);
            throw new IllegalArgumentException("\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Autowired
    public void setPermissionMngService(PermissionMngService permissionMngService) {
        this.permissionMngService = permissionMngService;
    }

    @Autowired
    public void setPermissionQueryService(PermissionQueryService permissionQueryService) {
        this.permissionQueryService = permissionQueryService;
    }

    @Autowired(required=false)
    public void setAuthUserService(AuthUserService authUserService) {
        this.authUserService = authUserService;
    }

    @Autowired
    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Autowired
    public void setUserRepoProc(UserRepoProc userRepoProc) {
        this.userRepoProc = userRepoProc;
    }

    @Autowired
    public void setTenantDataIsolateProvider(TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }
}

