/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.provider.extend.SysTmplApiRpcService;
import com.elitescloud.cloudt.system.service.TmplImportRecordService;
import com.elitescloud.cloudt.system.service.TmplQueryService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/tmpl"}, produces={"application/json"})
public class SysTmplApiRpcServiceImpl
implements SysTmplApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(SysTmplApiRpcServiceImpl.class);
    private TmplQueryService tmplQueryService;
    private TmplImportRecordService recordService;

    public ApiResult<SysTmplDTO> getByCode(String code) {
        return this.tmplQueryService.getByCode(code);
    }

    public HttpEntity<StreamingResponseBody> downloadByCode(String code) {
        return this.tmplQueryService.downloadByCode(code);
    }

    public ApiResult<FileByteVO> getTmplFileByCode(String code) {
        return this.tmplQueryService.getTmplFileByCode(code);
    }

    public ApiResult<String> getFileCodeByCode(String code) {
        return this.tmplQueryService.getFileCodeByCode(code);
    }

    public ApiResult<Long> saveRecord(String code, String recordFileCode, Map<String, Object> queryParam) {
        return this.recordService.saveImportRecord(code, recordFileCode, queryParam);
    }

    public ApiResult<Long> updateNumTotal(Long recordId, Long numTotal) {
        return this.recordService.updateRecordTotal(recordId, numTotal);
    }

    public ApiResult<Long> updateResult(RecordResultSaveDTO resultDTO) {
        return this.recordService.updateImportResult(resultDTO);
    }

    public ApiResult<SysImportRateDTO> getImportRate(Long recordId) {
        return this.recordService.getImportRateDto(recordId);
    }

    public ApiResult<String> getRecordFileCode(Long recordId) {
        return this.recordService.getFileCode(recordId);
    }

    public ApiResult<List<Long>> queryUnFinished() {
        return this.recordService.queryUnFinished(null);
    }

    public ApiResult<List<Long>> queryUnFinished(String appCode) {
        return this.recordService.queryUnFinished(appCode);
    }

    public ApiResult<Boolean> updateResultForSysError(String appCode, String failMsg) {
        return this.recordService.updateResultForSysError(appCode, failMsg);
    }

    public ApiResult<Long> saveExportFile(Long recordId, String fileCode, Integer order) {
        return this.recordService.saveExportFile(recordId, fileCode, order);
    }

    public ApiResult<Long> saveImportFailRecord(Long recordId, String failFileCode) {
        return this.recordService.saveImportFailRecord(recordId, failFileCode);
    }

    public ApiResult<List<ImportRecordDTO>> queryRecord(String tmplCode, Integer hours, Boolean self) {
        return this.recordService.queryRecord(tmplCode, hours, self);
    }

    @Autowired
    public void setTmplQueryService(TmplQueryService tmplQueryService) {
        this.tmplQueryService = tmplQueryService;
    }

    @Autowired
    public void setRecordService(TmplImportRecordService recordService) {
        this.recordService = recordService;
    }
}

