/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/v3/user"}, produces={"application/json"})
public class UserRpcServiceImpl
implements UserRpcService {
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private UserMngService userMngService;

    public ApiResult<Long> upsert(UserCreateDTO userBasicDTO) {
        return this.userMngService.save(userBasicDTO);
    }

    public ApiResult<Long> updatePwd(Long id, String pwd) {
        return this.userMngService.updatePassword(id, pwd);
    }

    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        return this.userMngService.updateEnabled(id, enabled);
    }

    public ApiResult<Long> addUserType(Long id, String userType, String identityId) {
        return this.userMngService.addUserType(id, userType, identityId);
    }

    public ApiResult<Long> removeUserType(Long id, String userType, String identityId) {
        return this.userMngService.removeUserType(id, userType, identityId);
    }

    public ApiResult<Long> delete(Long id) {
        return this.userMngService.delete(id);
    }

    public ApiResult<SysUserBasicDTO> getById(Long id) {
        return this.userQueryService.getBasicById(id);
    }

    public ApiResult<SysUserBasicDTO> getByUsername(String username) {
        return this.userQueryService.getBasicByUsername(username);
    }

    public ApiResult<List<SysUserBasicDTO>> getByIds(List<Long> ids) {
        return this.userQueryService.getBasicById(ids);
    }

    public ApiResult<Long> getIdByUsername(String username) {
        return this.userQueryService.getIdByUsername(username);
    }

    public ApiResult<SysUserDTO> getUserByUsername(String username) {
        return ApiResult.ok((Object)this.userQueryService.getUserByUsername(username));
    }

    public ApiResult<SysUserDTO> getUserByMobile(String mobile) {
        return ApiResult.ok((Object)this.userQueryService.getUserByMobile(mobile));
    }

    public ApiResult<SysUserDTO> getUserByEmail(String email) {
        return ApiResult.ok((Object)this.userQueryService.getUserByEmail(email));
    }

    public ApiResult<SysUserDTO> getUserById(Long userId) {
        return ApiResult.ok((Object)this.userQueryService.getUserById(userId));
    }

    public ApiResult<SysUserDTO> getUserByOpenid(String appId, String openId) {
        return ApiResult.ok((Object)this.userQueryService.getUserByOpenId(appId, openId));
    }

    public ApiResult<Boolean> existsUsername(String username) {
        return this.userQueryService.existsUsername(username);
    }

    public ApiResult<Boolean> existsMobile(String mobile) {
        return this.userQueryService.existsMobile(mobile);
    }

    public ApiResult<Boolean> existsEmail(String email) {
        return this.userQueryService.existsEmail(email);
    }

    public ApiResult<Boolean> existsOuterKey(String outerKey) {
        return this.userQueryService.existsOuterKey(outerKey);
    }

    public ApiResult<List<SysUserBasicDTO>> queryUser(UserQueryDTO queryParam) {
        return this.userQueryService.queryUser(queryParam);
    }

    public ApiResult<Long> updateMobile(Long id, String mobile) {
        return this.userMngService.updateMobile(id, mobile);
    }

    public ApiResult<Long> updateEmail(Long id, String email) {
        return this.userMngService.updateEmail(id, email);
    }

    public ApiResult<Long> updateOuterKey(Long id, String outerKey) {
        return this.userMngService.updateOuterKey(id, outerKey);
    }
}

