/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.support.common.ServiceInstanceClient;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.convert.ServiceInstanceConvert;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceClassInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadPoolsRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.ServiceInstanceThreadsRespVO;
import com.elitescloud.cloudt.system.service.devops.ServiceInstanceService;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceInstanceServiceImpl
implements ServiceInstanceService {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInstanceServiceImpl.class);

    @Override
    public ApiResult<ServiceInstanceInfoRespVO> getServiceInstanceInfo(String serviceId, String url) {
        ServiceInstanceClient client = this.buildServiceInstanceClient(serviceId, url);
        try {
            return client.getServiceInstanceInfo(Boolean.valueOf(true)).map(ServiceInstanceConvert.INSTANCE::dto2RepVO);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<Object> getProperty(String serviceId, String url, String propertyName) {
        if (CharSequenceUtil.isBlank((CharSequence)propertyName)) {
            return ApiResult.fail((String)"\u5c5e\u6027\u540d\u79f0\u4e3a\u7a7a");
        }
        ServiceInstanceClient client = this.buildServiceInstanceClient(serviceId, url);
        try {
            return client.getProperty(propertyName);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5c5e\u6027\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<ServiceInstanceClassInfoRespVO> getClass(String serviceId, String url, String className) {
        if (CharSequenceUtil.isBlank((CharSequence)className)) {
            return ApiResult.fail((String)"\u7c7b\u8def\u5f84\u4e3a\u7a7a");
        }
        ServiceInstanceClient client = this.buildServiceInstanceClient(serviceId, url);
        try {
            return client.getClass(className).map(ServiceInstanceConvert.INSTANCE::dto2RepVO);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5ba2\u6237\u7aef\u7248\u672c\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<List<ServiceInstanceThreadsRespVO>> getThreads(String serviceId, String url) {
        ServiceInstanceClient client = this.buildServiceInstanceClient(serviceId, url);
        try {
            return client.getThreadsInfo().map(ServiceInstanceConvert.INSTANCE::dto2RepVO);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7ebf\u7a0b\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<List<ServiceInstanceThreadPoolsRespVO>> getThreadPools(String serviceId, String url) {
        ServiceInstanceClient client = this.buildServiceInstanceClient(serviceId, url);
        try {
            return client.getThreadPoolsInfo().map(ServiceInstanceConvert.INSTANCE::tpDto2RepVO);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    private ServiceInstanceClient buildServiceInstanceClient(@NotBlank String serviceId, String url) {
        Assert.notBlank((CharSequence)serviceId, (String)"\u670d\u52a1ID\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (CharSequenceUtil.isBlank((CharSequence)url)) {
                return (ServiceInstanceClient)DynamicClientHelper.getClient((String)serviceId, ServiceInstanceClient.class, (String)"/secRpc/cloudt/serviceClient");
            }
            return (ServiceInstanceClient)DynamicClientHelper.buildClient((String)serviceId, ServiceInstanceClient.class, (String)"/secRpc/cloudt/serviceClient", (String)url);
        }
        catch (Exception e) {
            throw new BusinessException("\u6784\u5efa\u5ba2\u6237\u7aef\u5931\u8d25", (Throwable)e);
        }
    }
}

