/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgTemplateConfigInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(MsgTemplateConfigInitProvider.class);

    @Override
    public String typeName() {
        return "\u6d88\u606f\u6a21\u677f\u914d\u7f6e";
    }

    @Override
    public String tableName() {
        return "sys_msg_template_config";
    }

    @Override
    public List<String> fields() {
        return List.of("template_id", "template_code", "template_name", "send_type_code", "send_type_switch", "mes_subject", "mes_title", "mes_rich_content_sign", "external_template_id", "mes_text", "external_sign_name", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("template_code", "\u6a21\u677f\u7f16\u7801");
        titles.put("template_id", "\u6a21\u677fID");
        titles.put("send_type_code", "\u53d1\u9001\u7c7b\u578b");
        titles.put("send_type_code_name", "\u53d1\u9001\u7c7b\u578b\u540d\u79f0");
        titles.put("send_type_switch", "\u662f\u5426\u542f\u7528");
        titles.put("mes_subject", "\u4e3b\u9898");
        titles.put("mes_title", "\u6807\u9898");
        titles.put("mes_rich_content_sign", "\u662f\u5426\u662f\u5bcc\u6587\u672c");
        titles.put("external_template_id", "\u5916\u90e8\u6a21\u677fID");
        titles.put("mes_text", "\u5185\u5bb9");
        titles.put("external_sign_name", "\u5916\u90e8\u7b7e\u540d");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public boolean isTenantData() {
        return true;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        MsgSendTypeEnum type = MsgSendTypeEnum.parse((String)ObjectUtil.defaultIfNull((Object)data.get("send_type_code"), (Object)"").toString());
        if (type != null) {
            data.put("send_type_code_name", type.getDescription());
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        Object id;
        String tmplCode = this.getStringValue(data, "template_code", null);
        Assert.notBlank((CharSequence)tmplCode, (String)"template_code\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "send_type_switch");
        this.normalizeBooleanValue(data, "mes_rich_content_sign");
        String send_type_code = this.getStringValue(data, "send_type_code", null);
        Assert.notBlank((CharSequence)send_type_code, (String)"\u53d1\u9001\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty(lastStepData, (String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6d88\u606f\u6a21\u677f\u914d\u7f6e", (Object[])new Object[0]);
        Map tmpl = lastStepData.parallelStream().filter(t -> tmplCode.equals(t.get("template_code"))).findFirst().orElse(null);
        Assert.notNull((Object)tmpl, (String)("\u672a\u67e5\u8be2\u5230\u6a21\u677f" + tmplCode), (Object[])new Object[0]);
        Object tmplId = tmpl.get("id");
        Assert.notNull(tmplId, (String)"\u6a21\u677fID\u4e3a\u7a7a", (Object[])new Object[0]);
        data.put("template_id", tmplId);
        if (!currentData.isEmpty() && (id = currentData.parallelStream().filter(t -> tmplCode.equals(t.get("template_code")) && send_type_code.equals(t.get("send_type_code"))).findFirst().map(t -> t.get("id")).orElse(null)) != null) {
            data.put("id", id);
            return AbstractBasicDataInitProvider.UpdateType.UPDATE;
        }
        return AbstractBasicDataInitProvider.UpdateType.ADD;
    }
}

