/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.cacheable.SysCacheAppRpcService;
import com.elitescloud.cloudt.system.service.common.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.task.TaskExecutor;

public class PlatformAppInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u5e94\u7528";
    }

    @Override
    public String tableName() {
        return "sys_platform_app";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "modify_time", "app_code", "app_name", "app_type", "app_describe", "app_state", "app_order", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("app_name", "\u5e94\u7528\u540d\u79f0");
        titles.put("app_type", "\u5e94\u7528\u7c7b\u578b");
        titles.put("app_type_name", "\u5e94\u7528\u7c7b\u578b\u540d\u79f0");
        titles.put("app_order", "\u987a\u5e8f");
        titles.put("app_state", "\u72b6\u6001");
        titles.put("app_describe", "\u63cf\u8ff0");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"app_order"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean state = this.getBooleanValue(data.get("app_state"), null);
        if (state == null || !state.booleanValue()) {
            return null;
        }
        PlatformAppTypeEnum type = PlatformAppTypeEnum.parse((String)ObjectUtil.defaultIfNull((Object)data.get("app_type"), (Object)"").toString());
        if (type != null) {
            data.put("app_type_name", type.getDescription());
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String app_code = this.getStringValue(data, "app_code", null);
        Assert.notBlank((CharSequence)app_code, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "app_state");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.stream().filter(t -> app_code.equals(t.get("app_code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    @Override
    public void afterExecute(boolean export, Throwable e) {
        if (e == null || export) {
            return;
        }
        ((TaskExecutor)SpringContextHolder.getBean(TaskExecutor.class)).execute(() -> ((SysCacheAppRpcService)SpringContextHolder.getBean(SysCacheAppRpcService.class)).clearCache());
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("app_state", this.getBooleanValue(data.get("app_state"), true));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("app_state", ObjectUtil.defaultIfNull((Object)dataExists.get("app_state"), (Object)this.getBooleanValue(data.get("app_state"), true)));
    }
}

