/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlatformMenusInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "\u83dc\u5355";
    }

    @Override
    public String tableName() {
        return "sys_platform_menus";
    }

    @Override
    public List<String> fields() {
        return List.of("menus_app_code", "menus_name", "menus_type", "node_type", "menus_code", "menus_order", "menus_state", "menus_parent_code", "menus_route", "menus_describe", "menus_icon", "display", "create_time", "modify_time", "outer_link", "outer_link_type", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("menus_app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("menus_name", "\u83dc\u5355\u540d\u79f0");
        titles.put("menus_type", "\u83dc\u5355\u7c7b\u578b");
        titles.put("menus_type_name", "\u83dc\u5355\u7c7b\u578b\u540d\u79f0");
        titles.put("node_type", "\u8282\u70b9\u7c7b\u578b");
        titles.put("node_type_name", "\u8282\u70b9\u7c7b\u578b\u540d\u79f0");
        titles.put("menus_code", "\u83dc\u5355\u7f16\u7801");
        titles.put("menus_order", "\u987a\u5e8f");
        titles.put("menus_parent_code", "\u4e0a\u7ea7\u83dc\u5355\u7f16\u7801");
        titles.put("menus_route", "\u83dc\u5355\u8def\u7531");
        titles.put("menus_describe", "\u63cf\u8ff0");
        titles.put("menus_icon", "\u56fe\u6807");
        titles.put("display", "\u662f\u5426\u663e\u793a");
        titles.put("outer_link", "\u662f\u5426\u5916\u90e8\u94fe\u63a5");
        titles.put("outer_link_type", "\u5916\u90e8\u94fe\u63a5\u7c7b\u578b");
        titles.put("outer_link_type_name", "\u5916\u90e8\u94fe\u63a5\u7c7b\u578b\u540d\u79f0");
        titles.put("menus_state", "\u72b6\u6001");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"menus_parent_code"), OrderItem.asc((String)"menus_order"));
    }

    @Override
    public String fieldAppCode() {
        return "menus_app_code";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        PlatformMenusNodeEnum nodeType;
        PlatformAppMenusTypeEnum menuType;
        PlatformMenusOuterLinkTypeEnum outerLinkType;
        Boolean state = this.getBooleanValue(data.get("menus_state"), null);
        if (state == null || !state.booleanValue()) {
            return null;
        }
        PlatformMenusOuterLinkTypeEnum platformMenusOuterLinkTypeEnum = outerLinkType = data.get("outer_link_type") == null ? null : PlatformMenusOuterLinkTypeEnum.parse((String)data.get("outer_link_type").toString());
        if (outerLinkType != null) {
            data.put("outer_link_type_name", outerLinkType.getDescription());
        }
        if ((menuType = PlatformAppMenusTypeEnum.parse((String)ObjectUtil.defaultIfNull((Object)data.get("menus_type"), (Object)"").toString())) != null) {
            data.put("menus_type_name", menuType.getDescription());
        }
        if ((nodeType = PlatformMenusNodeEnum.parse((String)ObjectUtil.defaultIfNull((Object)data.get("node_type"), (Object)"").toString())) != null) {
            data.put("node_type_name", nodeType.getDescription());
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String menus_code = this.getStringValue(data, "menus_code", null);
        Assert.notBlank((CharSequence)menus_code, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "menus_state");
        this.normalizeBooleanValue(data, "outer_link");
        this.normalizeBooleanValue(data, "display");
        String outerLinkType = (String)data.get("outer_link_type");
        if (outerLinkType != null && outerLinkType.isEmpty()) {
            data.put("outer_link_type", null);
        }
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.stream().filter(t -> menus_code.equals(t.get("menus_code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("menus_state", this.getBooleanValue(data.get("menus_state"), true));
        data.put("menus_order", this.getIntegerValue(data, "menus_order", 0));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("menus_state", ObjectUtil.defaultIfNull((Object)dataExists.get("menus_state"), (Object)this.getBooleanValue(data.get("menus_state"), true)));
        data.put("menus_order", ObjectUtil.defaultIfNull((Object)dataExists.get("menus_order"), (Object)this.getIntegerValue(data, "menus_order", 0)));
    }
}

