/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlatformUdcInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "UDC";
    }

    @Override
    public String tableName() {
        return "sys_platform_udc";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "modify_time", "app_code", "udc_code", "udc_name", "allow_update", "allow_add_value", "udc_describe", "parent_udc_code", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("udc_code", "UDC\u7f16\u7801");
        titles.put("udc_name", "UDC\u540d\u79f0");
        titles.put("allow_update", "\u662f\u5426\u5141\u8bb8\u7f16\u8f91");
        titles.put("allow_add_value", "\u662f\u5426\u5141\u8bb8\u65b0\u589e\u503c");
        titles.put("udc_describe", "\u63cf\u8ff0");
        titles.put("parent_udc_code", "\u4e0a\u7ea7UDC\u7f16\u7801");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"app_code"), OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String app_code = this.getStringValue(data, "app_code", null);
        Assert.notBlank((CharSequence)app_code, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String udc_code = this.getStringValue(data, "udc_code", null);
        Assert.notBlank((CharSequence)udc_code, (String)"UDC\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "allow_update");
        this.normalizeBooleanValue(data, "allow_add_value");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Object id = currentData.parallelStream().filter(t -> app_code.equals(t.get("app_code")) && udc_code.equals(t.get("udc_code"))).findFirst().map(t -> t.get("id")).orElse(null);
        data.put("id", id);
        return id == null ? AbstractBasicDataInitProvider.UpdateType.ADD : AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }
}

