/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.task.TaskExecutor;

public class PlatformUdcValueInitProvider
extends AbstractBasicDataInitProvider {
    @Override
    public String typeName() {
        return "UDC\u503c";
    }

    @Override
    public String tableName() {
        return "sys_platform_udc_value";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "modify_time", "app_code", "udc_code", "udc_value_code", "udc_value_name", "value_alias_name", "udc_order", "allow_start", "udc_value_describe", "allow_default", "parent_udc_value_code", "std_version");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("udc_code", "UDC\u7f16\u7801");
        titles.put("udc_value_code", "\u503c\u7f16\u7801");
        titles.put("udc_value_name", "\u503c\u540d\u79f0");
        titles.put("value_alias_name", "\u522b\u540d");
        titles.put("udc_order", "\u987a\u5e8f");
        titles.put("allow_start", "\u662f\u5426\u542f\u7528");
        titles.put("udc_value_describe", "\u63cf\u8ff0");
        titles.put("allow_default", "\u662f\u5426\u5185\u7f6e");
        titles.put("parent_udc_value_code", "\u4e0a\u7ea7UDC\u503c");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"app_code"), OrderItem.asc((String)"udc_code"), OrderItem.asc((String)"udc_order"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String app_code = this.getStringValue(data, "app_code", null);
        Assert.notBlank((CharSequence)app_code, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String udc_code = this.getStringValue(data, "udc_code", null);
        Assert.notBlank((CharSequence)udc_code, (String)"UDC\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String value_code = this.getStringValue(data, "udc_value_code", null);
        Assert.notBlank((CharSequence)value_code, (String)"\u503c\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "allow_start");
        this.normalizeBooleanValue(data, "allow_default");
        if (currentData.isEmpty()) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.parallelStream().filter(t -> app_code.equals(t.get("app_code")) && udc_code.equals(t.get("udc_code")) && value_code.equals(t.get("udc_value_code"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    @Override
    public void afterExecute(boolean export, Throwable e) {
        if (e == null || export) {
            return;
        }
        ((TaskExecutor)SpringContextHolder.getBean(TaskExecutor.class)).execute(() -> {
            SysTenantBasicDataService tenantBasicDataService = (SysTenantBasicDataService)SpringContextHolder.getBean(SysTenantBasicDataService.class);
            ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getAllTenants().forEach(tenant -> tenantBasicDataService.syncUdc(tenant.getId()));
        });
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("udc_order", this.getIntegerValue(data, "udc_order", 0));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("udc_order", ObjectUtil.defaultIfNull((Object)dataExists.get("udc_order"), (Object)this.getIntegerValue(data, "udc_order", 0)));
        data.put("value_alias_name", CharSequenceUtil.blankToDefault((CharSequence)this.getStringValue(dataExists, "value_alias_name", ""), (String)this.getStringValue(data, "value_alias_name", "")));
    }
}

