/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.system.constant.SysNoticeCategory;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseNoticeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseNoticeListRespVO;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import com.elitescloud.cloudt.system.service.repo.NoticeRepoProc;
import com.elitescloud.cloudt.system.service.repo.NoticeTxtRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

abstract class BaseNoticeService
extends BaseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(BaseNoticeService.class);
    @Autowired
    protected NoticeRepoProc repoProc;
    @Autowired
    protected NoticeTxtRepoProc txtRepoProc;
    @Autowired
    protected UserRepoProc userRepoProc;
    @Autowired
    protected FileService fileService;

    BaseNoticeService() {
    }

    protected <T extends BaseNoticeDetailRespVO> void fillDetailInfo(SysNoticeDO noticeDO, T noticeVO) {
        if (noticeDO.getTxtId() != null) {
            noticeVO.setTxt(this.txtRepoProc.getTxt(noticeDO.getTxtId()));
        }
        if (noticeVO.getAuthorId() != null) {
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                noticeVO.setAuthorName(this.userRepoProc.queryUserName(noticeVO.getAuthorId()));
                return null;
            });
        }
        noticeVO.setCategoryName(super.udcValue((BaseUdc)new SysNoticeCategory(noticeVO.getCategory())));
        if (StringUtils.hasText((String)noticeDO.getFileCodesStr())) {
            ApiResult fileResult = this.fileService.query(Arrays.asList(noticeDO.getFileCodesStr().split(",")));
            if (!fileResult.isSuccess()) {
                log.error("\u67e5\u8be2\u9644\u4ef6\u5f02\u5e38\uff1a{}, {}", (Object)noticeDO.getFileCodesStr(), (Object)fileResult.getMsg());
            }
            noticeVO.setFiles((List)fileResult.getData());
        }
    }

    protected <T extends BaseNoticeListRespVO> void fillListInfo(List<T> noticeList) {
        Set authorIds = noticeList.stream().map(BaseNoticeListRespVO::getAuthorId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map authorMap = authorIds.isEmpty() ? Collections.emptyMap() : ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.queryUserName(authorIds))).stream().collect(Collectors.toMap(IdNameParam::getId, Function.identity(), (t1, t2) -> t1));
        Map categoryNameMap = super.udcMap((BaseUdc)new SysNoticeCategory());
        noticeList.forEach(t -> {
            ObjUtil.ifNotNull((Object)((IdNameParam)authorMap.get(t.getAuthorId())), a -> t.setAuthorName(a.getName()));
            t.setCategoryName((String)categoryNameMap.get(t.getCategory()));
        });
    }
}

