/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataRelationConvert;
import com.elitescloud.cloudt.system.dto.req.DataRelationQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.DataRelationRespDTO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonDataRelationQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonDataRelationRespVO;
import com.elitescloud.cloudt.system.service.DataRelationInstQueryService;
import com.elitescloud.cloudt.system.service.manager.DataRelationManager;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataRelationInstQueryServiceImpl
implements DataRelationInstQueryService {
    @Autowired
    private DataRelationManager manager;

    @Override
    public ApiResult<List<DataRelationRespDTO>> query(DataRelationQueryDTO queryDTO) {
        List<DataRelationRespDTO> result = this.queryData(queryDTO, false);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<DataRelationRespDTO>> queryByRefData(DataRelationQueryDTO queryDTO) {
        List<DataRelationRespDTO> result = this.queryData(queryDTO, true);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<CommonDataRelationRespVO>> query(CommonDataRelationQueryVO queryVO) {
        List<CommonDataRelationRespVO> result = this.queryData(queryVO, false);
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<CommonDataRelationRespVO>> queryByRefData(CommonDataRelationQueryVO queryVO) {
        List<CommonDataRelationRespVO> result = this.queryData(queryVO, true);
        return ApiResult.ok(result);
    }

    private List<DataRelationRespDTO> queryData(DataRelationQueryDTO queryDTO, boolean byRef) {
        DataRelationInstQueryBO queryBO = DataRelationConvert.INSTANCE.queryDto2Bo(queryDTO);
        return this.manager.queryValues(queryBO, byRef).stream().map(DataRelationConvert.INSTANCE::valueBo2Dto).collect(Collectors.toList());
    }

    private List<CommonDataRelationRespVO> queryData(CommonDataRelationQueryVO queryVO, boolean byRef) {
        DataRelationInstQueryBO queryBO = DataRelationConvert.INSTANCE.queryVo2Bo(queryVO);
        return this.manager.queryValues(queryBO, byRef).stream().map(DataRelationConvert.INSTANCE::valueBo2Vo).collect(Collectors.toList());
    }
}

