/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataSelectorConverter;
import com.elitescloud.cloudt.system.model.vo.query.sys.DataSelectorPagedQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.DataSelectorPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.sys.DataSelectorSaveVO;
import com.elitescloud.cloudt.system.service.DataSelectorMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysDataSelectorDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataSelectorGroupDO;
import com.elitescloud.cloudt.system.service.repo.DataSelectorGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataSelectorMngServiceImpl
implements DataSelectorMngService {
    @Autowired
    private DataSelectorRepoProc repoProc;
    @Autowired
    private DataSelectorGroupRepoProc groupRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveGroup(DataSelectorGroupSaveVO saveVO) {
        SysDataSelectorGroupDO groupDO = null;
        try {
            groupDO = this.checkAndConvert(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.groupRepoProc.save((Serializable)groupDO);
        return ApiResult.ok((Object)groupDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> deleteGroup(String groupCode) {
        Assert.notBlank((CharSequence)groupCode, (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean exists = this.repoProc.existsGroup(groupCode);
        if (exists) {
            return ApiResult.fail((String)"\u8bf7\u5148\u5220\u9664\u5206\u7ec4\u4e0b\u7684\u6570\u636e");
        }
        this.groupRepoProc.deleteByGroupCode(groupCode);
        return ApiResult.ok((Object)groupCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateGroupEnabled(String groupCode, Boolean enabled) {
        Assert.notBlank((CharSequence)groupCode, (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)enabled, (String)"\u542f\u7528\u72b6\u6001\u4e3a\u7a7a", (Object[])new Object[0]);
        this.groupRepoProc.updateEnabled(groupCode, (boolean)enabled);
        return ApiResult.ok((Object)groupCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateGroupName(String groupCode, String name) {
        Assert.notBlank((CharSequence)groupCode, (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        this.groupRepoProc.updateGroupName(groupCode, name);
        return ApiResult.ok((Object)groupCode);
    }

    @Override
    public ApiResult<DataSelectorGroupDetailRespVO> getGroupDetail(String groupCode) {
        Assert.notNull((Object)groupCode, (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        SysDataSelectorGroupDO groupDO = this.groupRepoProc.getByGroupCode(groupCode);
        if (groupDO == null) {
            return ApiResult.fail((String)"\u5206\u7ec4\u4fe1\u606f\u4e3a\u7a7a");
        }
        DataSelectorGroupDetailRespVO respVO = DataSelectorConverter.INSTANCE.do2RespVO(groupDO);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listGroup() {
        List<IdCodeNameParam> dataList = this.groupRepoProc.listGroup();
        return ApiResult.ok(dataList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(DataSelectorSaveVO saveVO) {
        SysDataSelectorDO selectorDO = null;
        try {
            selectorDO = this.checkAndConvert(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.repoProc.save((Serializable)selectorDO);
        return ApiResult.ok((Object)selectorDO.getId());
    }

    @Override
    public ApiResult<DataSelectorDetailRespVO> getDetail(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysDataSelectorDO selectorDO = (SysDataSelectorDO)this.repoProc.get(id);
        if (selectorDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        DataSelectorDetailRespVO respVO = DataSelectorConverter.INSTANCE.do2DetailRespVO(selectorDO);
        if (StringUtils.hasText((String)respVO.getGroupCode())) {
            respVO.setGroupName(this.groupRepoProc.getNameByCode(respVO.getGroupCode()));
        }
        respVO.setApiHeaders((Map)JSONUtil.json2Obj((String)selectorDO.getApiHeadersJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        respVO.setApiReqBody((Map)JSONUtil.json2Obj((String)selectorDO.getApiReqBodyJson(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
        respVO.setApiReqParams((Map)JSONUtil.json2Obj((String)selectorDO.getApiReqParamsJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}));
        respVO.setDataFields(StringUtils.hasText((String)selectorDO.getDataFieldsStr()) ? Arrays.stream(selectorDO.getDataFieldsStr().split(",")).collect(Collectors.toList()) : Collections.emptyList());
        respVO.setExtAttributes((Map)JSONUtil.json2Obj((String)selectorDO.getExtAttributesJson(), (TypeReference)new TypeReference<HashMap<String, Object>>(){}));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<DataSelectorPagedRespVO>> pageMng(DataSelectorPagedQueryVO queryVO) {
        PagingVO<DataSelectorPagedRespVO> pageData = this.repoProc.pageMng(queryVO);
        return ApiResult.ok(pageData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        this.repoProc.updateEnabled(id, enabled == null || enabled != false);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> delete(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ID\u4e3a\u7a7a", (Object[])new Object[0]);
        this.repoProc.delete(ids);
        return ApiResult.ok((Object)true);
    }

    private SysDataSelectorDO checkAndConvert(DataSelectorSaveVO saveVO) {
        SysDataSelectorDO selectorDO = null;
        if (StringUtils.hasText((String)saveVO.getGroupCode())) {
            Assert.isTrue((boolean)this.groupRepoProc.existsCode(saveVO.getGroupCode()), (String)"\u5206\u7ec4\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        } else {
            saveVO.setGroupCode("");
        }
        Assert.notBlank((CharSequence)saveVO.getSelectorCode(), (String)"\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveVO.getId() == null) {
            selectorDO = new SysDataSelectorDO();
            Assert.isTrue((!this.repoProc.existsCode(saveVO.getSelectorCode()) ? 1 : 0) != 0, (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        } else {
            selectorDO = (SysDataSelectorDO)this.repoProc.get(saveVO.getId());
            Assert.notNull((Object)selectorDO, (String)"\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Assert.isTrue((boolean)selectorDO.getSelectorCode().equals(saveVO.getSelectorCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[0]);
        }
        ObjUtil.ifNull((Object)saveVO.getEnabled(), (Object)true, saveVO::setEnabled);
        Assert.notNull((Object)saveVO.getComponent(), (String)"\u672a\u660e\u786e\u662f\u5426\u4f7f\u7528\u7684\u662f\u7ec4\u4ef6", (Object[])new Object[0]);
        if (saveVO.getComponent().booleanValue()) {
            Assert.notBlank((CharSequence)saveVO.getComponentCode(), (String)"\u7ec4\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        } else {
            Assert.notBlank((CharSequence)saveVO.getDataApi(), (String)"\u6570\u636e\u63a5\u53e3API\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)saveVO.getDataApiMethod(), (String)"\u6570\u636e\u63a5\u53e3API\u8bf7\u6c42\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (CollUtil.isNotEmpty(saveVO.getDataFields())) {
            saveVO.setDataFields(saveVO.getDataFields().stream().filter(StringUtils::hasText).distinct().collect(Collectors.toList()));
        }
        if (saveVO.getValueNumLimit() == null) {
            saveVO.setValueNumLimit(-1);
        }
        DataSelectorConverter.INSTANCE.copy(saveVO, selectorDO);
        selectorDO.setApiHeadersJson(JSONUtil.toJsonString(saveVO.getApiHeaders()));
        selectorDO.setApiReqBodyJson(JSONUtil.toJsonString(saveVO.getApiReqBody()));
        selectorDO.setApiReqParamsJson(JSONUtil.toJsonString(saveVO.getApiReqParams()));
        selectorDO.setExtAttributesJson(JSONUtil.toJsonString(saveVO.getExtAttributes()));
        selectorDO.setDataFieldsStr(CollUtil.isEmpty(saveVO.getDataFields()) ? null : String.join((CharSequence)",", saveVO.getDataFields()));
        return selectorDO;
    }

    private SysDataSelectorGroupDO checkAndConvert(DataSelectorGroupSaveVO saveVO) {
        SysDataSelectorGroupDO groupDO = null;
        Assert.notBlank((CharSequence)saveVO.getGroupCode(), (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        if (saveVO.getId() == null) {
            groupDO = new SysDataSelectorGroupDO();
            groupDO.setGroupCode(saveVO.getGroupCode());
            Assert.isTrue((!this.groupRepoProc.existsCode(saveVO.getGroupCode()) ? 1 : 0) != 0, (String)"\u5206\u7ec4\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        } else {
            groupDO = (SysDataSelectorGroupDO)this.groupRepoProc.get(saveVO.getId());
            Assert.notNull((Object)groupDO, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Assert.isTrue((boolean)saveVO.getGroupCode().equals(groupDO.getGroupCode()), (String)"\u5206\u7ec4\u7f16\u7801\u4e0d\u53ef\u4fee\u6539", (Object[])new Object[0]);
        }
        ObjUtil.ifNull((Object)saveVO.getEnabled(), (Object)true, saveVO::setEnabled);
        ObjUtil.ifNull((Object)saveVO.getSortNo(), (Object)0, saveVO::setSortNo);
        DataSelectorConverter.INSTANCE.copyGroup(saveVO, groupDO);
        return groupDO;
    }
}

