/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.cacheable.SysCacheEmployeeGroupRpcService;
import com.elitescloud.cloudt.system.constant.SysEmpGroupType;
import com.elitescloud.cloudt.system.convert.EmpGroupConvert;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupEmpPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupEmpPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmpGroupSaveVO;
import com.elitescloud.cloudt.system.service.EmpGroupMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupEmpDO;
import com.elitescloud.cloudt.system.service.repo.EmpGroupEmpRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmpGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class EmpGroupMngServiceImpl
extends BaseServiceImpl
implements EmpGroupMngService {
    private static final EmpGroupConvert CONVERT = EmpGroupConvert.INSTANCE;
    @Autowired
    private EmpGroupRepoProc repoProc;
    @Autowired
    private EmpGroupEmpRepoProc empGroupEmpRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private SysCacheEmployeeGroupRpcService cacheEmployeeGroupRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(EmpGroupSaveVO saveVO) {
        SysEmpGroupDO groupDO;
        try {
            groupDO = saveVO.getId() == null ? this.convertForInsert(saveVO) : this.convertForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.repoProc.save((Serializable)groupDO);
        this.clearCache();
        return ApiResult.ok((Object)groupDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.repoProc.delete(id);
        this.empGroupEmpRepoProc.deleteEmployeeByGroupId(id);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.repoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.repoProc.updateEnabled(id, enabled);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addEmployee(Long id, Long employeeId) {
        List<Long> empIdExists = this.empGroupEmpRepoProc.getEmployeeIdOfGroup(id);
        if (empIdExists.contains(employeeId)) {
            return ApiResult.ok((Object)id);
        }
        SysEmpGroupEmpDO empGroupEmpDO = new SysEmpGroupEmpDO();
        empGroupEmpDO.setGroupId(id);
        empGroupEmpDO.setEmpId(employeeId);
        this.empGroupEmpRepoProc.save((Serializable)empGroupEmpDO);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteEmployee(Long id, Long employeeId) {
        this.empGroupEmpRepoProc.deleteEmployeeByGroupId(id, employeeId);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<PagingVO<EmpGroupPageRespVO>> page(EmpGroupPageQueryVO queryVO) {
        PagingVO<SysEmpGroupDO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(CONVERT::do2PageRespVO));
        }
        Map typeNames = super.udcMap((BaseUdc)new SysEmpGroupType());
        PagingVO result = pageData.map(t -> {
            EmpGroupPageRespVO vo = CONVERT.do2PageRespVO((SysEmpGroupDO)t);
            vo.setTypeName((String)typeNames.get(t.getType()));
            return vo;
        });
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<EmpGroupDetailRespVO> get(Long id) {
        return this.repoProc.getOptional(id).map(t -> {
            EmpGroupDetailRespVO vo = CONVERT.do2DetailRespVO((SysEmpGroupDO)t);
            vo.setTypeName(super.udcValue((BaseUdc)new SysEmpGroupType(t.getType())));
            return vo;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    @Override
    public ApiResult<PagingVO<EmpGroupEmpPageRespVO>> pageEmp(EmpGroupEmpPageQueryVO queryVO) {
        PagingVO<EmpGroupEmpPageRespVO> pageData = this.empGroupEmpRepoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData);
        }
        Set userIds = pageData.stream().map(EmpGroupEmpPageRespVO::getUserId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map usernameMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.getUsernameAndId(userIds));
        pageData.each(t -> t.setUsername((String)usernameMap.get(t.getUserId())));
        return ApiResult.ok(pageData);
    }

    private void clearCache() {
        this.cacheEmployeeGroupRpcService.clearCache();
    }

    private SysEmpGroupDO convertForInsert(EmpGroupSaveVO saveVO) {
        boolean exists = this.repoProc.existsCode(saveVO.getCode(), null);
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        if (saveVO.getSortNo() == null) {
            saveVO.setSortNo(1);
        }
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        return CONVERT.saveVo2DO(saveVO);
    }

    private SysEmpGroupDO convertForUpdate(EmpGroupSaveVO saveVO) {
        SysEmpGroupDO groupDO = (SysEmpGroupDO)this.repoProc.get(saveVO.getId());
        Assert.notNull((Object)groupDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        if (!groupDO.getCode().equals(saveVO.getCode())) {
            boolean exists = this.repoProc.existsCode(saveVO.getCode(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        }
        if (saveVO.getSortNo() == null) {
            saveVO.setSortNo(1);
        }
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        return CONVERT.copySaveVo2DO(saveVO, groupDO);
    }
}

