/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeOrgRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.model.bo.EmployeeOrgBO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonEmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeeListQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.impl.EmployeeBaseServiceImpl;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class EmployeeQueryServiceImpl
extends EmployeeBaseServiceImpl
implements EmployeeQueryService {
    private static final Logger log = LogManager.getLogger(EmployeeQueryServiceImpl.class);
    private static final EmployeeConvert CONVERT = EmployeeConvert.INSTANCE;
    @Autowired
    private EmployeeRepoProc repoProc;
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private AreaQueryService areaQueryService;
    @Autowired
    private PermissionQueryManager permissionQueryManager;

    @Override
    public ApiResult<PagingVO<EmployeePagedRespVO>> pageQuery(CommonEmployeePageQueryVO queryVO) {
        Set<Long> userIdsOfDisabled;
        Map<Long, SysUserBasicDTO> userFilterMap = this.queryUser(queryVO);
        if (userFilterMap != null && userFilterMap.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Set<Long> userIds = userFilterMap == null ? null : userFilterMap.keySet();
        PagingVO<EmployeePagedRespVO> pageData = this.repoProc.pageQuery(queryVO, userIds, userIdsOfDisabled = userIds == null && queryVO.getEnabled() != null ? this.queryDisabledUserIds() : null);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.builder().total(pageData.getTotal()).build());
        }
        Map employeeTypeMap = this.udcMap((BaseUdc)new EmployeeType());
        List<Long> ids = pageData.stream().map(EmployeePagedRespVO::getId).collect(Collectors.toList());
        userIds = pageData.stream().map(EmployeePagedRespVO::getUserId).filter(t -> t != null && t != -1L).collect(Collectors.toSet());
        Map orgMap = Boolean.TRUE.equals(queryVO.getWithOrg()) ? this.employeeOrgRepoProc.getEmployeeOrgs(ids, true) : Collections.emptyMap();
        Map roleMap = Boolean.TRUE.equals(queryVO.getWithRole()) ? this.permissionQueryManager.queryUserRoles(userIds) : Collections.emptyMap();
        pageData.each(t -> {
            if (StringUtils.hasText((String)t.getType())) {
                t.setTypeName((String)employeeTypeMap.get(t.getType()));
            }
            t.setOrgNameList(orgMap.getOrDefault(t.getId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
            t.setRoleNameList(roleMap.getOrDefault(t.getUserId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
            t.setWithoutLoginAccount(t.getUserId() == null || t.getUserId() == -1L);
        });
        this.fillUserInfo(pageData.getRecords(), userFilterMap);
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(EmployeePageQueryDTO queryDTO) {
        Map<Object, Object> groupedByEmployeeId;
        Map parentOrgMap;
        Map<Object, Object> employeeOrgMap;
        boolean withOrg;
        Set<Long> userIds = null;
        Map<Long, SysUserBasicDTO> userFilterMap = null;
        Set<Long> userIdsOfDisabled = userIds == null && queryDTO.getEnabled() != null ? this.queryDisabledUserIds() : null;
        PagingVO<EmployeePageRespDTO> pageData = this.repoProc.pageQuery(queryDTO, userIds, userIdsOfDisabled);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.builder().total(pageData.getTotal()).build());
        }
        boolean bl = withOrg = queryDTO.getWithoutOrg() == null || queryDTO.getWithoutOrg() == false || StringUtils.hasText((String)queryDTO.getWithParentOrgType());
        if (withOrg) {
            List<Long> ids = pageData.stream().map(EmployeePageRespDTO::getId).collect(Collectors.toList());
            employeeOrgMap = this.employeeOrgRepoProc.getEmployeeOrgs(ids, true);
            Set<Long> orgIds = CharSequenceUtil.isBlank((CharSequence)queryDTO.getWithParentOrgType()) ? Collections.emptySet() : employeeOrgMap.values().stream().flatMap(Collection::stream).map(IdCodeNameParam::getId).collect(Collectors.toSet());
            Map<Object, Object> map = parentOrgMap = orgIds.isEmpty() ? Collections.emptyMap() : this.orgRepoProc.queryParentNameForType(orgIds, queryDTO.getWithParentOrgType(), true);
            if (Boolean.TRUE.equals(queryDTO.getWithLeader())) {
                List<EmployeeOrgBO> empLeadersMap = this.employeeOrgRepoProc.getLeaders(ids);
                List employeeOrgRespDTOList = empLeadersMap.stream().map(employeeOrgBO -> {
                    EmployeeOrgRespDTO employeeOrgRespDTO = new EmployeeOrgRespDTO();
                    employeeOrgRespDTO.setOwnerId(employeeOrgBO.getOwnerId());
                    employeeOrgRespDTO.setOrgId(employeeOrgBO.getOrgId());
                    employeeOrgRespDTO.setOrgName(employeeOrgBO.getOrgName());
                    employeeOrgRespDTO.setEmployeeId(employeeOrgBO.getEmployeeId());
                    employeeOrgRespDTO.setEmployeeCode(employeeOrgBO.getEmployeeCode());
                    employeeOrgRespDTO.setEmployeeName(employeeOrgBO.getLastName());
                    employeeOrgRespDTO.setEmployeeType(employeeOrgBO.getEmployeeType());
                    return employeeOrgRespDTO;
                }).collect(Collectors.toList());
                groupedByEmployeeId = employeeOrgRespDTOList.stream().collect(Collectors.groupingBy(EmployeeOrgRespDTO::getOwnerId));
            } else {
                groupedByEmployeeId = Collections.emptyMap();
            }
        } else {
            employeeOrgMap = Collections.emptyMap();
            parentOrgMap = Collections.emptyMap();
            groupedByEmployeeId = Collections.emptyMap();
        }
        Map employeeTypeMap = super.udcMap((BaseUdc)new EmployeeType());
        pageData.each(t -> {
            if (StringUtils.hasText((String)t.getType())) {
                t.setTypeName((String)employeeTypeMap.get(t.getType()));
            }
            if (withOrg) {
                t.setOrgList(employeeOrgMap.getOrDefault(t.getId(), Collections.emptyList()));
                t.setOrgNames(employeeOrgMap.getOrDefault(t.getId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
                ArrayList<IdCodeNameParam> parentOrgList = new ArrayList<IdCodeNameParam>();
                for (IdCodeNameParam idCodeNameParam : t.getOrgList()) {
                    parentOrgList.add((IdCodeNameParam)parentOrgMap.get(idCodeNameParam.getId()));
                }
                t.setParentOrgList(parentOrgList);
                t.setLeadEmployeeOrg((List)groupedByEmployeeId.get(t.getId()));
            }
            t.setWithoutLoginAccount(Boolean.valueOf(t.getUserId() == null || t.getUserId() == -1L));
        });
        this.fillUserInfoDTO(pageData, userFilterMap);
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<List<String>> getSalesmanId(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        Long userId = this.repoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        return this.getSalesmanIdByUserId(userId);
    }

    @Override
    public ApiResult<List<String>> getSalesmanIdByUserId(Long userId) {
        if (userId == null) {
            return ApiResult.fail((String)"\u8d26\u53f7ID\u4e3a\u7a7a");
        }
        List userTypes = (List)this.userQueryService.getUserTypes(userId).computeData();
        if (userTypes.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set salesmanIds = userTypes.stream().filter(t -> UserType.SALESMAN.getValue().equals(t.getUserType())).map(SysUserTypeDTO::getIdentityId).collect(Collectors.toSet());
        return ApiResult.ok(new ArrayList(salesmanIds));
    }

    @Override
    public ApiResult<List<EmployeeListRespVO>> listQuery(EmployeeListQueryVO queryVO) {
        List<EmployeeListRespVO> employeeList = this.repoProc.listQuery(queryVO);
        for (EmployeeListRespVO employee : employeeList) {
            employee.setWithoutLoginAccount(employee.getUserId() == null || employee.getUserId() == -1L);
        }
        return ApiResult.ok(employeeList);
    }

    @Override
    public ApiResult<String> getCode(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        String code = this.repoProc.getCode(id);
        return ApiResult.ok((Object)code);
    }

    @Override
    public ApiResult<Long> getUserId(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        Long userId = this.repoProc.getUserId(id);
        return ApiResult.ok((Object)userId);
    }

    @Override
    public ApiResult<String> getUsername(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        String username = this.repoProc.getUsername(id);
        return ApiResult.ok((Object)username);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getById(Long id) {
        Assert.notNull((Object)id, (String)"\u5458\u5de5ID\u4e3a\u7a7a");
        return this.repoProc.getOptional(id).map(t -> {
            SysEmployeeBasicDTO dto = CONVERT.do2BasicDto((SysEmployeeDO)t);
            this.fillTenantUserInfo(dto);
            return dto;
        }).map(ApiResult::ok).orElse(ApiResult.ok(null));
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByCode(String code) {
        Assert.hasText((String)code, (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        return this.repoProc.getByCode(code).map(t -> {
            SysEmployeeBasicDTO dto = CONVERT.do2BasicDto((SysEmployeeDO)t);
            this.fillTenantUserInfo(dto);
            return dto;
        }).map(ApiResult::ok).orElse(ApiResult.ok(null));
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByUsername(String username) {
        Assert.hasText((String)username, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        Long userId = super.userRepoCall(repo -> repo.getIdByUsername(username));
        if (userId == null) {
            return ApiResult.ok();
        }
        return this.getByUserId(userId);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByUserId(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        return this.repoProc.getByUserId(userId).map(t -> {
            SysEmployeeBasicDTO dto = CONVERT.do2BasicDto((SysEmployeeDO)t);
            this.fillTenantUserInfo(dto);
            return dto;
        }).map(ApiResult::ok).orElse(ApiResult.ok(null));
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailById(Long id) {
        Assert.notNull((Object)id, (String)"\u5458\u5de5ID\u4e3a\u7a7a");
        SysEmployeeDO employee = (SysEmployeeDO)this.repoProc.get(id);
        if (employee == null) {
            return ApiResult.ok();
        }
        List<SysEmployeeDetailDTO> employeeList = this.convertToEmployeeDetail(List.of(employee));
        return ApiResult.ok((Object)employeeList.get(0));
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByCode(String code) {
        Assert.hasText((String)code, (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        SysEmployeeDO employee = this.repoProc.getByCode(code).orElse(null);
        if (employee == null) {
            return ApiResult.ok();
        }
        List<SysEmployeeDetailDTO> employeeList = this.convertToEmployeeDetail(List.of(employee));
        return ApiResult.ok((Object)employeeList.get(0));
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByUserId(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        SysEmployeeDO employee = this.repoProc.getByUserId(userId).orElse(null);
        if (employee == null) {
            return ApiResult.ok();
        }
        List<SysEmployeeDetailDTO> employeeList = this.convertToEmployeeDetail(List.of(employee));
        return ApiResult.ok((Object)employeeList.get(0));
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByUsername(String username) {
        Assert.hasText((String)username, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        Long userId = super.userRepoCall(repo -> repo.getIdByUsername(username));
        if (userId == null) {
            return ApiResult.ok(null);
        }
        return this.getDetailByUserId(userId);
    }

    @Override
    public ApiResult<List<SysEmployeeDetailDTO>> getDetailListByCode(Set<String> codes) {
        Assert.notEmpty(codes, (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        List<SysEmployeeDO> employeeList = this.repoProc.getByCode(codes);
        List<SysEmployeeDetailDTO> employeeDtoList = this.convertToEmployeeDetail(employeeList);
        return ApiResult.ok(employeeDtoList);
    }

    @Override
    public ApiResult<List<EmployeeUnderlingDTO>> getUnderlingByCode(String code, Boolean cascade, Boolean enabled) {
        Assert.hasText((String)code, (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        cascade = cascade != null && cascade != false;
        Long id = this.repoProc.getIdByCode(code);
        if (id == null) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<EmployeeOrgBO> underlingList = this.employeeOrgRepoProc.getUnderlings(Set.of(id), enabled);
        if (underlingList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map typeMap = super.udcMap((BaseUdc)new EmployeeType());
        List<EmployeeUnderlingDTO> dtoList = this.queryUnderling(underlingList, cascade, enabled, typeMap);
        return ApiResult.ok(dtoList);
    }

    @Override
    public ApiResult<List<SysUnderlingDTO>> getUnderlingId(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        List<EmployeeOrgBO> underlingList = this.employeeOrgRepoProc.getUnderlings(Set.of(id), true);
        if (underlingList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List underlingDtoList = underlingList.stream().map(t -> {
            SysUnderlingDTO underlingDTO = new SysUnderlingDTO();
            underlingDTO.setUserId(t.getUserId());
            underlingDTO.setEmployeeId(t.getEmployeeId());
            underlingDTO.setDirectly(Boolean.valueOf(true));
            return underlingDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok(underlingDtoList);
    }

    @Override
    public ApiResult<List<SysEmployeeBasicDTO>> queryList(EmployeeQueryDTO queryDTO) {
        Set<Object> userIds = queryDTO.getUserIds();
        if (!CollectionUtils.isEmpty((Collection)queryDTO.getUsernames())) {
            List tempUserIds = super.userRepoCall(repo -> repo.getIdByUsername(queryDTO.getUsernames()));
            if (tempUserIds.isEmpty()) {
                return ApiResult.ok(Collections.emptyList());
            }
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                userIds = new HashSet(tempUserIds);
            } else if ((userIds = userIds.stream().filter(tempUserIds::contains).collect(Collectors.toSet())).isEmpty()) {
                return ApiResult.ok(Collections.emptyList());
            }
        }
        queryDTO.setUserIds((Set)userIds);
        List recordList = this.repoProc.queryList(queryDTO).stream().map(CONVERT::do2BasicDto).collect(Collectors.toList());
        return ApiResult.ok(recordList);
    }

    @Override
    public ApiResult<List<Long>> getUserIdByLeaderUserId(Long leaderUserId) {
        List<Long> userIds = this.employeeOrgRepoProc.getUserIdByLeaderUserId(leaderUserId);
        return ApiResult.ok(userIds);
    }

    @Override
    public ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeOrgs(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Map<Long, List<IdCodeNameParam>> data = this.employeeOrgRepoProc.getEmployeeOrgs(ids, true);
        return ApiResult.ok(data);
    }

    @Override
    public ApiResult<Boolean> existsCode(String code) {
        Assert.hasText((String)code, (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
        boolean result = this.repoProc.existsCode(code);
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryCodeName(Set<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        List<IdCodeNameParam> employeeNames = this.repoProc.queryEmployeeName(ids);
        return ApiResult.ok(employeeNames);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryCodeNameByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return ApiResult.fail((String)"Code\u4e3a\u7a7a");
        }
        List<IdCodeNameParam> employeeNames = this.repoProc.queryEmployeeNameByCodes(codes);
        return ApiResult.ok(employeeNames);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> queryCodeNameByUserId(Set<Long> userIds) {
        if (CollUtil.isEmpty(userIds)) {
            return ApiResult.fail((String)"userId\u4e3a\u7a7a");
        }
        List<IdCodeNameParam> employeeNames = this.repoProc.queryEmployeeNameByUserIds(userIds);
        return ApiResult.ok(employeeNames);
    }

    private Map<Long, SysUserBasicDTO> queryUser(CommonEmployeePageQueryVO queryVO) {
        UserQueryDTO queryDTO = new UserQueryDTO();
        boolean flag = false;
        if (StringUtils.hasText((String)queryVO.getUsername())) {
            queryDTO.setUsernameLike(Set.of(queryVO.getUsername()));
            flag = true;
        }
        if (queryVO.getEnabled() != null) {
            queryDTO.setEnabled(queryVO.getEnabled());
        }
        if (!flag) {
            return null;
        }
        List users = this.userRepoCall(repo -> repo.queryBasicDto(queryDTO));
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        return users.stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
    }

    private Set<Long> queryDisabledUserIds() {
        return new HashSet<Long>(this.userRepoCall(UserRepoProc::queryIdsOfDisabled));
    }

    private Map<Long, SysUserBasicDTO> queryUser(EmployeePageQueryDTO queryDTO) {
        UserQueryDTO param = new UserQueryDTO();
        boolean flag = false;
        if (StringUtils.hasText((String)queryDTO.getUsername())) {
            param.setUsernameLike(Set.of(queryDTO.getUsername()));
            flag = true;
        }
        if (CollUtil.isNotEmpty((Collection)queryDTO.getUserIds())) {
            param.setUserIds(queryDTO.getUserIds());
            flag = true;
        }
        if (CollUtil.isNotEmpty((Collection)queryDTO.getUsernames())) {
            param.setUsernames(queryDTO.getUsernames());
            flag = true;
        }
        if (queryDTO.getEnabled() != null) {
            param.setEnabled(queryDTO.getEnabled());
        }
        if (!flag) {
            return null;
        }
        List users = this.userRepoCall(repo -> repo.queryBasicDto(param));
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        return users.stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
    }

    private List<EmployeeUnderlingDTO> queryUnderling(List<EmployeeOrgBO> underlingEmpOrgList, boolean cascade, Boolean enabled, Map<String, String> typeNameMap) {
        if (underlingEmpOrgList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> underlingEmpIds = underlingEmpOrgList.stream().map(EmployeeOrgBO::getEmployeeId).collect(Collectors.toSet());
        Map<Object, Object> underlingUnderlingMap = null;
        if (cascade) {
            List<EmployeeOrgBO> underlingUnderlingList = this.employeeOrgRepoProc.getUnderlings(underlingEmpIds, enabled);
            underlingUnderlingMap = this.queryUnderling(underlingUnderlingList, cascade, enabled, typeNameMap).stream().collect(Collectors.groupingBy(EmployeeUnderlingDTO::getLeaderEmployeeId));
        } else {
            underlingUnderlingMap = Collections.emptyMap();
        }
        Map<Long, List<IdCodeNameParam>> underlingEmpOrgNameMap = this.employeeOrgRepoProc.getEmployeeOrgs(underlingEmpIds, enabled);
        Map<Long, SysEmployeeDO> employeeMap = this.repoProc.get(underlingEmpIds).stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        Map<Object, Object> finalUnderlingUnderlingMap = underlingUnderlingMap;
        List<EmployeeUnderlingDTO> underlingList = underlingEmpOrgList.stream().filter(t -> employeeMap.containsKey(t.getEmployeeId())).map(t -> {
            EmployeeUnderlingDTO dto = CONVERT.do2UnderlingDto((SysEmployeeDO)employeeMap.get(t.getEmployeeId()));
            dto.setTypeName((String)typeNameMap.get(dto.getType()));
            dto.setOrgNames(underlingEmpOrgNameMap.getOrDefault(dto.getId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
            dto.setLeaderEmployeeId(t.getOwnerId());
            dto.setUnderlingList(finalUnderlingUnderlingMap.getOrDefault(dto.getId(), Collections.emptyList()));
            return dto;
        }).collect(Collectors.toList());
        return super.fillTenantUserInfo(underlingList);
    }

    private List<SysEmployeeDetailDTO> convertToEmployeeDetail(List<SysEmployeeDO> doList) {
        if (doList.isEmpty()) {
            return Collections.emptyList();
        }
        Map empTypeNameMap = super.udcMap((BaseUdc)new EmployeeType());
        List<Long> userIds = doList.stream().map(SysEmployeeDO::getUserId).filter(t -> t != null && t != -1L).collect(Collectors.toList());
        List<Long> ids = doList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List userInfos = this.userRepoCall(re -> re.get(userIds));
        Map<Long, SysUserDO> userInfoMap = userInfos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        Set<String> areaCodes = userInfos.stream().flatMap(t -> Stream.of(t.getCountryCode(), t.getProvinceCode(), t.getCityCode(), t.getCountyCode()).filter(StringUtils::hasText)).collect(Collectors.toSet());
        Map areaNameMap = null;
        areaNameMap = areaCodes.isEmpty() ? Collections.emptyMap() : (Map)ObjectUtil.defaultIfNull((Object)((Map)this.areaQueryService.queryNamesByAreaCode(areaCodes).getData()), Collections.emptyMap());
        Map finalAreaNameMap = areaNameMap;
        Map<Long, List<SysEmployeeDetailDTO.EmployeeOrg>> orgMap = this.employeeOrgRepoProc.getLeaders(ids).stream().map(t -> {
            SysEmployeeDetailDTO.EmployeeOrg temp = new SysEmployeeDetailDTO.EmployeeOrg();
            temp.setEmployeeId(t.getOwnerId());
            temp.setOrgId(t.getOrgId());
            temp.setOrgCode(t.getOrgCode());
            temp.setOrgName(t.getOrgName());
            temp.setOrgType(t.getOrgType());
            temp.setDef(t.getDef());
            temp.setAssignee(t.getAssignee());
            temp.setLeaderEmployeeCode(t.getEmployeeCode());
            temp.setLeaderEmployeeId(t.getEmployeeId());
            temp.setLeaderUserId(t.getUserId());
            temp.setLeaderUserFullName(t.getFullName());
            temp.setOrgList(this.orgRepoProc.getBasicDtoOfParents(t.getOrgId()));
            if (t.getPositionId() != null) {
                temp.setPosition(new IdCodeNameParam(t.getPositionId(), t.getPositionCode(), t.getPositionName()));
            }
            return temp;
        }).collect(Collectors.groupingBy(SysEmployeeDetailDTO.EmployeeOrg::getEmployeeId));
        Map<Long, List<IdCodeNameParam>> userRoleMap = this.userRoleRepoProc.getRoleOfUser(userIds, null, null);
        return doList.stream().map(t -> {
            SysEmployeeDetailDTO dto = CONVERT.do2DetailDto((SysEmployeeDO)t);
            dto.setWithoutLoginAccount(Boolean.valueOf(t.getUserId() == null || t.getUserId() == -1L));
            dto.setTypeName((String)empTypeNameMap.get(dto.getType()));
            if (!dto.getWithoutLoginAccount().booleanValue() && t.getUserId() != null && userInfoMap.containsKey(t.getUserId())) {
                SysUserDO userInfo = (SysUserDO)userInfoMap.get(t.getUserId());
                dto.setFullName(userInfo.getFullName());
                dto.setGender(userInfo.getGender());
                dto.setGenderName(userInfo.getGenderName());
                dto.setEmail(CharSequenceUtil.blankToDefault((CharSequence)dto.getEmail(), (String)userInfo.getEmail()));
                dto.setPhone(CharSequenceUtil.blankToDefault((CharSequence)dto.getPhone(), (String)userInfo.getMobile()));
                dto.setBirthDate(userInfo.getBirthDate());
                dto.setIdCard(userInfo.getIdCard());
                dto.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(dto.getEnabled()) && Boolean.TRUE.equals(userInfo.getEnabled())));
                dto.setAreaVO(this.convertAreaVO(userInfo, finalAreaNameMap));
                dto.setAddress(userInfo.getAddress());
            }
            dto.setOrgList(orgMap.getOrDefault(t.getId(), Collections.emptyList()));
            dto.setRoleList(userRoleMap.getOrDefault(dto.getUserId(), Collections.emptyList()));
            return dto;
        }).collect(Collectors.toList());
    }

    private AreaVO convertAreaVO(SysUserDO userDo, Map<String, String> nameMap) {
        AreaVO areaVO = new AreaVO();
        areaVO.setCountryCode(userDo.getCountryCode());
        areaVO.setCountryName(nameMap.get(userDo.getCountryCode()));
        areaVO.setProvinceCode(userDo.getProvinceCode());
        areaVO.setProvinceName(nameMap.get(userDo.getProvinceCode()));
        areaVO.setCityCode(userDo.getCityCode());
        areaVO.setCityName(nameMap.get(userDo.getCityCode()));
        areaVO.setCountyCode(userDo.getCountyCode());
        areaVO.setCountyName(nameMap.get(userDo.getCountyCode()));
        return areaVO;
    }
}

