/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.common.OwnerType;
import com.elitescloud.cloudt.system.model.entity.SysFrontTableCfgDO;
import com.elitescloud.cloudt.system.model.vo.save.extend.FrontTableCfgSaveVO;
import com.elitescloud.cloudt.system.service.FrontTableCfgService;
import com.elitescloud.cloudt.system.service.repo.FrontTableCfgRepo;
import com.elitescloud.cloudt.system.service.repo.FrontTableCfgRepoProc;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class FrontTableCfgServiceImpl
extends BaseServiceImpl
implements FrontTableCfgService {
    private static final Logger log = LogManager.getLogger(FrontTableCfgServiceImpl.class);
    @Autowired
    private FrontTableCfgRepo repo;
    @Autowired
    private FrontTableCfgRepoProc repoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveCfg(FrontTableCfgSaveVO saveVO, boolean global) {
        GeneralUserDetails currentUser = super.currentUser(true);
        OwnerType ownerType = null;
        Long ownerId = null;
        if (global) {
            ownerType = OwnerType.TENANT;
            ownerId = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID);
            this.updateGlobalCache(saveVO.getTableCode(), saveVO.getConfig(), ownerId);
        } else {
            ownerType = OwnerType.USER;
            ownerId = currentUser.getUserId();
            this.updateUserCache(saveVO.getTableCode(), saveVO.getConfig(), ownerId);
        }
        Long id = this.repoProc.getId(ownerId, ownerType, saveVO.getTableCode());
        if (StringUtils.hasText((String)saveVO.getConfig())) {
            if (id == null) {
                SysFrontTableCfgDO cfgDO = new SysFrontTableCfgDO();
                cfgDO.setTableCode(saveVO.getTableCode());
                cfgDO.setOwnerId(ownerId);
                cfgDO.setOwnerType(ownerType);
                cfgDO.setConfig(saveVO.getConfig());
                this.repo.save((Object)cfgDO);
                return ApiResult.ok((Object)true);
            }
            this.repoProc.updateConfig(id, saveVO.getConfig());
            return ApiResult.ok((Object)true);
        }
        this.repoProc.delete(id);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<String> getCfg(String tableCode, boolean global) {
        OwnerType ownerType = null;
        Long ownerId = null;
        if (global) {
            ownerType = OwnerType.TENANT;
            ownerId = super.currentTenantId();
        } else {
            GeneralUserDetails currentUser = super.currentUser(true);
            ownerType = OwnerType.USER;
            ownerId = currentUser.getUserId();
        }
        SysFrontTableCfgDO cfgDO = this.repoProc.get(ownerId, ownerType, tableCode);
        return ApiResult.ok((Object)(cfgDO == null ? null : cfgDO.getConfig()));
    }

    @Override
    public ApiResult<String> getUserCfg(String tableCode) {
        String config = null;
        HashSet<Long> ownerIds = new HashSet<Long>();
        GeneralUserDetails currentUser = super.currentUser(false);
        Long tenantId = null;
        if (currentUser == null) {
            tenantId = super.currentTenantId();
            config = this.getGlobalCache(tableCode, tenantId);
            if (config != null) {
                return ApiResult.ok((Object)config);
            }
            ownerIds.add(tenantId);
        } else {
            tenantId = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID);
            config = (String)ObjectUtil.defaultIfBlank((CharSequence)this.getUserCache(tableCode, currentUser.getUserId()), (CharSequence)this.getGlobalCache(tableCode, tenantId));
            if (config != null) {
                return ApiResult.ok((Object)config);
            }
            ownerIds.add(currentUser.getUserId());
            ownerIds.add(tenantId);
        }
        Map<OwnerType, String> cfgMap = this.repoProc.queryUserConfig(ownerIds, tableCode);
        if (cfgMap.isEmpty()) {
            if (currentUser == null) {
                this.updateGlobalCache(tableCode, null, tenantId);
            } else {
                this.updateUserCache(tableCode, null, currentUser.getUserId());
            }
            return ApiResult.ok(null);
        }
        config = cfgMap.get((Object)OwnerType.USER);
        if (CharSequenceUtil.isBlank((CharSequence)config)) {
            config = cfgMap.get((Object)OwnerType.TENANT);
            this.updateGlobalCache(tableCode, null, tenantId);
        } else if (currentUser != null) {
            this.updateUserCache(tableCode, null, currentUser.getUserId());
        }
        return ApiResult.ok((Object)config);
    }

    private String cacheKeyTenant(String tableCode, long tenantId) {
        return "cloudt:frontConfigTable:tenant:" + tenantId + ":" + tableCode;
    }

    private String cacheKeyUser(String tableCode, long userId) {
        return "cloudt:frontConfigTable:user:" + userId + ":" + tableCode;
    }

    private String getGlobalCache(String tableCode, long tenantId) {
        String key = this.cacheKeyTenant(tableCode, tenantId);
        return (String)this.redisUtils.get(key);
    }

    private String getUserCache(String tableCode, long userId) {
        String key = this.cacheKeyUser(tableCode, userId);
        return (String)this.redisUtils.get(key);
    }

    private void updateGlobalCache(String tableCode, String config, long tenantId) {
        String key = this.cacheKeyTenant(tableCode, tenantId);
        this.redisUtils.set(key, ObjectUtil.defaultIfNull((Object)config, (Object)""), 7L, TimeUnit.DAYS);
    }

    private void updateUserCache(String tableCode, String config, long userId) {
        String key = this.cacheKeyUser(tableCode, userId);
        this.redisUtils.set(key, ObjectUtil.defaultIfNull((Object)config, (Object)""), 7L, TimeUnit.DAYS);
    }
}

