/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.MenuFavorConvert;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.vo.query.menu.MenuFavorPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuFavorRespVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuFavorSaveVO;
import com.elitescloud.cloudt.system.service.MenuFavorMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysMenuFavorDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.repo.MenuFavorRepo;
import com.elitescloud.cloudt.system.service.repo.MenuFavorRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepoProc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class MenuFavorMngServiceImpl
extends BaseServiceImpl
implements MenuFavorMngService {
    private static final Logger log = LogManager.getLogger(MenuFavorMngServiceImpl.class);
    private static final MenuFavorConvert CONVERT = MenuFavorConvert.INSTANCE;
    @Autowired
    private MenuFavorRepo menuFavorRepo;
    @Autowired
    private MenuFavorRepoProc menuFavorRepoProc;
    @Autowired
    private TenantMenuRepoProc tenantMenuRepoProc;
    @Autowired
    private TenantMenuTreeRepoProc tenantMenuTreeRepoProc;
    @Autowired
    private MenuRepoProc menuRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(MenuFavorSaveVO saveVO) {
        GeneralUserDetails currentUser = super.currentUser(true);
        boolean isAdd = saveVO.getId() == null;
        SysMenuFavorDO menuFavorDO = null;
        if (isAdd) {
            menuFavorDO = CONVERT.saveVo2Do(saveVO);
            menuFavorDO.setUserId(currentUser.getUserId());
        } else {
            menuFavorDO = (SysMenuFavorDO)this.menuFavorRepoProc.get(saveVO.getId());
            if (menuFavorDO == null) {
                return ApiResult.noData();
            }
            CONVERT.copySaveVo(saveVO, menuFavorDO);
        }
        menuFavorDO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)menuFavorDO.getSortNo(), (Object)0));
        menuFavorDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)menuFavorDO.getEnabled(), (Object)true));
        this.menuFavorRepo.save(menuFavorDO);
        return ApiResult.ok((Object)menuFavorDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        this.menuFavorRepoProc.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> switchEnabled(Long id) {
        Boolean enabled = this.menuFavorRepoProc.getEnabled(id);
        boolean value = enabled == null || enabled == false;
        this.menuFavorRepoProc.updateEnabled(value, id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<MenuFavorRespVO> get(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        Optional<MenuFavorRespVO> respVoOptional = this.menuFavorRepoProc.getOptional(id).map(CONVERT::do2DetailRespVo);
        if (respVoOptional.isEmpty()) {
            return ApiResult.noData();
        }
        MenuFavorRespVO respVO = respVoOptional.get();
        Long tenantId = super.currentTenantId();
        boolean custom = (Boolean)ObjectUtil.defaultIfNull((Object)this.tenantMenuRepoProc.getEnabledByTenant(tenantId), (Object)false);
        if (custom) {
            SysTenantMenuTreeDO menu = this.tenantMenuTreeRepoProc.getByMenuCode(respVO.getMenuCode());
            Assert.notNull((Object)menu, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
            if (StringUtils.hasText((String)menu.getMenuName())) {
                respVO.setMenuName(menu.getMenuName());
                return ApiResult.ok((Object)respVO);
            }
        }
        MenuBO platformMenu = (MenuBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.getByMenuCode(respVO.getMenuCode()));
        Assert.notNull((Object)platformMenu, (String)"\u83dc\u5355\u5df2\u4e0d\u5b58\u5728");
        respVO.setMenuName(platformMenu.getMenusName());
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<MenuFavorRespVO>> pageMng(MenuFavorPageQueryVO queryVO) {
        GeneralUserDetails currentUser = super.currentUser(true);
        Long tenantId = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID);
        boolean custom = (Boolean)ObjectUtil.defaultIfNull((Object)this.tenantMenuRepoProc.getEnabledByTenant(tenantId), (Object)false);
        List menuCodesFilter = null;
        if (StringUtils.hasText((String)queryVO.getMenuName()) && (menuCodesFilter = custom ? this.tenantMenuTreeRepoProc.queryMenuCodeByMenuNameLike(queryVO.getMenuName()) : (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.queryMenuCodeByMenuNameLike(queryVO.getMenuName()))).isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        PagingVO<SysMenuFavorDO> pageData = this.menuFavorRepoProc.pageMng(currentUser.getUserId(), queryVO, menuCodesFilter);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.builder().total(pageData.getTotal()).build());
        }
        Set<String> menuCodes = pageData.getRecords().stream().map(SysMenuFavorDO::getMenuCode).collect(Collectors.toSet());
        Map originalMenuNameMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.getMenuNameByMenuCode(menuCodes));
        Map<Object, Object> customMenuNameMap = custom ? this.tenantMenuTreeRepoProc.getMenuNameByMenuCode(menuCodes) : new HashMap(0);
        PagingVO pageVo = pageData.map(t -> {
            t.setMenuName(customMenuNameMap.getOrDefault(t.getMenuCode(), (String)originalMenuNameMap.get(t.getMenuCode())));
            return CONVERT.do2DetailRespVo((SysMenuFavorDO)t);
        });
        return ApiResult.ok((Object)pageVo);
    }
}

