/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.NoticeConvert;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonPublishedNoticePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonPublishedNoticeRespVO;
import com.elitescloud.cloudt.system.service.NoticeQueryService;
import com.elitescloud.cloudt.system.service.impl.BaseNoticeService;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NoticeQueryServiceImpl
extends BaseNoticeService
implements NoticeQueryService {
    private static final Logger log = LoggerFactory.getLogger(NoticeQueryServiceImpl.class);

    @Override
    public ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublished(CommonPublishedNoticePageQueryVO queryVO) {
        PagingVO<CommonPublishedNoticePageRespVO> pageData = this.pageQuery(queryVO);
        return ApiResult.ok(pageData);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<PagingVO<CommonPublishedNoticePageRespVO>> pageQueryPublishedSys(CommonPublishedNoticePageQueryVO queryVO) {
        PagingVO<CommonPublishedNoticePageRespVO> pageData = this.pageQuery(queryVO);
        return ApiResult.ok(pageData);
    }

    @Override
    public ApiResult<CommonPublishedNoticeRespVO> viewPublishedNotice(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u516c\u544aID\u4e3a\u7a7a");
        }
        CommonPublishedNoticeRespVO noticeVO = this.view(id);
        if (noticeVO == null) {
            noticeVO = (CommonPublishedNoticeRespVO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.view(id));
        }
        return ApiResult.ok((Object)noticeVO);
    }

    private PagingVO<CommonPublishedNoticePageRespVO> pageQuery(CommonPublishedNoticePageQueryVO queryVO) {
        PagingVO pageData = this.repoProc.pagePublished(queryVO).map(NoticeConvert.INSTANCE::convert2PublishedPageVO);
        if (pageData.isEmpty()) {
            return pageData;
        }
        super.fillListInfo(pageData.getRecords());
        return pageData;
    }

    private CommonPublishedNoticeRespVO view(long id) {
        SysNoticeDO noticeDO = (SysNoticeDO)this.repoProc.get(id);
        if (noticeDO == null || Boolean.FALSE.equals(noticeDO.getPublished()) || noticeDO.getPublishTime().isAfter(LocalDateTime.now())) {
            return null;
        }
        CommonPublishedNoticeRespVO noticeVO = NoticeConvert.INSTANCE.convert2PublishedVO(noticeDO);
        super.fillDetailInfo(noticeDO, noticeVO);
        CompletableFuture.runAsync(() -> this.repoProc.increaseNum(id), (Executor)this.taskExecutor).whenComplete((v, e) -> {
            if (e != null) {
                log.error("\u66f4\u65b0\u9605\u8bfb\u91cf\u5f02\u5e38\uff1a{}", (Object)id, e);
            }
        });
        return noticeVO;
    }
}

