/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.common.InfinityWebProperties;
import com.elitescloud.cloudt.system.common.OAuth2Client;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.service.SecurityAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class OAuth2SecurityService
implements SecurityAuthService {
    private static final Logger log = LoggerFactory.getLogger(OAuth2SecurityService.class);
    @Autowired(required=false)
    @Lazy
    private OAuth2Client authClient;

    @Override
    public boolean authentication(WebClient.RequestBodySpec uri, HttpParam param) {
        log.info("[BPMN][INFINITY] \u8ba4\u8bc1\u65b9\u5f0f: " + AuthMethod.AUTH_METHOD_OAUTH_V2.getDesc());
        if (!InfinityWebProperties.INFINITY_WEB_ENABLED) {
            log.error("[BPMN][INFINITY] WebClient not enabled.");
            throw new RuntimeException("WebClient not enabled.");
        }
        OAuth2AccountVO account = param.getApiConfig().getOauth2Account();
        if (ObjectUtil.isNull((Object)account) || account.isEmpty()) {
            log.error("[BPMN][INFINITY] \u672a\u7ef4\u62a4\u8ba4\u8bc1\u8d26\u53f7.");
            throw new RuntimeException("account is empty.");
        }
        String accessToken = this.authClient.getAccessToken(param.getPlatformCode(), account.getUrl(), account.getClientId(), account.getClientSecret());
        if (StrUtil.isBlank((CharSequence)accessToken)) {
            log.error("[BPMN][INFINITY] token\u4e3a\u7a7a.");
            return false;
        }
        uri.header("Authorization", new String[]{"Bearer " + accessToken});
        return true;
    }

    @Override
    public String getAuthType() {
        return AuthMethod.AUTH_METHOD_OAUTH_V2.getCode();
    }
}

