/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.swagger.openapi.common.OpenApiRpcClient;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectOperationInfo;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.Json;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Components;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Operation;
import com.elitescloud.boot.swagger.openapi.swagger3.models.PathItem;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Schema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.tags.Tag;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.LockUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.OpenApiConvert;
import com.elitescloud.cloudt.system.model.bo.OpenApiBO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiOperationPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiPageRespVO;
import com.elitescloud.cloudt.system.service.OpenApiMngService;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiStatusEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiComponentSchemaDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiInfoDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiResourceDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiTagDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiInfoRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiResourceRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiSchemaRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiTagRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class OpenApiMngServiceImpl
implements OpenApiMngService {
    private static final Logger log = LoggerFactory.getLogger(OpenApiMngServiceImpl.class);
    @Autowired
    private OpenApiInfoRepoProc infoRepoProc;
    @Autowired
    private OpenApiOperationRepoProc operationRepoProc;
    @Autowired
    private OpenApiTagRepoProc tagRepoProc;
    @Autowired
    private OpenApiSchemaRepoProc schemaRepoProc;
    @Autowired
    private OpenApiResourceRepoProc resourceRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private OpenApiService openApiService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private PlatformTransactionManager transactionManager;

    @Override
    public ApiResult<OpenAPI> testAnalyzeController(Class<?> ... beanClasses) {
        ArrayList<Object> controllers = new ArrayList<Object>();
        if (beanClasses != null) {
            for (Class<?> beanClass : beanClasses) {
                controllers.add(SpringContextHolder.getBean(beanClass));
            }
        }
        OpenAPI openApiInfo = controllers.isEmpty() ? this.openApiService.generateOpenApi() : this.openApiService.generateOpenApi(controllers.toArray());
        OpenAPI openApiInfoRpc = (OpenAPI)JSONUtil.json2Obj((String)JSONUtil.toJsonString((Object)openApiInfo), OpenAPI.class, (boolean)true);
        System.out.println("##########1");
        System.out.println(Json.pretty((Object)openApiInfoRpc));
        OpenApiBO openApiBo = this.initOpenApiInfo(openApiInfo);
        this.convertOpenApi(openApiBo, openApiInfo);
        OpenApiBO openApiBO2 = this.initOpenApiInfo(openApiInfoRpc);
        this.convertOpenApi(openApiBO2, openApiInfoRpc);
        return ApiResult.ok((Object)openApiInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateOpenApi(String appCode) {
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            return ApiResult.fail((String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        }
        Long openApiId = this.infoRepoProc.getId(null, null, appCode);
        if (openApiId != null) {
            return this.updateOpenApi(openApiId);
        }
        openApiId = this.updateOpenApiByRpcService(null, appCode);
        return ApiResult.ok((Object)openApiId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateOpenApi(Long openApiId) {
        if (openApiId == null) {
            return ApiResult.fail((String)"\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u7684\u8bb0\u5f55");
        }
        String appCode = this.infoRepoProc.getAppCode(openApiId);
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            return ApiResult.fail((String)"\u66f4\u65b0\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u8bb0\u5f55\u4fe1\u606f\u5f02\u5e38");
        }
        this.updateOpenApiByRpcService(openApiId, appCode);
        return ApiResult.ok((Object)openApiId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateOpenApi(OpenAPI openApi, OpenApiSourceEnum source) {
        Long openApiId = this.convertAndSave(null, openApi, source);
        return ApiResult.ok((Object)openApiId);
    }

    @Override
    public ApiResult<PagingVO<OpenApiPageRespVO>> pageMng(OpenApiPageQueryVO queryVO) {
        PagingVO pageData = this.infoRepoProc.pageMng(queryVO).map(t -> {
            OpenApiPageRespVO respVO = OpenApiConvert.INSTANCE.do2PageRespVO((SysOpenApiInfoDO)t);
            if (CharSequenceUtil.isBlank((CharSequence)respVO.getFailReason())) {
                respVO.setFailReason(t.getBusinessObjectFailReason());
            }
            return respVO;
        });
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData);
        }
        List<Long> ids = pageData.stream().map(OpenApiPageRespVO::getId).collect(Collectors.toList());
        List<String> codes = pageData.stream().map(OpenApiPageRespVO::getOpenApiCode).collect(Collectors.toList());
        Map<Long, Long> operationCountMap = this.operationRepoProc.countByOpenApiId(ids);
        Map<Long, Long> feignOperationCountMap = this.operationRepoProc.countByFeignOpenApiId(ids);
        Map<String, Long> businessObjectCountMap = this.businessObjectRepoProc.countByOpenApi(codes);
        pageData.each(t -> {
            if (CharSequenceUtil.isNotBlank((CharSequence)t.getState())) {
                ObjUtil.ifNotNull((Object)OpenApiStatusEnum.parse((String)t.getState()), s -> t.setStateName(s.getDescription()));
            }
            if (CharSequenceUtil.isNotBlank((CharSequence)t.getBusinessObjectState())) {
                ObjUtil.ifNotNull((Object)OpenApiStatusEnum.parse((String)t.getBusinessObjectState()), s -> t.setBusinessObjectStateName(s.getDescription()));
            }
            t.setOperationNum(operationCountMap.getOrDefault(t.getId(), 0L));
            t.setBusinessObjectNum(businessObjectCountMap.getOrDefault(t.getOpenApiCode(), 0L));
            t.setFeignOperationNum(feignOperationCountMap.getOrDefault(t.getId(), 0L));
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<PagingVO<OpenApiOperationPageRespVO>> pageMng(OpenApiOperationPageQueryVO queryVO) {
        if (queryVO.getOpenApiId() == null) {
            return ApiResult.fail((String)"OpenApiId\u4e3a\u7a7a");
        }
        PagingVO pageData = this.operationRepoProc.pageMng(queryVO).map(t -> {
            OpenApiOperationPageRespVO respVO = OpenApiConvert.INSTANCE.do2PageRespVO((SysOpenApiOperationDO)t);
            if (StringUtils.hasText((String)t.getTagsJson())) {
                respVO.setTags((String[])JSONUtil.json2Obj((String)t.getTagsJson(), (TypeReference)new TypeReference<String[]>(){}));
            }
            return respVO;
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<List<String>> selectDistinctOperationGroupByApiType() {
        return ApiResult.ok(this.operationRepoProc.selectDistinctOperationGroupByApiType());
    }

    private Long updateOpenApiByRpcService(Long openApiId, @NotBlank String appCode) {
        OpenApiRpcClient openApiClient = (OpenApiRpcClient)DynamicClientHelper.getClient((String)appCode, OpenApiRpcClient.class, (String)"/rpc/cloudt/swagger/openapi");
        ApiResult openApiResult = null;
        try {
            openApiResult = openApiClient.getOpenApi();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1{}\u83b7\u53d6OpenAPI\u5f02\u5e38\uff1a", (Object)appCode, (Object)e);
            throw new BusinessException("\u8c03\u7528\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u670d\u52a1" + appCode + "\u5728\u7ebf\u4e14\u652f\u6301OpenApi");
        }
        if (openApiResult.isFailed() || openApiResult.getData() == null) {
            throw new BusinessException(openApiResult.getMsg());
        }
        return this.convertAndSave(openApiId, (OpenAPI)openApiResult.getData(), OpenApiSourceEnum.GATHER_PULL);
    }

    private Long convertAndSave(Long existsOpenApiId, @NotNull OpenAPI openApi, @NotNull OpenApiSourceEnum source) {
        OpenApiBO openApiBo = this.initOpenApiInfo(openApi);
        openApiBo.setId(existsOpenApiId);
        List appCodes = this.appRepoProc.allCodes(null);
        Assert.isTrue((boolean)appCodes.contains(openApiBo.getAppCode()), (String)"\u5e94\u7528\u7f16\u7801\u4e0d\u6b63\u786e\u6216\u5e94\u7528\u4e0d\u5b58\u5728");
        String lockKey = "CloudtSystem:OpenApi:Create:" + this.generateOpenApiCode(openApiBo);
        existsOpenApiId = (Long)LockUtil.executeByLock((String)lockKey, () -> {
            Long tempOpenApiId;
            Long l = tempOpenApiId = openApiBo.getId() == null ? this.getExistsOpenApiId(openApiBo) : openApiBo.getId();
            if (tempOpenApiId == null) {
                openApiBo.setOriginalDataJson(Json.pretty((Object)openApi).getBytes(StandardCharsets.UTF_8));
                SysOpenApiInfoDO openApiInfoDO = this.saveOpenApiBaseInfo(openApiBo, false);
                return openApiInfoDO.getId();
            }
            if (OpenApiStatusEnum.UPDATING == this.infoRepoProc.getState(tempOpenApiId)) {
                throw new BusinessException("\u5e94\u7528[" + openApiBo.getAppName() + "]\u6b63\u5728\u66f4\u65b0OpenAPI\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (OpenApiStatusEnum.UPDATING == this.infoRepoProc.getBusinessObjectState(tempOpenApiId)) {
                throw new BusinessException("\u5e94\u7528[" + openApiBo.getAppName() + "]\u6b63\u5728\u66f4\u65b0\u4e1a\u52a1\u5bf9\u8c61\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            this.infoRepoProc.updateStartUpdate(tempOpenApiId);
            return tempOpenApiId;
        }, (Duration)Duration.ofMinutes(2L));
        openApiBo.setId(existsOpenApiId);
        CompletableFuture.supplyAsync(() -> {
            OpenApiBO openApiBoNew = this.convertOpenApi(openApiBo, openApi);
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
            transactionDefinition.setName("OpenApi2BusinessObject");
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            Long openApiId = null;
            try {
                openApiId = this.saveOrUpdate(openApiBoNew, source);
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                if (!transaction.isCompleted()) {
                    this.transactionManager.rollback(transaction);
                }
                throw e;
            }
            return openApiId;
        }, (Executor)this.taskExecutor).whenComplete((openApiId, e) -> {
            if (e == null) {
                this.infoRepoProc.updateEndUpdate((long)openApiId, OpenApiStatusEnum.FINISHED, null);
                this.infoRepoProc.updateBusinessObjectStatus((long)openApiId, OpenApiStatusEnum.TO_UPDATE, null);
                return;
            }
            log.error("\u4fdd\u5b58OpenAPI\u4fe1\u606f\u5f02\u5e38\uff1a", e);
            this.infoRepoProc.updateEndUpdate(openApiBo.getId(), OpenApiStatusEnum.FAILED, e.getMessage());
        });
        return existsOpenApiId;
    }

    private SysOpenApiInfoDO saveOpenApiBaseInfo(OpenApiBO openApiBo, boolean saveResource) {
        SysOpenApiInfoDO existsOpenApi = openApiBo.getId() == null ? new SysOpenApiInfoDO() : (SysOpenApiInfoDO)this.infoRepoProc.get(openApiBo.getId());
        SysOpenApiInfoDO openApiInfoDO = OpenApiConvert.INSTANCE.bo2Do(openApiBo, existsOpenApi);
        openApiInfoDO.setOpenApiCode(this.generateOpenApiCode(openApiBo));
        openApiInfoDO.setState(OpenApiStatusEnum.UPDATING.name());
        if (openApiInfoDO.getId() == null) {
            openApiInfoDO.setStartUpdateTime(LocalDateTime.now());
        }
        openApiInfoDO.setBusinessObjectState(OpenApiStatusEnum.PREPARING.name());
        openApiInfoDO.setResourceId(null);
        openApiInfoDO.setBusinessResourceId(null);
        this.infoRepoProc.save((Serializable)openApiInfoDO);
        if (saveResource) {
            Long resourceId = this.saveResource(openApiInfoDO.getId(), openApiBo.getOriginalDataJson(), "OpenApiInfo");
            if (resourceId != null) {
                this.infoRepoProc.updateResourceId(openApiInfoDO.getId(), resourceId);
            }
            if (CollUtil.isNotEmpty(openApiBo.getBusinessObjectMap()) && (resourceId = this.saveResource(openApiInfoDO.getId(), JSONUtil.toJsonBytes(openApiBo.getBusinessObjectMap()), "OpenApiBusinessObject")) != null) {
                this.infoRepoProc.updateBusinessResourceId(openApiInfoDO.getId(), resourceId);
            }
        }
        return openApiInfoDO;
    }

    private void saveOpenApiOperation(SysOpenApiInfoDO openApiInfoDO, OpenApiBO openApi, OpenApiSourceEnum source) {
        if (CollUtil.isEmpty(openApi.getOperationList())) {
            return;
        }
        Long openApiId = openApiInfoDO.getId();
        ArrayList tagBoList = new ArrayList();
        List operationDoList = openApi.getOperationList().stream().map(t -> {
            Long resourceId = this.saveResource(openApiId, t.getOriginalDataJson(), "OpenApiOperation");
            SysOpenApiOperationDO openApiOperationDO = OpenApiConvert.INSTANCE.bo2Do((OpenApiBO.Operation)t);
            openApiOperationDO.setOpenApiInfoId(openApiId);
            openApiOperationDO.setOperationCode(this.generateOperationCode(openApi, (OpenApiBO.Operation)t));
            openApiOperationDO.setDataSource(source.name());
            openApiOperationDO.setTagsJson(JSONUtil.toJsonString((Object)t.getTags()));
            openApiOperationDO.setResourceId(resourceId);
            openApiOperationDO.setBusinessOperation(t.getBusinessOperation());
            if (ArrayUtil.isNotEmpty((Object[])t.getTags())) {
                int i = 0;
                for (String tag : t.getTags()) {
                    tagBoList.add(new TagBO(tag, i++, openApiOperationDO));
                }
            }
            return openApiOperationDO;
        }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysOpenApiOperationDO>(Comparator.comparing(SysOpenApiOperationDO::getOperationCode))), ArrayList::new));
        this.operationRepoProc.save(operationDoList);
        List tagDoList = tagBoList.stream().map(t -> {
            SysOpenApiTagDO tagDO = new SysOpenApiTagDO();
            tagDO.setOpenApiInfoId(openApiId);
            tagDO.setOperationId(t.operationDO.getId());
            tagDO.setTag(t.tagName);
            tagDO.setSortNo(Integer.valueOf(t.sortNo));
            return tagDO;
        }).filter(t -> t.getOperationId() != null).collect(Collectors.toList());
        if (!tagDoList.isEmpty()) {
            this.tagRepoProc.save(tagDoList);
        }
    }

    private void saveOpenApiCommentSchema(SysOpenApiInfoDO openApiInfoDO, OpenApiBO openApi) {
        if (CollUtil.isEmpty(openApi.getComponentSchemaList())) {
            return;
        }
        Long openApiId = openApiInfoDO.getId();
        List schemaDoList = openApi.getComponentSchemaList().stream().map(t -> {
            Long resourceId = this.saveResource(openApiId, t.getOriginalDataJson(), "OpenApiComponentSchema");
            SysOpenApiComponentSchemaDO schemaDO = OpenApiConvert.INSTANCE.bo2Do((OpenApiBO.ComponentSchema)t);
            schemaDO.setOpenApiInfoId(openApiId);
            schemaDO.setResourceId(resourceId);
            return schemaDO;
        }).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SysOpenApiComponentSchemaDO>(Comparator.comparing(SysOpenApiComponentSchemaDO::getSchemaPath))), ArrayList::new));
        this.schemaRepoProc.save(schemaDoList);
    }

    private Long saveOrUpdate(@NotNull OpenApiBO openApi, @NotNull OpenApiSourceEnum source) {
        log.info("\u4fdd\u5b58OpenApi\u4fe1\u606f\uff1a{}\uff0c{}\uff0c{}", new Object[]{openApi.getProject(), openApi.getEnv(), openApi.getAppCode()});
        this.operationRepoProc.deleteByOpenApiId(openApi.getId());
        this.schemaRepoProc.deleteByOpenApiId(openApi.getId());
        this.tagRepoProc.deleteByOpenApiId(openApi.getId());
        this.resourceRepoProc.deleteByOpenApiId(openApi.getId());
        SysOpenApiInfoDO openApiInfoDO = this.saveOpenApiBaseInfo(openApi, true);
        Long openApiId = openApiInfoDO.getId();
        this.saveOpenApiOperation(openApiInfoDO, openApi, source);
        this.saveOpenApiCommentSchema(openApiInfoDO, openApi);
        return openApiId;
    }

    private Long saveResource(long openApiId, byte[] resourceContent, String ... bs) {
        if (resourceContent == null) {
            return null;
        }
        SysOpenApiResourceDO resourceDO = new SysOpenApiResourceDO();
        resourceDO.setOpenApiInfoId(Long.valueOf(openApiId));
        resourceDO.setResourceByte(resourceContent);
        if (ArrayUtil.isNotEmpty((Object[])bs)) {
            resourceDO.setExt1(bs[0]);
            if (bs.length == 2) {
                resourceDO.setExt2(bs[1]);
            }
        }
        this.resourceRepoProc.save((Serializable)resourceDO);
        return resourceDO.getId();
    }

    private Long getExistsOpenApiId(OpenApiBO openApiBO) {
        return this.infoRepoProc.getId(openApiBO.getProject(), openApiBO.getEnv(), openApiBO.getAppCode());
    }

    private String generateOpenApiCode(OpenApiBO openApiBO) {
        return openApiBO.getAppCode();
    }

    private String generateOperationCode(OpenApiBO openApiBO, OpenApiBO.Operation operation) {
        if (StringUtils.hasText((String)operation.getOperationCode())) {
            return operation.getOperationCode();
        }
        return openApiBO.getAppCode() + ":" + operation.getMethod() + ":" + operation.getUrl();
    }

    private void deleteByService(String appCode, String env, String project) {
        Long openId = this.infoRepoProc.getId(project, env, appCode);
        if (openId == null) {
            return;
        }
        this.infoRepoProc.delete(openId);
        this.operationRepoProc.deleteByOpenApiId(openId);
        this.schemaRepoProc.deleteByOpenApiId(openId);
    }

    private OpenApiBO convertOpenApi(OpenApiBO bo, OpenAPI openApi) {
        Map extensions;
        if (bo == null) {
            bo = this.initOpenApiInfo(openApi);
        }
        if (ArrayUtil.isEmpty((byte[])bo.getOriginalDataJson())) {
            bo.setOriginalDataJson(Json.pretty((Object)openApi).getBytes(StandardCharsets.UTF_8));
        }
        if ((extensions = openApi.getExtensions()) != null) {
            bo.setBusinessObjectMap((Map)extensions.get("x-BusinessObjects"));
        }
        bo.setOperationList(this.obtainOperationBO(openApi, bo));
        bo.setComponentSchemaList(this.obtainSchemaBO(openApi));
        return bo;
    }

    private OpenApiBO initOpenApiInfo(OpenAPI openAPI) {
        List tags;
        Assert.notNull((Object)openAPI, (String)"OpenAPI\u4e3a\u7a7a");
        Info apiInfo = openAPI.getInfo();
        Assert.notNull((Object)apiInfo, (String)"OpenAPI\u4fe1\u606f\u5f02\u5e38");
        OpenApiBO bo = new OpenApiBO();
        bo.setTitle(apiInfo.getTitle());
        bo.setDescription(apiInfo.getDescription());
        bo.setVersion(apiInfo.getVersion());
        Map ext = apiInfo.getExtensions();
        if (MapUtil.isNotEmpty((Map)ext)) {
            Object buildTimeStr = ext.get("x-BuildTime");
            if (buildTimeStr instanceof String) {
                bo.setBuildTime(DatetimeUtil.parseLocalDateTime((String)((String)buildTimeStr)));
            }
            bo.setProject((String)ext.get("x-Project"));
            bo.setProjectName((String)ext.get("x-Project-Name"));
            bo.setEnv((String)ext.get("x-Env"));
            bo.setEnvName((String)ext.get("x-Env-Name"));
            bo.setAppCode((String)ext.get("x-Service"));
            bo.setAppName((String)ext.get("x-Service-Name"));
            bo.setProjectVersion((String)ext.get("x-ProjectVersion"));
            bo.setCloudtBootVersion((String)ext.get("x-CloudtBootVersion"));
        }
        List list = tags = openAPI.getTags() == null ? null : openAPI.getTags().stream().map(Tag::getName).filter(StringUtils::hasText).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(tags)) {
            bo.setTagsJson(JSONUtil.toJsonString(tags));
        }
        return bo;
    }

    private List<OpenApiBO.Operation> obtainOperationBO(OpenAPI openApi, OpenApiBO bo) {
        if (CollUtil.isEmpty((Map)openApi.getPaths())) {
            return Collections.emptyList();
        }
        return openApi.getPaths().entrySet().parallelStream().flatMap(pathsEntry -> Stream.of(this.convertOperation(((PathItem)pathsEntry.getValue()).getGet(), (String)pathsEntry.getKey(), RequestMethod.GET), this.convertOperation(((PathItem)pathsEntry.getValue()).getPost(), (String)pathsEntry.getKey(), RequestMethod.POST), this.convertOperation(((PathItem)pathsEntry.getValue()).getPut(), (String)pathsEntry.getKey(), RequestMethod.PUT), this.convertOperation(((PathItem)pathsEntry.getValue()).getPatch(), (String)pathsEntry.getKey(), RequestMethod.PATCH), this.convertOperation(((PathItem)pathsEntry.getValue()).getDelete(), (String)pathsEntry.getKey(), RequestMethod.DELETE), this.convertOperation(((PathItem)pathsEntry.getValue()).getTrace(), (String)pathsEntry.getKey(), RequestMethod.TRACE), this.convertOperation(((PathItem)pathsEntry.getValue()).getOptions(), (String)pathsEntry.getKey(), RequestMethod.OPTIONS), this.convertOperation(((PathItem)pathsEntry.getValue()).getHead(), (String)pathsEntry.getKey(), RequestMethod.HEAD))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private OpenApiBO.Operation convertOperation(Operation operation, String path, RequestMethod method) {
        if (operation == null) {
            return null;
        }
        OpenApiBO.Operation bo = new OpenApiBO.Operation();
        bo.setOperationId(operation.getOperationId());
        bo.setSummary(operation.getSummary());
        bo.setDescription(operation.getDescription());
        bo.setTags(operation.getTags() == null ? new String[]{} : (String[])operation.getTags().stream().filter(StringUtils::hasText).distinct().toArray(String[]::new));
        bo.setOriginalDataJson(JSONUtil.toJsonBytes((Object)operation));
        bo.setEnabled(true);
        bo.setUrl(path);
        bo.setMethod(method.name());
        bo.setBusinessOperation(this.supportBusinessObjectOperation(operation));
        if (operation.getExtensions() != null) {
            Object returnTypeJson;
            Object parameterTypesJson;
            Object apiType;
            Object operationGroup = operation.getExtensions().get("x-operationGroup");
            if (operationGroup != null) {
                bo.setOperationGroup((String)operationGroup);
            }
            if ((apiType = operation.getExtensions().get("x-apiType")) != null) {
                bo.setApiType((Integer)apiType);
            }
            if ((parameterTypesJson = operation.getExtensions().get("x-parameterTypesJson")) != null) {
                bo.setParameterTypesJson((String)parameterTypesJson);
            }
            if ((returnTypeJson = operation.getExtensions().get("x-returnTypeJson")) != null) {
                bo.setReturnTypeJson((String)returnTypeJson);
            }
        }
        if (bo.getBusinessOperation().booleanValue()) {
            Object businessObjectOperationInfo = operation.getExtensions().get("x-BusinessObject-Operation");
            if (businessObjectOperationInfo instanceof BusinessObjectOperationInfo) {
                bo.setOperationCode(((BusinessObjectOperationInfo)businessObjectOperationInfo).getOperationCode());
            } else if (businessObjectOperationInfo instanceof Map) {
                Object operationCode = ((Map)businessObjectOperationInfo).get("operationCode");
                bo.setOperationCode(operationCode == null ? null : operationCode.toString());
            } else {
                throw new BusinessException("\u89e3\u6790\u4e1a\u52a1\u64cd\u4f5c\u5f02\u5e38");
            }
        }
        return bo;
    }

    private boolean supportBusinessObjectOperation(Operation operation) {
        if (operation == null) {
            return false;
        }
        Map ext = operation.getExtensions();
        return ext != null && ext.containsKey("x-BusinessObject-Operation");
    }

    private List<OpenApiBO.ComponentSchema> obtainSchemaBO(OpenAPI openApi) {
        Components components = openApi.getComponents();
        if (components == null) {
            return Collections.emptyList();
        }
        Map schemas = components.getSchemas();
        if (CollUtil.isEmpty((Map)schemas)) {
            return Collections.emptyList();
        }
        return schemas.entrySet().parallelStream().map(entry -> {
            OpenApiBO.ComponentSchema schema = new OpenApiBO.ComponentSchema();
            schema.setSchemaPath("#/components/schemas/" + (String)entry.getKey());
            schema.setSchemaType(((Schema)entry.getValue()).getType());
            schema.setOriginalDataJson(JSONUtil.toJsonBytes(entry.getValue()));
            return schema;
        }).collect(Collectors.toList());
    }

    static class TagBO {
        private final String tagName;
        private final int sortNo;
        private final SysOpenApiOperationDO operationDO;

        public TagBO(String tagName, int sortNo, SysOpenApiOperationDO operationDO) {
            this.tagName = tagName;
            this.sortNo = sortNo;
            this.operationDO = operationDO;
        }
    }
}

