/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysBusinessUnit;
import com.elitescloud.cloudt.constant.SysFunctionType;
import com.elitescloud.cloudt.constant.SysProfitablyCenter;
import com.elitescloud.cloudt.constant.SysRegion;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.convert.OrgConvert;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgSaveVO;
import com.elitescloud.cloudt.system.service.OrgMngService;
import com.elitescloud.cloudt.system.service.manager.OrgMngManager;
import com.elitescloud.cloudt.system.service.manager.OrgTreeManager;
import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class OrgMngServiceImpl
extends BaseServiceImpl
implements OrgMngService {
    private static final Logger log = LogManager.getLogger(OrgMngServiceImpl.class);
    private static final OrgConvert CONVERT = OrgConvert.INSTANCE;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private OuRepoProc ouRepoProc;
    @Autowired
    private OrgMngManager orgManager;
    @Autowired
    private OrgTreeManager orgTreeManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(OrgSaveVO saveVO) {
        if (saveVO.getExecutive() == null) {
            saveVO.setExecutive(true);
        }
        SysOrgSaveBO saveBo = saveVO.getId() == null ? this.toSaveBoForAdd(saveVO) : this.toSaveBoForUpdate(saveVO);
        SysOrgDO orgDo = this.orgManager.upsert(saveBo);
        return ApiResult.ok((Object)orgDo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(OrgUpsertDTO upsertDTO) {
        if (upsertDTO.getExecutive() == null) {
            upsertDTO.setExecutive(Boolean.valueOf(true));
        }
        SysOrgSaveBO saveBo = upsertDTO.getId() == null ? this.toSaveBoForAdd(upsertDTO) : this.toSaveBoForUpdate(upsertDTO);
        SysOrgDO orgDo = this.orgManager.upsert(saveBo);
        return ApiResult.ok((Object)orgDo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.orgManager.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        Boolean enabled = this.orgRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        return this.updateEnabled(id, enabled);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        enabled = enabled == null || enabled != false;
        this.orgManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateTreeRebuild(Long rootOrgId) {
        this.orgManager.rebuildTree(rootOrgId);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<List<OrgTreeNodeRespVO>> getOrgTree(Boolean tree) {
        GeneralUserDetails currentUser = super.currentUser(true);
        if (!this.hasPermission(currentUser)) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650");
        }
        Long orgIdBelong = null;
        if (currentUser.isTenantOrgAdmin()) {
            orgIdBelong = currentUser.getTenantOrgId();
            Assert.notNull((Object)orgIdBelong, (String)"\u672a\u77e5\u6240\u5c5e\u79df\u6237\u7ec4\u7ec7");
        }
        List<OrgTreeNodeRespVO> treeData = this.orgTreeManager.getTreeCacheable(orgIdBelong, tree == null || tree != false, true, false);
        return ApiResult.ok(treeData);
    }

    @Override
    public ApiResult<OrgDetailRespVO> getDetail(Long id, String withParentType) {
        SysOrgDO org = (SysOrgDO)this.orgRepoProc.get(id);
        if (org == null) {
            return ApiResult.noData();
        }
        OrgDetailRespVO orgRespVO = CONVERT.do2DetailRespVO(org);
        if (org.getPId() != null) {
            orgRespVO.setParentId(org.getPId());
            orgRespVO.setParentName(this.orgRepoProc.getNameById(org.getPId()));
        }
        orgRespVO.setTypeName(super.udcValue((BaseUdc)new OrgType(orgRespVO.getType())));
        if (org.getOuId() != null) {
            orgRespVO.setOuName(this.ouRepoProc.getOuName(org.getOuId()));
        }
        orgRespVO.setRegionName(super.udcValue((BaseUdc)new SysRegion(orgRespVO.getRegion())));
        orgRespVO.setBusinessUnitName(super.udcValue((BaseUdc)new SysBusinessUnit(orgRespVO.getBusinessUnit())));
        orgRespVO.setProfitablyCenterName(super.udcValue((BaseUdc)new SysProfitablyCenter(orgRespVO.getProfitablyCenter())));
        orgRespVO.setFunctionTypeName(super.udcValue((BaseUdc)new SysFunctionType(orgRespVO.getFunctionType())));
        if (StringUtils.hasText((String)withParentType)) {
            IdCodeNameParam withParent = this.orgRepoProc.queryParentNameForType(List.of(id), withParentType, false).get(id);
            orgRespVO.setWithParent(withParent);
        }
        return ApiResult.ok((Object)orgRespVO);
    }

    @Override
    public ApiResult<PagingVO<OrgPagedRespVO>> queryByPage(OrgPageQueryVO queryVO) {
        PagingVO<SysOrgDO> pageData = this.orgRepoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Set<String> parentCodes = pageData.getRecords().stream().map(SysOrgDO::getParentCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map<Object, Object> parentNameMap = parentCodes.isEmpty() ? new HashMap(0) : this.orgRepoProc.getNameByCode(parentCodes);
        Set<Long> ouIds = pageData.stream().map(SysOrgDO::getOuId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Object, Object> ouNameMap = ouIds.isEmpty() ? new HashMap(0) : this.ouRepoProc.getNameMapById(ouIds);
        Map orgTypeMap = super.udcMap((BaseUdc)new OrgType());
        PagingVO pageResult = pageData.map(t -> {
            OrgPagedRespVO respVO = CONVERT.do2MngPageRespVO((SysOrgDO)t);
            respVO.setParentName((String)parentNameMap.get(t.getParentCode()));
            respVO.setOuName((String)ouNameMap.get(t.getOuId()));
            respVO.setTypeName((String)orgTypeMap.get(t.getType()));
            return respVO;
        });
        return ApiResult.ok((Object)pageResult);
    }

    private SysOrgSaveBO toSaveBoForAdd(OrgSaveVO saveVO) {
        SysOrgSaveBO saveBo = CONVERT.saveVo2SaveBo(saveVO);
        if (StringUtils.hasText((String)saveVO.getParentCode())) {
            boolean exists = this.orgRepoProc.existsCode(saveVO.getParentCode());
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            saveBo.setSyncOuter(this.orgRepoProc.getSyncOuterByCode(saveVO.getParentCode()));
        } else if (saveVO.getParentId() != null && saveVO.getParentId() != -1L) {
            String pCode = this.orgRepoProc.getCodeById(saveVO.getParentId());
            Assert.hasText((String)pCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            saveBo.setParentCode(pCode);
            saveBo.setSyncOuter(this.orgRepoProc.getSyncOuter(saveVO.getParentId()));
        } else if (saveVO.getSyncOuter() == null) {
            saveBo.setSyncOuter(Boolean.valueOf(true));
        }
        return saveBo;
    }

    private SysOrgSaveBO toSaveBoForAdd(OrgUpsertDTO upsertDTO) {
        SysOrgSaveBO saveBo = CONVERT.upsertDTO2SaveBo(upsertDTO);
        if (upsertDTO.getParentId() != null && upsertDTO.getParentId() != -1L) {
            String pCode = this.orgRepoProc.getCodeById(upsertDTO.getParentId());
            Assert.hasText((String)pCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            saveBo.setParentCode(pCode);
            saveBo.setSyncOuter(this.orgRepoProc.getSyncOuter(upsertDTO.getParentId()));
        } else {
            saveBo.setSyncOuter(Boolean.valueOf(true));
        }
        return saveBo;
    }

    private SysOrgSaveBO toSaveBoForUpdate(OrgSaveVO saveVO) {
        SysOrgDO orgDO = (SysOrgDO)this.orgRepoProc.get(saveVO.getId());
        Assert.notNull((Object)orgDO, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        Boolean syncOuterOld = orgDO.getSyncOuter();
        SysOrgSaveBO saveBo = CONVERT.do2SaveBo(orgDO);
        CONVERT.copySaveVo2Bo(saveVO, saveBo);
        if (StringUtils.hasText((String)saveVO.getParentCode())) {
            if (!saveVO.getParentCode().equals(orgDO.getParentCode())) {
                boolean exists = this.orgRepoProc.existsCode(saveVO.getParentCode());
                Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            }
            saveBo.setSyncOuter(syncOuterOld);
        } else if (saveVO.getParentId() != null && saveVO.getParentId() != -1L) {
            if (saveVO.getParentId().longValue() == orgDO.getPId().longValue()) {
                saveBo.setParentCode(orgDO.getParentCode());
            } else {
                String pCode = this.orgRepoProc.getCodeById(saveVO.getParentId());
                Assert.hasText((String)pCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                saveBo.setParentCode(pCode);
            }
            saveBo.setSyncOuter(syncOuterOld);
        } else if (saveVO.getSyncOuter() == null) {
            saveBo.setSyncOuter(Boolean.valueOf(true));
        }
        return saveBo;
    }

    private SysOrgSaveBO toSaveBoForUpdate(OrgUpsertDTO upsertDTO) {
        SysOrgDO orgDO = (SysOrgDO)this.orgRepoProc.get(upsertDTO.getId());
        Assert.notNull((Object)orgDO, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        SysOrgSaveBO saveBo = CONVERT.do2SaveBo(orgDO);
        CONVERT.copyUpsertDTO2Bo(upsertDTO, saveBo);
        if (upsertDTO.getParentId() != null && upsertDTO.getParentId() != -1L) {
            if (upsertDTO.getParentId().longValue() == orgDO.getPId().longValue()) {
                saveBo.setParentCode(orgDO.getParentCode());
            } else {
                String pCode = this.orgRepoProc.getCodeById(upsertDTO.getParentId());
                Assert.hasText((String)pCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                saveBo.setParentCode(pCode);
            }
        }
        return saveBo;
    }

    private boolean hasPermission(GeneralUserDetails currentUser) {
        return currentUser != null;
    }
}

