/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysRegion;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.SysOuType;
import com.elitescloud.cloudt.system.convert.OuConvert;
import com.elitescloud.cloudt.system.model.vo.query.org.OuPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OuSaveVO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.OuMngService;
import com.elitescloud.cloudt.system.service.manager.OuMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysOuSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOuDO;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class OuMngServiceImpl
extends BaseServiceImpl
implements OuMngService {
    private static final OuConvert CONVERT = OuConvert.INSTANCE;
    @Autowired
    private OuRepoProc repoProc;
    @Autowired
    private OuMngManager manager;
    @Autowired
    private AreaQueryService areaQueryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(OuSaveVO saveVO) {
        SysOuSaveBO saveBO = CONVERT.saveVo2SaveBO(saveVO, saveVO.getArea());
        Long ouId = this.manager.upsert(saveBO);
        return ApiResult.ok((Object)ouId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.manager.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.repoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.manager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<PagingVO<OuPageRespVO>> page(OuPageQueryVO queryVO) {
        PagingVO<SysOuDO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(CONVERT::do2PageRespVO));
        }
        Map ouTypeNames = super.udcMap((BaseUdc)new SysOuType());
        PagingVO result = pageData.map(t -> {
            OuPageRespVO vo = CONVERT.do2PageRespVO((SysOuDO)t);
            vo.setOuTypeName((String)ouTypeNames.get(t.getOuType()));
            return vo;
        });
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<OuDetailRespVO> get(Long id) {
        return this.repoProc.getOptional(id).map(t -> {
            Map areaNameMap;
            OuDetailRespVO vo = CONVERT.do2DetailRespVO((SysOuDO)t);
            vo.setOuTypeName(super.udcValue((BaseUdc)new SysOuType(t.getOuType())));
            if (StringUtils.hasText((String)t.getPhone())) {
                String[] temp = t.getPhone().split("-");
                vo.setPhonePrefix(temp[0]);
                vo.setPhoneNum(temp[1]);
            }
            if (t.getLegalOuId() != null) {
                vo.setLegalOuName(this.repoProc.getOuName(t.getLegalOuId()));
            }
            vo.setRegionName(super.udcValue((BaseUdc)new SysRegion(t.getRegion())));
            Set<String> areaCodes = Stream.of(t.getProvinceCode(), t.getCityCode(), t.getCountyCode()).filter(StringUtils::hasText).collect(Collectors.toSet());
            if (!areaCodes.isEmpty() && (areaNameMap = (Map)this.areaQueryService.queryNamesByAreaCode(areaCodes).getData()) != null && !areaNameMap.isEmpty()) {
                vo.setArea(this.convertAreaVO((SysOuDO)t, areaNameMap));
            }
            return vo;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    private AreaVO convertAreaVO(SysOuDO ouDO, Map<String, String> nameMap) {
        AreaVO areaVO = new AreaVO();
        areaVO.setCountryCode(ouDO.getCountryCode());
        areaVO.setCountryName(nameMap.get(ouDO.getCountryCode()));
        areaVO.setProvinceCode(ouDO.getProvinceCode());
        areaVO.setProvinceName(nameMap.get(ouDO.getProvinceCode()));
        areaVO.setCityCode(ouDO.getCityCode());
        areaVO.setCityName(nameMap.get(ouDO.getCityCode()));
        areaVO.setCountyCode(ouDO.getCountyCode());
        areaVO.setCountyName(nameMap.get(ouDO.getCountyCode()));
        return areaVO;
    }
}

