/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.elitescloud.cloudt.system.common.LoggingProperty;
import com.elitescloud.cloudt.system.common.TrackDoc;
import com.elitescloud.cloudt.system.model.vo.AuditLogVO;
import com.elitescloud.cloudt.system.service.AuditLogListener;
import com.elitescloud.cloudt.system.service.PersistenceService;
import com.elitescloud.cloudt.system.service.PipelineService;
import com.elitescloud.cloudt.system.service.TenantAsyncSpi;
import com.elitescloud.cloudt.system.util.DateUtils;
import com.elitescloud.cloudt.system.util.HttpServletUtil;
import com.elitescloud.cloudt.system.util.RequestWrapper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersistenceServiceImpl
implements PersistenceService {
    private static final Logger log = LoggerFactory.getLogger(PersistenceServiceImpl.class);
    @Resource
    private TenantAsyncSpi tenantAsyncSpi;
    @Autowired(required=false)
    private AuditLogListener auditLogListener;
    private final PipelineService pipelineService;

    @Override
    public <T> void addSystemLogs(LoggingProperty property, String trackType, String eventMessage, List<T> eventParam, String eventError) {
        Consumer<Object> addSystemLog = param -> this.write(property, HttpServletUtil.currentRequestWrapper(), trackType, eventMessage, param, eventError);
        if (property.isThreadPool()) {
            if (this.tenantAsyncSpi == null) {
                eventParam.forEach(addSystemLog);
            } else {
                this.tenantAsyncSpi.runAsync(() -> eventParam.forEach(addSystemLog));
            }
        } else {
            eventParam.forEach(addSystemLog);
        }
    }

    @Override
    public <T> void addSystemLog(LoggingProperty property, RequestWrapper request, String trackType, String eventMessage, T eventParam, String eventError) {
        if (property.isThreadPool()) {
            if (this.tenantAsyncSpi == null) {
                this.write(property, request, trackType, eventMessage, eventParam, eventError);
            } else {
                this.tenantAsyncSpi.runAsync(() -> this.write(property, request, trackType, eventMessage, eventParam, eventError));
            }
        } else {
            this.write(property, request, trackType, eventMessage, eventParam, eventError);
        }
    }

    private void write(LoggingProperty property, RequestWrapper request, String trackType, String eventMessage, Object eventParam, String eventError) {
        if (ObjectUtil.isNull((Object)property.getLogType())) {
            log.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u7c7b\u578b\u672a\u6b63\u786e\u914d\u7f6e\uff1a{}", (Object)trackType, (Object)property);
            return;
        }
        if (ObjectUtil.isNull((Object)((Object)property.getConsumerPipeline()))) {
            log.error("[PHOENIX-LOG] EVENT({}) \u65e5\u5fd7\u6d88\u8d39\u65b9\u5f0f\u672a\u6307\u5b9a\uff1a{}", (Object)trackType, (Object)property);
            return;
        }
        String logType = property.getLogType().getCode();
        String pipeline = property.getConsumerPipeline().getCode();
        if (!property.isEnabled()) {
            log.warn("[PHOENIX-LOG] EVENT({}) {} \u529f\u80fd\u672a\u5f00\u542f.", (Object)trackType, (Object)logType);
            return;
        }
        TrackDoc trackDoc = new TrackDoc();
        if (ObjectUtil.isNotNull((Object)((Object)request))) {
            trackDoc.setRequestUrl(request.getRequestURL().toString());
            trackDoc.setRequestMethod(request.getMethod());
            trackDoc.setRequestHeader(HttpServletUtil.getHeaders((HttpServletRequest)request));
            trackDoc.setRequestParams(HttpServletUtil.getParameters((HttpServletRequest)request));
            trackDoc.setRequestBody(request.getBodyString());
            trackDoc.setAddressIp(ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        }
        trackDoc.setTrackType(trackType);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventMessage(eventMessage);
        trackDoc.setEventParam(eventParam);
        trackDoc.setErrorMessage(eventError);
        int maxRetryTimes = property.getRetry().getRetryTimes();
        boolean iOperationLogGetResult = false;
        if (this.auditLogListener != null && eventParam instanceof AuditLogVO) {
            for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
                try {
                    iOperationLogGetResult = this.auditLogListener.createLog((AuditLogVO)eventParam);
                    if (!iOperationLogGetResult) continue;
                    break;
                }
                catch (Throwable throwable) {
                    log.error("[PHOENIX-LOG] send auditLog error", throwable);
                }
            }
            if (!iOperationLogGetResult) {
                this.auditLogListener.operationLogGetErrorHandler();
            }
        }
        boolean pipelineServiceResult = false;
        for (int retryTimes = 0; retryTimes <= maxRetryTimes; ++retryTimes) {
        }
        if (!pipelineServiceResult && this.auditLogListener != null) {
            this.auditLogListener.pipelineErrorHandler();
        }
    }

    public PersistenceServiceImpl(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }
}

