/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.RoleGroupConvert;
import com.elitescloud.cloudt.system.model.vo.query.role.RoleGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleGroupSaveVO;
import com.elitescloud.cloudt.system.service.RoleGroupMngService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleRelatedDO;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRelatedRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class RoleGroupMngServiceImpl
implements RoleGroupMngService {
    @Autowired
    private RoleGroupRepoProc roleGroupRepoProc;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private RoleRelatedRepoProc roleRelatedRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(RoleGroupSaveVO saveVO, BelongType.Belonger belong) {
        if (belong == null) {
            belong = BelongType.getBelonger((boolean)false);
        }
        SysRoleGroupDO groupDO = null;
        if (saveVO.getId() == null) {
            if (CharSequenceUtil.isNotBlank((CharSequence)saveVO.getGroupCode()) && this.roleGroupRepoProc.existsCode(saveVO.getGroupCode(), belong)) {
                return ApiResult.fail((String)"\u5206\u7ec4\u7f16\u7801\u5df2\u5b58\u5728");
            }
            groupDO = RoleGroupConvert.INSTANCE.saveVo2DO(saveVO);
        } else {
            groupDO = (SysRoleGroupDO)this.roleGroupRepoProc.get(saveVO.getId());
            if (groupDO == null) {
                return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (CharSequenceUtil.isNotBlank((CharSequence)saveVO.getGroupCode()) && !saveVO.getGroupCode().equals(groupDO.getGroupCode()) && this.roleGroupRepoProc.existsCode(saveVO.getGroupCode(), belong)) {
                return ApiResult.fail((String)"\u5206\u7ec4\u7f16\u7801\u5df2\u5b58\u5728");
            }
            RoleGroupConvert.INSTANCE.copySaveVO(saveVO, groupDO);
        }
        groupDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)groupDO.getEnabled(), (Object)true));
        groupDO.setType(belong.getBelongType().getValue());
        groupDO.setTypeId(belong.getBelongId());
        this.roleGroupRepoProc.save((Serializable)groupDO);
        this.saveRelated(groupDO.getId().toString(), saveVO.getRelatedOrgCodes());
        return ApiResult.ok((Object)groupDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (id == -1L) {
            return ApiResult.fail((String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u53ef\u5220\u9664");
        }
        if (!this.roleGroupRepoProc.exists(id)) {
            return ApiResult.ok((Object)id);
        }
        if (this.roleRepoProc.existsGroupId(id)) {
            return ApiResult.fail((String)"\u8bf7\u5148\u5220\u9664\u7ec4\u5185\u7684\u89d2\u8272");
        }
        String groupCode = this.roleGroupRepoProc.getCode(id);
        this.roleGroupRepoProc.delete(id);
        this.roleRepoProc.clearGroupId(id);
        this.roleRelatedRepoProc.deletedByRoleCode(id.toString(), true);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        if (id == null) {
            return ApiResult.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.roleGroupRepoProc.exists(id)) {
            return ApiResult.ok((Object)id);
        }
        this.roleGroupRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateName(Long id, String name) {
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)name, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.roleGroupRepoProc.updateName(id, name);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<RoleGroupDetailRespVO> getDetail(Long id) {
        List<String> orgCodes;
        if (id == null) {
            return ApiResult.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysRoleGroupDO roleGroup = (SysRoleGroupDO)this.roleGroupRepoProc.get(id);
        if (roleGroup == null) {
            return ApiResult.noData();
        }
        RoleGroupDetailRespVO respVO = RoleGroupConvert.INSTANCE.do2DetailRespVO(roleGroup);
        List<SysRoleRelatedDO> relatedList = this.roleRelatedRepoProc.queryByRoleCode(roleGroup.getId().toString(), true);
        if (!relatedList.isEmpty() && !(orgCodes = relatedList.stream().filter(t -> "org".equals(t.getRelatedType())).map(SysRoleRelatedDO::getRelatedId).collect(Collectors.toList())).isEmpty()) {
            Map<String, String> nameMap = this.orgRepoProc.queryIdCodeNameByCodes(orgCodes).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, IdCodeNameParam::getName, (t1, t2) -> t1));
            respVO.setRelatedOrgCodes(orgCodes);
            respVO.setRelatedOrgNames(orgCodes.stream().map(nameMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<RoleGroupPageRespVO>> pageMng(RoleGroupPageQueryVO queryVO, BelongType.Belonger belong) {
        PagingVO pageData = this.roleGroupRepoProc.pageMng(queryVO, belong).map(RoleGroupConvert.INSTANCE::do2PageRespVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData);
        }
        List<Long> ids = pageData.stream().map(RoleGroupPageRespVO::getId).collect(Collectors.toList());
        Map<Long, Long> countMap = this.roleRepoProc.countByGroupId(ids);
        if (!countMap.isEmpty()) {
            pageData.each(t -> t.setRoleNum(countMap.getOrDefault(t.getId(), 0L)));
        }
        return ApiResult.ok((Object)pageData);
    }

    private void saveRelated(String groupCode, List<String> orgCodes) {
        List<SysRoleRelatedDO> relatedList;
        this.roleRelatedRepoProc.deletedByRoleCode(groupCode, true);
        if (CollUtil.isNotEmpty(orgCodes) && !(relatedList = orgCodes.stream().filter(CharSequenceUtil::isNotBlank).distinct().map(orgCode -> {
            SysRoleRelatedDO relatedDO = new SysRoleRelatedDO();
            relatedDO.setRelatedType("org");
            relatedDO.setRelatedId(orgCode);
            relatedDO.setRoleCode(groupCode);
            relatedDO.setRoleGroup(Boolean.valueOf(true));
            return relatedDO;
        }).toList()).isEmpty()) {
            this.roleRelatedRepoProc.save(relatedList);
        }
    }
}

