/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.repo.RoleGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class RoleQueryServiceImpl
extends BaseServiceImpl
implements RoleQueryService {
    private static final Logger log = LogManager.getLogger(RoleQueryServiceImpl.class);
    @Autowired
    private RoleRepoProc repoProc;
    @Autowired
    private RoleGroupRepoProc roleGroupRepoProc;

    @Override
    public ApiResult<List<IdCodeNameParam>> listRole(Boolean showAll, String businessKey, String roleName) {
        BelongType.Belonger belonger = showAll != null && showAll != false ? null : BelongType.getBelonger();
        List<IdCodeNameParam> dataList = this.repoProc.listQuery(belonger, businessKey, roleName);
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<Long> getIdByCode(String roleCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Long id = this.repoProc.getIdByCode(roleCode);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listCodeNamesById(Set<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        List<IdCodeNameParam> roles = this.repoProc.queryIdCodeNames(ids);
        return ApiResult.ok(roles);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listCodeNamesByCode(Set<String> codes) {
        if (CollUtil.isEmpty(codes)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        List<IdCodeNameParam> roles = this.repoProc.queryIdCodeNamesByCode(codes);
        return ApiResult.ok(roles);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRoleGroup(BelongType.Belonger belonger) {
        List<IdCodeNameParam> groupList = this.roleGroupRepoProc.listIdCodeName(belonger, true);
        ArrayList<IdCodeNameParam> dataList = new ArrayList<IdCodeNameParam>(groupList.size() + 4);
        dataList.add(new IdCodeNameParam(Long.valueOf(-1L), "", "\u9ed8\u8ba4\u5206\u7ec4"));
        dataList.addAll(groupList);
        return ApiResult.ok(dataList);
    }
}

