/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.entity.SysAlertConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysAlertDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigBaseRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigDingdingRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigWxWorkRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigBaseSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertSaveVO;
import com.elitescloud.cloudt.system.service.SysAlertMngService;
import com.elitescloud.cloudt.system.service.alert.AlertProvider;
import com.elitescloud.cloudt.system.service.impl.BaseAlertServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysAlertMngServiceImpl
extends BaseAlertServiceImpl
implements SysAlertMngService {
    private static final Logger log = LoggerFactory.getLogger(SysAlertMngServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveAlert(AlertSaveVO saveVO) {
        SysAlertConfigDO config;
        SysAlertDO alertDO = null;
        try {
            alertDO = this.checkForSave(saveVO);
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u9884\u8b66\u914d\u7f6e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.alertRepoProc.save((Serializable)((Object)alertDO));
        if (saveVO.getWxWorkSaveVO() != null) {
            SysAlertConfigDO config2 = this.convertConfigDO(saveVO.getWxWorkSaveVO(), saveVO.getBusinessType(), SysAlertType.WX_WORK);
            if (config2 != null) {
                this.alertConfigRepoProc.save((Serializable)((Object)config2));
            }
        } else if (saveVO.getDingdingWorkSaveVO() != null && (config = this.convertConfigDO(saveVO.getDingdingWorkSaveVO(), saveVO.getBusinessType(), SysAlertType.DINGDING)) != null) {
            this.alertConfigRepoProc.save((Serializable)((Object)config));
        }
        return ApiResult.ok((Object)alertDO.getId());
    }

    @Override
    public ApiResult<AlertRespVO> getAlert(String businessType) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        SysAlertDO alertDO = this.alertRepoProc.getByBusinessType(businessType);
        if (alertDO == null) {
            return ApiResult.ok(null);
        }
        Map<String, SysAlertConfigDO> configMap = this.alertConfigRepoProc.getByBusinessType(alertDO.getBusinessType()).stream().collect(Collectors.toMap(SysAlertConfigDO::getAlertType, t -> t, (t1, t2) -> t1));
        AlertRespVO respVO = new AlertRespVO();
        respVO.setId(alertDO.getId());
        respVO.setBusinessType(alertDO.getBusinessType());
        respVO.setEnabled(alertDO.getEnabled());
        respVO.setWxWorkRespVO((AlertConfigWxWorkRespVO)this.convertWorkConfig(configMap.get(SysAlertType.WX_WORK.name()), SysAlertType.WX_WORK));
        respVO.setDingdingRespVO((AlertConfigDingdingRespVO)this.convertWorkConfig(configMap.get(SysAlertType.DINGDING.name()), SysAlertType.DINGDING));
        respVO.setDescription(alertDO.getDescription());
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<CodeNameParam>> getTmplParam(String businessType) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        }
        ArrayList<CodeNameParam> codeNameParams = new ArrayList<CodeNameParam>(32);
        switch (businessType) {
            case "thirdApi": {
                codeNameParams.add(new CodeNameParam("{businessType}", "\u4e1a\u52a1\u7c7b\u578b"));
                codeNameParams.add(new CodeNameParam("{direction}", "\u8c03\u7528\u65b9\u5411"));
                codeNameParams.add(new CodeNameParam("{businessKey}", "\u5173\u952e\u53c2\u6570"));
                codeNameParams.add(new CodeNameParam("{reqTime}", "\u8bf7\u6c42\u65f6\u95f4"));
                codeNameParams.add(new CodeNameParam("{respTime}", "\u54cd\u5e94\u65f6\u95f4"));
                codeNameParams.add(new CodeNameParam("{sourceApp}", "\u6e90\u7cfb\u7edf"));
                codeNameParams.add(new CodeNameParam("{targetApp}", "\u76ee\u6807\u7cfb\u7edf"));
                codeNameParams.add(new CodeNameParam("{url}", "\u63a5\u53e3\u5730\u5740"));
                codeNameParams.add(new CodeNameParam("{failMsg}", "\u5931\u8d25\u4fe1\u606f"));
                break;
            }
            case "sqlExecute": {
                codeNameParams.add(new CodeNameParam("{success}", "\u6267\u884c\u72b6\u6001"));
                codeNameParams.add(new CodeNameParam("{failMsg}", "\u5931\u8d25\u4fe1\u606f"));
                codeNameParams.add(new CodeNameParam("{result}", "\u68c0\u67e5\u7ed3\u679c"));
                codeNameParams.add(new CodeNameParam("{rowNum}", "\u8bb0\u5f55\u6570\u91cf"));
                codeNameParams.add(new CodeNameParam("{operateType}", "\u64cd\u4f5c\u7c7b\u578b"));
                codeNameParams.add(new CodeNameParam("{sql}", "\u6267\u884cSQL"));
                codeNameParams.add(new CodeNameParam("{sqlName}", "SQL\u540d\u79f0"));
                codeNameParams.add(new CodeNameParam("{sqlCode}", "SQL\u7f16\u7801"));
                codeNameParams.add(new CodeNameParam("{category}", "\u5206\u7c7b"));
                codeNameParams.add(new CodeNameParam("{dsName}", "\u6570\u636e\u6e90\u540d\u79f0"));
                codeNameParams.add(new CodeNameParam("{startTime}", "\u5f00\u59cb\u65f6\u95f4"));
                codeNameParams.add(new CodeNameParam("{finishTime}", "\u7ed3\u675f\u65f6\u95f4"));
                codeNameParams.add(new CodeNameParam("{costTime}", "\u8017\u65f6"));
                break;
            }
            default: {
                return ApiResult.fail((String)"\u6682\u4e0d\u652f\u6301");
            }
        }
        return ApiResult.ok(codeNameParams);
    }

    private SysAlertDO checkForSave(AlertSaveVO saveVO) {
        SysAlertDO alertDO = this.alertRepoProc.getByBusinessType(saveVO.getBusinessType());
        if (saveVO.getId() == null) {
            Assert.isNull((Object)((Object)alertDO), (String)"\u9884\u8b66\u7c7b\u578b\u5df2\u5b58\u5728", (Object[])new Object[0]);
            alertDO = new SysAlertDO();
            alertDO.setBusinessType(saveVO.getBusinessType());
        } else {
            Assert.isTrue((alertDO != null && alertDO.getId().equals(saveVO.getId()) ? 1 : 0) != 0, (String)"\u9884\u8b66\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        }
        Objects.requireNonNull(alertDO);
        alertDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)true));
        alertDO.setDescription(saveVO.getDescription());
        return alertDO;
    }

    private SysAlertConfigDO convertConfigDO(AlertConfigBaseSaveVO configSaveVO, String businessType, SysAlertType alertType) {
        if (configSaveVO == null) {
            log.info("\u63d0\u9192\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        SysAlertConfigDO configDO = this.alertConfigRepoProc.getByBusinessType(businessType, alertType.name());
        if (configSaveVO.getId() == null) {
            Assert.isNull((Object)((Object)configDO), (String)"\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u5df2\u5b58\u5728", (Object[])new Object[0]);
            configDO = new SysAlertConfigDO();
            configDO.setBusinessType(businessType);
            configDO.setAlertType(alertType.name());
        }
        configDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)configSaveVO.getEnabled(), (Object)true));
        configDO.setDescription(configSaveVO.getDescription());
        AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO> alertProvider = super.getAlertProvider(alertType);
        Assert.notNull(alertProvider, (String)("\u6682\u4e0d\u652f\u6301\uff1a" + alertType.name()), (Object[])new Object[0]);
        configDO.setCfgJson(alertProvider.toString(configSaveVO));
        return configDO;
    }

    private AlertConfigBaseRespVO convertWorkConfig(SysAlertConfigDO configDO, SysAlertType alertType) {
        if (configDO == null) {
            return null;
        }
        AlertProvider<? extends AlertConfigBaseSaveVO, ? extends AlertConfigBaseRespVO> alertProvider = super.getAlertProvider(alertType);
        Assert.notNull(alertProvider, (String)("\u6682\u4e0d\u652f\u6301\uff1a" + alertType.name()), (Object[])new Object[0]);
        AlertConfigBaseRespVO respVO = alertProvider.parse(configDO.getCfgJson());
        respVO.setId(configDO.getId());
        respVO.setEnabled(configDO.getEnabled());
        respVO.setDescription(configDO.getDescription());
        return respVO;
    }
}

